### R code from vignette source 'CompGO.Rnw'

###################################################
### code chunk number 1: CompGO.Rnw:36-47
###################################################
library(CompGO)
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
data(bed.sample)
# Here we create the GRanges object:
sample.range = GRanges(seqnames=bed.sample$chr,
    IRanges(start=bed.sample$start, end=bed.sample$end))
# Note that the window around the .bed region beyond which
# genes are cutoff is 5kb, this is modifiable
sample.annotated = annotateBedFromDb(gRanges = sample.range,
    db = TxDb.Mmusculus.UCSC.mm9.knownGene)
head(sample.annotated)


###################################################
### code chunk number 2: CompGO.Rnw:52-66
###################################################
# fnAnot = getFnAnot_genome(sample.annotated$gene_id,
#    email = "P.Lace-holder@inst.edu", listName="sample")
# We instead use examples taken from the RDAVIDWebService package
# to illustrate the utility of this package:
data(funChart1)
data(funChart2)
funChart1 = subset(funChart1, Category %in%
    c("GOTERM_BP_ALL", "GOTERM_MF_ALL", "GOTERM_CC_ALL"))
funChart2 = subset(funChart2, Category %in%
    c("GOTERM_BP_ALL", "GOTERM_MF_ALL", "GOTERM_CC_ALL"))
str(funChart1)
# once the charts have been retrieved, they can be written
# to disk for subsequent batch processing like so:
# write.table(funChart1, "./path/to/text.txt")


###################################################
### code chunk number 3: fig1
###################################################
plotZScores(funChart1, funChart2)


###################################################
### code chunk number 4: fig2
###################################################
plotTwoGODags(funChart1, funChart2, ont="MF", cutoff=0.01)


