### R code from vignette source 'AnnotationHubRecipes.Rnw'

###################################################
### code chunk number 1: exampleGTFProcessing
###################################################
makeEnsemblGTFsToAHMs <- function(){
    baseUrl <- .ensemblBaseUrl
    sourceUrl <- .ensemblGtfSourceUrls(.ensemblBaseUrl)
    
    sourceFile <- .ensemblSourcePathFromUrl(baseUrl, sourceUrl)
    meta <- .ensemblMetadataFromUrl(sourceUrl)
    rdata <- sub(".gz$", ".RData", sourceFile)
    description <- paste("Gene Annotation for", meta$species)

    Map(AnnotationHubMetadata,
        AnnotationHubRoot=meta$annotationHubRoot,
        Description=description, Genome=meta$genome,
        SourceFile=sourceFile, SourceUrl=sourceUrl,
        SourceVersion=meta$sourceVersion, Species=meta$species,
        TaxonomyId=meta$taxonomyId, Title=meta$title,
        MoreArgs=list(
          Coordinate_1_based = TRUE,
          DataProvider = "ftp.ensembl.org",
          Maintainer = "Martin Morgan <mtmorgan@fhcrc.org>",
          RDataClass = "GRanges",
          RDataDateAdded = Sys.time(),
          RDataVersion = "0.0.1",
          Recipe = c("ensemblGtfToGRangesRecipe", package="AnnotationHubData"),
          Tags = c("GTF", "ensembl", "Gene", "Transcript", "Annotation")))
}


###################################################
### code chunk number 2: exampleRecipe
###################################################
ensemblGTFToGRangesRecipe <- function(recipe){
     require(rtracklayer)
    gz.inputFile <- inputFiles(recipe)[1]
    con <- gzfile(gz.inputFile)
    on.exit(close(con))
    gr <- import(con, "gtf", asRangedData=FALSE)
    save(gr, file=outputFile(recipe))
    outputFile(recipe)
}


###################################################
### code chunk number 3: makeAnnotationHubResource (eval = FALSE)
###################################################
## makeAnnotationHubResource("EnsemblGtfImportPreparer",
##                           makeEnsemblGTFsToAHMs)
## 


###################################################
### code chunk number 4: SessionInfo
###################################################
sessionInfo()


