### R code from vignette source 'ASSIGN.vignette.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: setup
###################################################
## create a temporary directory
dir.create("tempdir")
tempdir <- "tempdir"
library(ASSIGN)


###################################################
### code chunk number 2: datasets-and-labels
###################################################
data(trainingData1)
data(testData1)
data(geneList1)
trainingLabel1 <- list(control = list(bcat=1:10, e2f3=1:10, 
                                      myc=1:10, ras=1:10, src=1:10), 
                       bcat = 11:19, e2f3 = 20:28, myc= 29:38, 
                       ras = 39:48, src = 49:55)
testLabel1 <- rep(c("subtypeA","subtypeB"),c(53,58)) 


###################################################
### code chunk number 3: all-in-one-assign-wrapper-example1
###################################################
# Example 1: training dataset is available; 
# the gene list of pathway signature is NOT available
assign.wrapper(trainingData=trainingData1, testData=testData1, 
               trainingLabel=trainingLabel1, testLabel=testLabel1, 
               geneList=NULL, n_sigGene=rep(200,5), adaptive_B=TRUE, 
               adaptive_S=FALSE, mixture_beta=TRUE, outputDir= tempdir, 
               iter=20, burn_in=10)


###################################################
### code chunk number 4: all-in-one-assign-wrapper-example2
###################################################
# Example 2: training dataset is available; 
# the gene list of pathway signature is available
assign.wrapper(trainingData=trainingData1, testData=testData1, 
               trainingLabel=trainingLabel1, testLabel=NULL, 
               geneList=geneList1, n_sigGene=NULL, adaptive_B=TRUE, 
               adaptive_S=FALSE, mixture_beta=TRUE, 
               outputDir=tempdir, iter=20, burn_in=10)


###################################################
### code chunk number 5: all-in-one-assign-wrapper-example3
###################################################
#Example 3: training dataset is NOT available; 
#the gene list of pathway signature is available
assign.wrapper(trainingData=NULL, testData=testData1, 
               trainingLabel=NULL, testLabel=NULL, 
               geneList=geneList1, n_sigGene=NULL, adaptive_B=TRUE, 
               adaptive_S=TRUE, mixture_beta=TRUE, 
               outputDir= tempdir, iter=20, burn_in=10)


###################################################
### code chunk number 6: assign-preprocess-function
###################################################
# training dataset is available; 
# the gene list of pathway signature is NOT available
processed.data <- assign.preprocess(trainingData=trainingData1, 
                                    testData=testData1, 
                                    trainingLabel=trainingLabel1, 
                                    geneList=NULL, n_sigGene=rep(200,5))


###################################################
### code chunk number 7: assign-preprocess-function
###################################################
# training dataset is available; 
# the gene list of pathway signature is available
processed.data <- assign.preprocess(trainingData=trainingData1, 
                                    testData=testData1, 
                                    trainingLabel=trainingLabel1, 
                                    geneList=geneList1)


###################################################
### code chunk number 8: assign-preprocess-function (eval = FALSE)
###################################################
## # training dataset is NOT available; 
## # the gene list of pathway signature is available
## processed.data <- assign.preprocess(trainingData=NULL, 
##                                     testData=testData1, 
##                                     trainingLabel=NULL, 
##                                     geneList=geneList1)


###################################################
### code chunk number 9: assign-mcmc-function
###################################################
mcmc.chain <- assign.mcmc(Y=processed.data$testData_sub, 
                          Bg = processed.data$B_vector, 
                          X=processed.data$S_matrix, 
                          Delta_prior_p = processed.data$Pi_matrix, 
                          iter = 20, adaptive_B=TRUE, 
                          adaptive_S=FALSE, mixture_beta=TRUE)


###################################################
### code chunk number 10: assign-convergence-function
###################################################
trace.plot <- assign.convergence(test=mcmc.chain, burn_in=0, iter=20, 
                                 parameter="B", whichGene=1, 
                                 whichSample=NA, whichPath=NA)


###################################################
### code chunk number 11: assign-summary-function
###################################################
mcmc.pos.mean <- assign.summary(test=mcmc.chain, burn_in=10, 
                                iter=20, adaptive_B=TRUE, 
                                adaptive_S=FALSE,mixture_beta=TRUE)


###################################################
### code chunk number 12: assign-output-function
###################################################
assign.output(processed.data=processed.data, 
              mcmc.pos.mean.testData=mcmc.pos.mean, 
              trainingData=trainingData1, testData=testData1, 
              trainingLabel=trainingLabel1, 
              testLabel=testLabel1, geneList=NULL, 
              adaptive_B=TRUE, adaptive_S=FALSE, 
              mixture_beta=TRUE, outputDir=tempdir)


###################################################
### code chunk number 13: assign-cv-output-function (eval = FALSE)
###################################################
## # For cross-validation, Y in the assign.mcmc function 
## # should be specified as processed.data$trainingData_sub. 
## assign.cv.output(processed.data=processed.data, 
##                  mcmc.pos.mean.trainingData=mcmc.pos.mean,
##                  trainingData=trainingData1,
##                  trainingLabel=trainingLabel1, adaptive_B=FALSE, 
##                  adaptive_S=FALSE, mixture_beta=TRUE, 
##                  outputDir= tempdir) 


