/*
 * Decompiled with CFR 0.152.
 */
package facs;

import java.util.ArrayList;
import java.util.Collections;

public final class PopulationReference {
    private static final int[] EMPTY_GATE_SET_ID_ARRAY = new int[0];
    private static final int DEFAULT_TYPE = -1;
    private static final int DEFAULT_EVENT_COUNT = 0;
    private static final int DEFAULT_CHANNEL = -1;
    private final int experimentID;
    private final String filename;
    private int[] gateSetIDs;
    private final int compensationID;
    private final int type;
    private final int eventCount;
    private final int channel;
    public static final String POP_REF_PARAM_NAME = "populationReference";
    public static final String FILENAME_PARAM_NAME = "filename";
    public static final String TYPE_PARAM_NAME = "type";
    public static final String POP_REF_CHANNEL_PARAM_NAME = "popRefChannel";
    public static final String GATE_SET_IDS_PARAM_NAME = "gateSetID";
    public static final String EVENT_COUNT_PARAM_NAME = "eventCount";
    public static final String COMPENSATION_ID_PARAM_NAME = "compensationID";
    public static final String EXPERIMENT_ID_PARAM_NAME = "experimentID";

    private PopulationReference(int experimentID, String filename, int[] gateSetIDs, int compensationID, int type, int eventCount, int channel) {
        this.experimentID = experimentID;
        this.filename = filename;
        if (gateSetIDs == null || gateSetIDs.length <= 0) {
            this.gateSetIDs = new int[0];
        } else {
            this.gateSetIDs = new int[gateSetIDs.length];
            System.arraycopy(gateSetIDs, 0, this.gateSetIDs, 0, gateSetIDs.length);
        }
        this.compensationID = compensationID;
        this.type = type;
        this.eventCount = eventCount;
        this.channel = channel;
    }

    public int getExperimentID() {
        return this.experimentID;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getGateSetCount() {
        return this.gateSetIDs.length;
    }

    public int[] getGateSetIDs() {
        int[] gateSetIDArray = new int[this.gateSetIDs.length];
        System.arraycopy(this.gateSetIDs, 0, gateSetIDArray, 0, this.gateSetIDs.length);
        return gateSetIDArray;
    }

    public int getCompensationID() {
        return this.compensationID;
    }

    public int getType() {
        return this.type;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isSamePopulation(PopulationReference ref) {
        if (ref == null) {
            return false;
        }
        if (this.experimentID != ref.experimentID) {
            return false;
        }
        if (this.gateSetIDs.length != ref.gateSetIDs.length) {
            return false;
        }
        if (this.compensationID != ref.compensationID) {
            return false;
        }
        if (this.type != ref.type) {
            return false;
        }
        if (this.eventCount != ref.eventCount) {
            return false;
        }
        for (int i = 0; i < this.gateSetIDs.length; ++i) {
            if (this.gateSetIDs[i] == ref.gateSetIDs[i]) continue;
            return false;
        }
        return !(this.filename == null && ref.filename != null || this.filename != null && ref.filename == null) && (this.filename == null || this.filename.equals(ref.filename));
    }

    public static PopulationReference getPopulationReference(int experimentID, String filename, int gateSetID, int compensationID) {
        return PopulationReference.getPopulationReference(experimentID, filename, gateSetID, compensationID, -1, 0, -1);
    }

    public static PopulationReference getPopulationReference(int experimentID, String filename, int gateSetID, int compensationID, int type, int eventCount) {
        return PopulationReference.getPopulationReference(experimentID, filename, gateSetID, compensationID, type, eventCount, -1);
    }

    public static PopulationReference getPopulationReference(int experimentID, String filename, int gateSetID, int compensationID, int channel) {
        return PopulationReference.getPopulationReference(experimentID, filename, gateSetID, compensationID, -1, 0, channel);
    }

    public static PopulationReference getPopulationReference(int experimentID, String filename, int gateSetID, int compensationID, int type, int eventCount, int channel) {
        if (gateSetID > 0) {
            int[] ids = new int[]{gateSetID};
            return PopulationReference.getPopulationReference(experimentID, filename, ids, compensationID, type, eventCount, channel);
        }
        return PopulationReference.getPopulationReference(experimentID, filename, EMPTY_GATE_SET_ID_ARRAY, compensationID, type, eventCount, channel);
    }

    public static PopulationReference getPopulationReference(int experimentID, String filename, int[] gateSetIDs, int compensationID, int channel) {
        return PopulationReference.getPopulationReference(experimentID, filename, gateSetIDs, compensationID, -1, 0, channel);
    }

    public static PopulationReference getPopulationReference(int experimentID, String filename, int[] gateSetIDs, int compensationID, int type, int eventCount, int channel) {
        int i;
        ArrayList<Integer> gateSetIDList = new ArrayList<Integer>();
        if (gateSetIDs != null && gateSetIDs.length > 0) {
            for (i = 0; i < gateSetIDs.length; ++i) {
                Integer integer;
                if (gateSetIDs[i] <= 0 || gateSetIDList.contains(integer = Integer.valueOf(gateSetIDs[i]))) continue;
                gateSetIDList.add(integer);
            }
            if (gateSetIDList.size() > 1) {
                Collections.sort(gateSetIDList);
            }
        }
        int[] gateSetIDArray = new int[gateSetIDList.size()];
        for (i = 0; i < gateSetIDList.size(); ++i) {
            gateSetIDArray[i] = (Integer)gateSetIDList.get(i);
        }
        return new PopulationReference(experimentID, filename, gateSetIDArray, compensationID, type, eventCount, channel);
    }

    private void print() {
        System.out.println("Experiment ID: " + this.getExperimentID());
        System.out.println("Filename: " + this.getFilename());
        System.out.println("Compensation ID: " + this.getCompensationID());
        System.out.println("Applicable Gate Set IDs (" + this.getGateSetCount() + "):");
        System.out.println("---");
        int[] idArray = this.getGateSetIDs();
        for (int i = 0; i < idArray.length; ++i) {
            System.out.println(idArray[i]);
        }
        System.out.println("Type: " + this.getType());
        System.out.println("Event Count: " + this.getEventCount());
        System.out.println("Channel: " + this.getChannel());
    }
}

