/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.CanvasSettings;
import facs.PopulationReference;

public final class PopulationGrid {
    public static final int NO_STATISTIC = -1;
    public static final int MEAN = 1;
    public static final int MEDIAN = 2;
    public static final int STANDARD_DEVIATION = 3;
    public static final int VARIANCE = 4;
    public static final int MINIMUM = 5;
    public static final int MAXIMUM = 6;
    public static final int FILE_INDEX = 7;
    public static final int PERCENT = 8;
    public static final int EVENT_COUNT = 9;
    public static final int CHANNEL_RANGE = 10;
    public static final int GEOMETRIC_MEAN = 11;
    public static final int NINETYFIFTH_PERCENTILE = 12;
    public static final int ARCSINH_MEDIAN = 13;
    public static final int NO_EQUATION = -1;
    public static final int RATIO = 1;
    public static final int LOG_RATIO = 2;
    public static final int FOLD = 3;
    public static final int CUSTOM = 4;
    public static final int LOG2_RATIO = 5;
    public static final int DIFFERENCE = 6;
    public static final int[] VALID_EQUATIONS = new int[]{1, 2, 3, 4, 5, 6};
    public static final int NO_CONTROL = -1;
    public static final int BY_CELL = 0;
    public static final int BY_ROW = 1;
    public static final int BY_COLUMN = 2;
    public static final int TABLE_MIN = 3;
    public static final int TABLE_MAX = 4;
    public static final int ROW_MIN = 5;
    public static final int ROW_MAX = 6;
    public static final int COLUMN_MIN = 7;
    public static final int COLUMN_MAX = 8;
    public static final int ROW_1 = 9;
    public static final int COLUMN_1 = 10;
    public static final int CELL_1_1 = 11;
    public static final int[] VALID_CONTROLS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final String LAYER_NAME = "Layer";
    private static final String ROW_NAME = "Row";
    private static final String COLUMN_NAME = "Column";
    private static final String CHANNEL_NAME = "Channel";
    private static final String MEAN_NAME = "Mean";
    private static final String MEDIAN_NAME = "Median";
    private static final String STANDARD_DEVIATION_NAME = "SD";
    private static final String VARIANCE_NAME = "Variance";
    private static final String MINIMUM_NAME = "Minimum";
    private static final String MAXIMUM_NAME = "Maximum";
    private static final String PERCENT_NAME = "Percent";
    private static final String EVENT_COUNT_NAME = "EventCount";
    private static final String CHANNEL_RANGE_NAME = "ChannelRange";
    private static final String GEOMETRIC_MEAN_NAME = "GeometricMean";
    private static final String VALUE_NAME = "Value";
    private static final String NINETYFIFTH_PERCENTILE_NAME = "95th Percentile";
    private static final String ARCSINH_MEDIAN_NAME = "ArcsinhMedian";
    private static final double DEFAULT_VALUE = Double.NaN;
    private final int layerCount;
    private final int rowCount;
    private final int columnCount;
    private String[] rowLabels;
    private String[] columnLabels;
    private PopulationReference[][][] grid;
    private int statistic;
    private int equation;
    private int populationCutoff;
    private String formula;
    private int control;
    private int controlRow;
    private int controlColumn;
    private boolean dirtyP;
    private double[][][] values;
    private CanvasSettings cs;
    private double[][][][] densities;

    private PopulationGrid(PopulationReference[][][] grid, String[] rowLabels, String[] columnLabels, int layerCount, int rowCount, int columnCount) {
        int i;
        this.layerCount = layerCount;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.rowLabels = new String[this.rowCount];
        if (rowLabels == null || rowLabels.length <= 0) {
            for (i = 0; i < this.rowCount; ++i) {
                this.rowLabels[i] = "";
            }
        } else if (rowLabels.length < this.rowCount) {
            System.arraycopy(rowLabels, 0, this.rowLabels, 0, rowLabels.length);
            for (i = rowLabels.length; i < this.rowCount; ++i) {
                this.rowLabels[i] = "";
            }
        } else {
            System.arraycopy(rowLabels, 0, this.rowLabels, 0, this.rowCount);
        }
        this.columnLabels = new String[this.columnCount];
        if (columnLabels == null || columnLabels.length <= 0) {
            for (i = 0; i < this.columnCount; ++i) {
                this.columnLabels[i] = "";
            }
        } else if (columnLabels.length < this.columnCount) {
            System.arraycopy(columnLabels, 0, this.columnLabels, 0, columnLabels.length);
            for (i = columnLabels.length; i < this.columnCount; ++i) {
                this.columnLabels[i] = "";
            }
        } else {
            System.arraycopy(columnLabels, 0, this.columnLabels, 0, this.columnCount);
        }
        this.grid = new PopulationReference[this.layerCount][this.rowCount][this.columnCount];
        for (i = 0; i < this.layerCount; ++i) {
            for (int j = 0; j < this.rowCount; ++j) {
                for (int k = 0; k < this.columnCount; ++k) {
                    this.grid[i][j][k] = grid[i][j][k];
                }
            }
        }
        this.statistic = -1;
        this.equation = -1;
        this.populationCutoff = -1;
        this.formula = null;
        this.control = -1;
        this.controlRow = -1;
        this.controlColumn = -1;
        this.dirtyP = true;
        this.values = null;
        this.cs = null;
        this.densities = null;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String[] getRowLabels() {
        String[] labels = new String[this.rowLabels.length];
        System.arraycopy(this.rowLabels, 0, labels, 0, this.rowLabels.length);
        return labels;
    }

    public String[] getColumnLabels() {
        String[] labels = new String[this.columnLabels.length];
        System.arraycopy(this.columnLabels, 0, labels, 0, this.columnLabels.length);
        return labels;
    }

    public PopulationReference[][][] getGrid() {
        return this.grid;
    }

    public PopulationReference[][] getLayer(int layer) {
        if (layer < 0 || layer >= this.layerCount) {
            return new PopulationReference[0][0];
        }
        return this.grid[layer];
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int statistic) {
        if (statistic < -1) {
            return;
        }
        this.dirtyP = true;
        switch (statistic) {
            case 1: {
                this.statistic = 1;
                return;
            }
            case 2: {
                this.statistic = 2;
                return;
            }
            case 3: {
                this.statistic = 3;
                return;
            }
            case 4: {
                this.statistic = 4;
                return;
            }
            case 5: {
                this.statistic = 5;
                return;
            }
            case 6: {
                this.statistic = 6;
                return;
            }
            case 7: {
                this.statistic = 7;
                return;
            }
            case 8: {
                this.statistic = 8;
                return;
            }
            case 9: {
                this.statistic = 9;
                return;
            }
            case 10: {
                this.statistic = 10;
                return;
            }
            case 11: {
                this.statistic = 11;
                return;
            }
            case 12: {
                this.statistic = 12;
                return;
            }
            case 13: {
                this.statistic = 13;
                return;
            }
        }
        this.statistic = -1;
    }

    public int getEquation() {
        return this.equation;
    }

    public void setEquation(int equation) {
        if (equation < -1) {
            return;
        }
        this.dirtyP = true;
        switch (equation) {
            case 1: {
                this.equation = 1;
                return;
            }
            case 6: {
                this.equation = 6;
                return;
            }
            case 2: {
                this.equation = 2;
                return;
            }
            case 5: {
                this.equation = 5;
                return;
            }
            case 3: {
                this.equation = 3;
                return;
            }
            case 4: {
                this.equation = 4;
                return;
            }
        }
        this.equation = -1;
    }

    public int getPopulationCutoff() {
        return this.populationCutoff;
    }

    public void setPopulationCutoff(int populationCutoff) {
        this.populationCutoff = populationCutoff;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
        this.dirtyP = true;
    }

    public int getControl() {
        return this.control;
    }

    public void setControl(int control) {
        if (control < -1) {
            return;
        }
        this.dirtyP = true;
        switch (control) {
            case 0: {
                this.control = 0;
                return;
            }
            case 1: {
                this.control = 1;
                return;
            }
            case 2: {
                this.control = 2;
                return;
            }
            case 3: {
                this.control = 3;
                return;
            }
            case 4: {
                this.control = 4;
                return;
            }
            case 11: {
                this.control = 11;
                return;
            }
            case 5: {
                this.control = 5;
                return;
            }
            case 6: {
                this.control = 6;
                return;
            }
            case 9: {
                this.control = 9;
                return;
            }
            case 7: {
                this.control = 7;
                return;
            }
            case 8: {
                this.control = 8;
                return;
            }
            case 10: {
                this.control = 10;
                return;
            }
        }
        this.control = -1;
        this.controlRow = -1;
        this.controlColumn = -1;
    }

    public int getControlRow() {
        return this.controlRow;
    }

    public void setControlRow(int row) {
        if (row >= -1 && row < this.rowCount) {
            this.controlRow = row;
            this.dirtyP = true;
        }
    }

    public int getControlColumn() {
        return this.controlColumn;
    }

    public void setControlColumn(int column) {
        if (column >= -1 && column < this.columnCount) {
            this.controlColumn = column;
            this.dirtyP = true;
        }
    }

    public void setCanvasSettings(CanvasSettings cs) {
        this.cs = cs;
    }

    private double[][][] getRatios(double control) {
        if (this.layerCount <= 0 || this.rowCount <= 0 || this.columnCount <= 0) {
            return new double[0][0][0];
        }
        double[][][] ratios = new double[this.layerCount][this.rowCount][this.columnCount];
        for (int i = 0; i < this.layerCount; ++i) {
            for (int j = 0; j < this.rowCount; ++j) {
                for (int k = 0; k < this.columnCount; ++k) {
                    ratios[i][j][k] = this.equation == 3 ? (control > this.values[i][j][k] ? -control / this.values[i][j][k] + 1.0 : this.values[i][j][k] / control - 1.0) : (this.equation == 6 ? this.values[i][j][k] - control : this.values[i][j][k] / control);
                    if (this.equation == 2) {
                        ratios[i][j][k] = Math.log10(ratios[i][j][k]);
                    }
                    if (this.equation != 5) continue;
                    ratios[i][j][k] = Math.log(ratios[i][j][k]) / Math.log(2.0);
                }
            }
        }
        return ratios;
    }

    private double[][][] getRatios(int row, int column) {
        if (this.layerCount <= 0 || row < 0 || row >= this.rowCount || column < 0 || column >= this.columnCount) {
            return new double[0][0][0];
        }
        return this.getRatios(this.values[0][row][column]);
    }

    private double[][][] getRatios(int index, boolean rowP) {
        if (this.layerCount <= 0) {
            return new double[0][0][0];
        }
        if (rowP ? index < 0 || index >= this.rowCount : index < 0 || index >= this.columnCount) {
            return new double[0][0][0];
        }
        double[][][] ratios = new double[this.layerCount][this.rowCount][this.columnCount];
        for (int i = 0; i < this.layerCount; ++i) {
            for (int j = 0; j < this.rowCount; ++j) {
                for (int k = 0; k < this.columnCount; ++k) {
                    ratios[i][j][k] = rowP ? (this.equation == 3 ? (this.values[0][index][k] > this.values[i][j][k] ? -this.values[0][index][k] / this.values[i][j][k] + 1.0 : this.values[i][j][k] / this.values[0][index][k] - 1.0) : (this.equation == 6 ? this.values[i][j][k] - this.values[0][index][k] : this.values[i][j][k] / this.values[0][index][k])) : (this.equation == 3 ? (this.values[0][j][index] > this.values[i][j][k] ? -this.values[0][j][index] / this.values[i][j][k] + 1.0 : this.values[i][j][k] / this.values[0][j][index] - 1.0) : (this.equation == 6 ? this.values[i][j][k] - this.values[0][j][index] : this.values[i][j][k] / this.values[0][j][index]));
                    if (this.equation == 2) {
                        ratios[i][j][k] = Math.log10(ratios[i][j][k]);
                    }
                    if (this.equation != 5) continue;
                    ratios[i][j][k] = Math.log(ratios[i][j][k]) / Math.log(2.0);
                }
            }
        }
        return ratios;
    }

    private double[][][] getRatiosByRowExtremum(boolean minP) {
        if (this.layerCount <= 0 || this.rowCount <= 0 || this.columnCount <= 0) {
            return new double[0][0][0];
        }
        double[][][] ratios = new double[this.layerCount][this.rowCount][this.columnCount];
        for (int j = 0; j < this.rowCount; ++j) {
            double control = 1.0;
            if (this.columnCount > 0) {
                control = minP ? PopulationGrid.getMin(this.values[0][j]) : PopulationGrid.getMax(this.values[0][j]);
            }
            for (int i = 0; i < this.layerCount; ++i) {
                for (int k = 0; k < this.columnCount; ++k) {
                    ratios[i][j][k] = this.equation == 3 ? (control > this.values[i][j][k] ? -control / this.values[i][j][k] + 1.0 : this.values[i][j][k] / control - 1.0) : (this.equation == 6 ? this.values[i][j][k] - control : this.values[i][j][k] / control);
                    if (this.equation == 2) {
                        ratios[i][j][k] = Math.log10(ratios[i][j][k]);
                    }
                    if (this.equation != 5) continue;
                    ratios[i][j][k] = Math.log(ratios[i][j][k]) / Math.log(2.0);
                }
            }
        }
        return ratios;
    }

    private double[][][] getRatiosByColumnExtremum(boolean minP) {
        if (this.layerCount <= 0 || this.rowCount <= 0 || this.columnCount <= 0) {
            return new double[0][0][0];
        }
        double[][][] ratios = new double[this.layerCount][this.rowCount][this.columnCount];
        double[] columnValues = new double[this.rowCount];
        for (int k = 0; k < this.columnCount; ++k) {
            double control = 1.0;
            if (this.rowCount > 0) {
                for (int j = 0; j < this.rowCount; ++j) {
                    columnValues[j] = this.values[0][j][k];
                }
                control = minP ? PopulationGrid.getMin(columnValues) : PopulationGrid.getMax(columnValues);
            }
            for (int i = 0; i < this.layerCount; ++i) {
                for (int j = 0; j < this.rowCount; ++j) {
                    ratios[i][j][k] = this.equation == 3 ? (control > this.values[i][j][k] ? -control / this.values[i][j][k] + 1.0 : this.values[i][j][k] / control - 1.0) : (this.equation == 6 ? this.values[i][j][k] - control : this.values[i][j][k] / control);
                    if (this.equation == 2) {
                        ratios[i][j][k] = Math.log10(ratios[i][j][k]);
                    }
                    if (this.equation != 5) continue;
                    ratios[i][j][k] = Math.log(ratios[i][j][k]) / Math.log(2.0);
                }
            }
        }
        return ratios;
    }

    public PopulationReference getPopulationReference(int layer, int row, int column) {
        if (layer < 0 || layer >= this.layerCount || row < 0 || row >= this.rowCount || column < 0 || column >= this.columnCount || this.grid == null) {
            return null;
        }
        return this.grid[layer][row][column];
    }

    public double[] getDensities(int layer, int row, int column) {
        if (layer < 0 || layer >= this.layerCount || row < 0 || row >= this.rowCount || column < 0 || column >= this.columnCount || this.cs == null || this.densities == null) {
            return new double[0];
        }
        return this.densities[layer][row][column];
    }

    public double getInflection() {
        if (this.isBidirectional()) {
            double inflection = 0.0;
            if (this.equation == 2 || this.equation == 5) {
                inflection = 0.0;
            } else if (this.equation == 3 || this.equation == 1) {
                inflection = 0.0;
            }
            return inflection;
        }
        return Double.NaN;
    }

    public boolean isUnidirectional() {
        return !this.isBidirectional();
    }

    public boolean isBidirectional() {
        if (this.equation == 6 || this.equation == 1 || this.equation == 2 || this.equation == 5 || this.equation == 3) {
            return this.control == 0 || this.control == 1 || this.control == 2 || this.control == 9 || this.control == 10 || this.control == 11;
        }
        return false;
    }

    public boolean isMinimum() {
        if (this.isBidirectional()) {
            return false;
        }
        return !this.isMaximum();
    }

    public boolean isMaximum() {
        if (this.isBidirectional()) {
            return false;
        }
        if (this.equation == 6 || this.equation == 1 || this.equation == 2 || this.equation == 5 || this.equation == 3) {
            return this.control == 4 || this.control == 6 || this.control == 8;
        }
        return false;
    }

    public static double getMin(double[] values) {
        if (values == null || values.length <= 0) {
            return Double.NaN;
        }
        double min = Double.NaN;
        boolean firstP = true;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            if (firstP) {
                min = values[i];
                firstP = false;
                continue;
            }
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    public static double getMin(double[][] values) {
        if (values == null || values.length <= 0) {
            return Double.NaN;
        }
        double[] mins = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            mins[i] = PopulationGrid.getMin(values[i]);
        }
        return PopulationGrid.getMin(mins);
    }

    public static double getMin(double[][][] values) {
        if (values == null || values.length <= 0) {
            return Double.NaN;
        }
        double[] mins = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            mins[i] = PopulationGrid.getMin(values[i]);
        }
        return PopulationGrid.getMin(mins);
    }

    public static double getMax(double[] values) {
        if (values == null || values.length <= 0) {
            return Double.NaN;
        }
        double max = Double.NaN;
        boolean firstP = true;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            if (firstP) {
                max = values[i];
                firstP = false;
                continue;
            }
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    public static double getMax(double[][] values) {
        if (values == null || values.length <= 0) {
            return Double.NaN;
        }
        double[] maxs = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            maxs[i] = PopulationGrid.getMax(values[i]);
        }
        return PopulationGrid.getMax(maxs);
    }

    public static double getMax(double[][][] values) {
        if (values == null || values.length <= 0) {
            return Double.NaN;
        }
        double[] maxs = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            maxs[i] = PopulationGrid.getMax(values[i]);
        }
        return PopulationGrid.getMax(maxs);
    }

    private void print() {
        for (int i = 0; i < this.layerCount; ++i) {
            for (int j = 0; j < this.rowCount; ++j) {
                for (int k = 0; k < this.columnCount; ++k) {
                    if (k > 0) {
                        System.out.print("\t");
                    }
                    if (this.grid[i][j][k] == null) {
                        System.out.print("null");
                        continue;
                    }
                    System.out.print(this.grid[i][j][k].getFilename());
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        System.out.println("(Double.NaN == Double.NaN) = false");
        System.out.println("(Double.NaN != Double.NaN) = true");
        System.out.println("(Double.NaN < 0) = false");
        System.out.println("(Double.NaN == 0) = false");
        System.out.println("(Double.NaN > 0) = false");
        System.out.println("(Double.NaN / 100) = NaN");
        System.out.println("Double.isNaN(Double.NaN / 100) = " + Double.isNaN(Double.NaN));
        System.out.println("Math.log10(Double.NaN / 100) = " + Math.log10(Double.NaN));
        System.out.println("Double.isNaN(Math.log10(Double.NaN / 100)) = " + Double.isNaN(Math.log10(Double.NaN)));
        System.out.println("Math.min(Double.NaN, 0) = " + Math.min(Double.NaN, 0.0));
        System.out.println("Math.max(Double.NaN, 0) = " + Math.max(Double.NaN, 0.0));
    }
}

