/*
 * Decompiled with CFR 0.152.
 */
package cytospade;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.logger.CyLogger;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytospade.CytoSpade;
import cytospade.SpadeContext;
import giny.model.Node;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import org.apache.commons.math.stat.descriptive.rank.Percentile;

public class VisualMapping {
    private SpadeContext.NormalizationKind rangeKind;
    private SpadeContext.SymmetryType symmetryType;
    private HashMap globalRanges;
    private String sizeMarker;
    private String colorMarker;

    public VisualMapping() {
        this.globalRanges = null;
    }

    public VisualMapping(File globalBoundaryFile) {
        this.globalRanges = new HashMap();
        this.readBoundaries(globalBoundaryFile);
    }

    public boolean globalRangeAvailable() {
        return this.globalRanges != null && this.globalRanges.size() > 0;
    }

    public void setCurrentMarkersAndRangeKind(String sizeMarker, String colorMarker, SpadeContext.NormalizationKind rangeKind, SpadeContext.SymmetryType symmetryType) throws IllegalArgumentException {
        if (!VisualMapping.isNumericAttribute(sizeMarker)) {
            throw new IllegalArgumentException("sizeMarker is non-numeric");
        }
        this.sizeMarker = sizeMarker;
        if (!VisualMapping.isNumericAttribute(colorMarker)) {
            throw new IllegalArgumentException("colorMarker is non-numeric");
        }
        this.colorMarker = colorMarker;
        this.rangeKind = rangeKind;
        this.symmetryType = symmetryType;
    }

    public String getCurrentSizeMarker() {
        return this.sizeMarker;
    }

    public String getCurrentColorMarker() {
        return this.colorMarker;
    }

    public Calculator createSizeCalculator() {
        Range rng = this.getAttributeRange(this.sizeMarker);
        double rmin = rng.getMin();
        double rmax = rng.getMax();
        VisualPropertyType type = VisualPropertyType.NODE_SIZE;
        Object defaultObj = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        ContinuousMapping cm = new ContinuousMapping(defaultObj.getClass(), this.sizeMarker);
        LinearNumberToNumberInterpolator numToSize = new LinearNumberToNumberInterpolator();
        cm.setInterpolator((Interpolator)numToSize);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)28, (Object)28, (Object)28);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)72, (Object)72, (Object)72);
        cm.addPoint(rmin, bv0);
        cm.addPoint(rmax, bv1);
        return new BasicCalculator("SPADE Size Calculator", (ObjectMapping)cm, VisualPropertyType.NODE_SIZE);
    }

    public Calculator createColorCalculator() {
        Range rng = this.getAttributeRange(this.colorMarker);
        double rmin = rng.getMin();
        double rmax = rng.getMax();
        if (this.symmetryType == SpadeContext.SymmetryType.SYMMETRIC) {
            rmax = Math.max(Math.abs(rng.max), Math.abs(rng.min));
            rmin = -1.0 * rmax;
        }
        VisualPropertyType type = VisualPropertyType.NODE_FILL_COLOR;
        Object defaultObj = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        ContinuousMapping cm = new ContinuousMapping(defaultObj.getClass(), this.colorMarker);
        LinearNumberToColorInterpolator numToColor = new LinearNumberToColorInterpolator();
        cm.setInterpolator((Interpolator)numToColor);
        Color[] colors = new Color[]{new Color(0, 0, 153), new Color(0, 0, 255), new Color(0, 255, 255), new Color(51, 255, 0), new Color(255, 255, 0), new Color(255, 0, 51), new Color(153, 0, 0)};
        double step = (rmax - rmin) / (double)(colors.length - 1);
        for (int i = 0; i < colors.length; ++i) {
            cm.addPoint(rmin + step * (double)i, new BoundaryRangeValues((Object)colors[i], (Object)colors[i], (Object)colors[i]));
        }
        return new BasicCalculator("SPADE Color Calculator", (ObjectMapping)cm, VisualPropertyType.NODE_FILL_COLOR);
    }

    public static boolean isNumericAttribute(String attrID) {
        CyAttributes cyNodeAttrs = Cytoscape.getNodeAttributes();
        switch (cyNodeAttrs.getType(attrID)) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
        }
        return true;
    }

    public static void populateNumericAttributeComboBox(JComboBox csBox) {
        csBox.removeAllItems();
        CyAttributes cyNodeAttrs = Cytoscape.getNodeAttributes();
        Object[] names = cyNodeAttrs.getAttributeNames();
        Arrays.sort(names);
        for (Object name : names) {
            if (!VisualMapping.isNumericAttribute((String)name) || !cyNodeAttrs.getUserVisible((String)name)) continue;
            csBox.addItem(name);
        }
    }

    private Range getAttributeRange(String attrID) {
        Range range;
        if (this.rangeKind == SpadeContext.NormalizationKind.GLOBAL && (range = (Range)this.globalRanges.get(attrID)) != null) {
            return range;
        }
        double[] values = new double[Cytoscape.getCurrentNetwork().getNodeCount()];
        int value_idx = 0;
        CyAttributes cyNodeAttrs = Cytoscape.getNodeAttributes();
        byte attrType = cyNodeAttrs.getType(attrID);
        Iterator it = Cytoscape.getCurrentNetwork().nodesIterator();
        while (it.hasNext()) {
            Double value;
            Node node = (Node)it.next();
            String nodeID = node.getIdentifier();
            if (!cyNodeAttrs.hasAttribute(nodeID, attrID)) continue;
            if (attrType == 3) {
                value = cyNodeAttrs.getIntegerAttribute(nodeID, attrID).doubleValue();
            } else {
                if (attrType != 2) continue;
                value = cyNodeAttrs.getDoubleAttribute(nodeID, attrID);
            }
            values[value_idx] = value;
            ++value_idx;
        }
        values = Arrays.copyOf(values, value_idx);
        Percentile pctile = new Percentile();
        return new Range(pctile.evaluate(values, 2.0), pctile.evaluate(values, 98.0));
    }

    private void readBoundaries(File boundaryFile) {
        try {
            String read;
            BufferedReader br = new BufferedReader(new FileReader(boundaryFile.getAbsolutePath()));
            while ((read = br.readLine()) != null) {
                String[] vals = read.split(" ");
                this.globalRanges.put(vals[0].replaceAll("\"", ""), new Range(Double.parseDouble(vals[2]), Double.parseDouble(vals[3])));
            }
        }
        catch (FileNotFoundException ex) {
            CyLogger.getLogger((String)CytoSpade.class.getName()).error(null, (Throwable)ex);
            this.globalRanges = null;
        }
        catch (IOException ex) {
            CyLogger.getLogger((String)CytoSpade.class.getName()).error(null, (Throwable)ex);
            this.globalRanges = null;
        }
        CyLogger.getLogger((String)CytoSpade.class.getName()).info("Loaded ranges from global_boundaries.table");
    }

    private static class Range {
        private double min;
        private double max;

        public Range(double min_a, double max_a) {
            this.min = min_a;
            this.max = max_a;
        }

        public void setMax(double Max2) {
            this.max = Max2;
        }

        public void setMin(double Min2) {
            this.min = Min2;
        }

        public double getMax() {
            if (this.max < this.min) {
                return 100.0;
            }
            return this.max;
        }

        public double getMin() {
            if (this.max < this.min) {
                return 0.0;
            }
            return this.min;
        }
    }
}

