/*
 * Decompiled with CFR 0.152.
 */
package cytospade;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpadeController
extends SwingWorker<Integer, Void> {
    File workingDir;
    String script;
    JDialog outDialog;
    JTextArea outArea;
    JScrollPane outAreaWrapper;
    JPanel buttonPanel;
    JSeparator separator;
    JButton doneButton;

    public SpadeController(File cwd, String script) {
        this.workingDir = cwd;
        this.script = script;
    }

    public void exec() {
        this.outDialog = new JDialog((Frame)Cytoscape.getDesktop());
        this.outDialog.getContentPane().setLayout(new BorderLayout());
        this.outDialog.setTitle("SPADE Execution Console");
        this.outArea = new JTextArea();
        this.outArea.setColumns(60);
        this.outArea.setRows(20);
        this.outArea.setEditable(false);
        this.outAreaWrapper = new JScrollPane();
        this.outAreaWrapper.setViewportView(this.outArea);
        this.outDialog.getContentPane().add((Component)this.outAreaWrapper, "Center");
        this.buttonPanel = new JPanel();
        this.separator = new JSeparator();
        this.doneButton = new JButton();
        this.doneButton.setText("Done");
        this.doneButton.setEnabled(false);
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.separator, "North");
        this.buttonPanel.add((Component)this.doneButton, "East");
        this.outDialog.getContentPane().add((Component)this.buttonPanel, "South");
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpadeController.this.outDialog.dispose();
            }
        });
        this.execute();
        this.outDialog.setModal(true);
        this.outDialog.pack();
        this.outDialog.setLocationRelativeTo(this.outDialog.getParent());
        this.outDialog.show();
    }

    @Override
    protected Integer doInBackground() {
        String executable = this.getExecutable();
        if (executable == null) {
            this.outArea.append("Unable to find R executable. Perhaps try generating and running script manually.\n");
            return 1;
        }
        ProcessBuilder pb = new ProcessBuilder(executable, "-f", this.script);
        pb.directory(this.workingDir);
        pb.redirectErrorStream(true);
        try {
            String line;
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                this.outArea.append(line + "\n");
            }
            reader.close();
            return p.waitFor();
        }
        catch (IOException ex) {
            CyLogger.getLogger((String)SpadeController.class.getName()).error(null, (Throwable)ex);
        }
        catch (InterruptedException ex) {
            CyLogger.getLogger((String)SpadeController.class.getName()).error(null, (Throwable)ex);
        }
        return 1;
    }

    @Override
    protected void done() {
        Integer exit_status = 1;
        try {
            exit_status = (Integer)this.get();
        }
        catch (InterruptedException ex) {
            CyLogger.getLogger((String)SpadeController.class.getName()).error(null, (Throwable)ex);
        }
        catch (ExecutionException ex) {
            CyLogger.getLogger((String)SpadeController.class.getName()).error(null, (Throwable)ex);
        }
        if (exit_status == 0) {
            JOptionPane.showMessageDialog(null, "Successfully executed script.");
        } else {
            JOptionPane.showMessageDialog(null, "Execution failed. See output dialog for clues.");
        }
        this.doneButton.setEnabled(true);
    }

    private String getExecutable() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            try {
                String line;
                String REGSTR_TOKEN = "REG_SZ";
                Process p = Runtime.getRuntime().exec("REG QUERY \"HKLM\\SOFTWARE\\R-core\\R\" /v InstallPath");
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                p.waitFor();
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                String result = sb.toString();
                int token = result.indexOf(REGSTR_TOKEN);
                if (token == -1) {
                    return null;
                }
                return '\"' + result.substring(token + REGSTR_TOKEN.length()).trim() + "\\bin\\R\"";
            }
            catch (Exception ex) {
                CyLogger.getLogger((String)SpadeController.class.getName()).error(null, (Throwable)ex);
                return null;
            }
        }
        return "R";
    }
}

