/*
 * Decompiled with CFR 0.152.
 */
package cytospade;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualStyle;
import cytospade.ui.NodeContextMenuItems;
import giny.model.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;

public class MergeOrderOperations {
    private ArrayList<ArrayList<Integer>> mergeOrderFileCache = new ArrayList();
    private ArrayList<String> clusterIdentifier = new ArrayList();
    ArrayList<ArrayList<Integer>> absoluteClusterNodes = new ArrayList();
    private String nestedDetailedGraphId;
    private String originalNetworkId;
    private ArrayList<String> tempNodeViews = new ArrayList();
    private int previousMergeOrder = 0;
    private boolean previousRenderNestedView = false;

    public MergeOrderOperations(File mergeOrderFile) throws FileNotFoundException, Exception {
        Scanner myfile = new Scanner(mergeOrderFile);
        this.mergeOrderFileCache.add(new ArrayList());
        this.clusterIdentifier.add(null);
        myfile.nextLine();
        int lineNum = 2;
        while (myfile.hasNextLine()) {
            String[] nodeIds = myfile.nextLine().split(" ");
            if (nodeIds.length != 3) {
                throw new Exception("Merge order file is corrupted. Line number:" + lineNum + " in file:" + mergeOrderFile.getName());
            }
            ++lineNum;
            int element0 = Integer.decode(nodeIds[1]);
            int element1 = Integer.decode(nodeIds[2]);
            ArrayList<Integer> cluster = new ArrayList<Integer>();
            cluster.add(element0);
            cluster.add(element1);
            this.mergeOrderFileCache.add(cluster);
            this.clusterIdentifier.add(null);
        }
        for (ArrayList<Integer> cluster : this.mergeOrderFileCache) {
            ArrayList<Integer> nodesToAdd = new ArrayList<Integer>();
            for (Integer node : cluster) {
                if (node < 0) {
                    nodesToAdd.add(-1 * node);
                    continue;
                }
                nodesToAdd.addAll((Collection)this.absoluteClusterNodes.get(node));
            }
            this.absoluteClusterNodes.add(nodesToAdd);
        }
    }

    public int getMaxMergeOrder() {
        return this.mergeOrderFileCache.size() - 1;
    }

    public int createNestedGraphIncremental(int mergeOrder, boolean renderNestedView) {
        if (mergeOrder >= this.mergeOrderFileCache.size()) {
            mergeOrder = this.mergeOrderFileCache.size() - 1;
        }
        if (mergeOrder < 0) {
            return -1;
        }
        if (this.previousMergeOrder == mergeOrder) {
            return mergeOrder;
        }
        this.previousRenderNestedView = renderNestedView;
        int i = this.previousMergeOrder + 1;
        while (i <= mergeOrder) {
            int firstNode = this.mergeOrderFileCache.get(i).get(0);
            int secondNode = this.mergeOrderFileCache.get(i).get(1);
            String firstNodeId = String.valueOf(-1 * firstNode);
            String secondNodeId = String.valueOf(-1 * secondNode);
            if (firstNode > 0) {
                firstNodeId = this.clusterIdentifier.get(firstNode);
            }
            if (secondNode > 0) {
                secondNodeId = this.clusterIdentifier.get(secondNode);
            }
            CyNode cyNode1 = Cytoscape.getCyNode((String)firstNodeId);
            CyNode cyNode2 = Cytoscape.getCyNode((String)secondNodeId);
            if (cyNode1 != null && cyNode2 != null) {
                HashSet<CyNode> cluster = new HashSet<CyNode>();
                cluster.add(cyNode1);
                cluster.add(cyNode2);
                CyNode retRootNode = NodeContextMenuItems.MakeNestedNetwork.makeNestedNode(cluster, renderNestedView);
                if (retRootNode != null) {
                    this.clusterIdentifier.add(i, retRootNode.getIdentifier());
                }
            }
            ++i;
            ++this.previousMergeOrder;
        }
        i = this.previousMergeOrder;
        while (i > mergeOrder) {
            String clusterid = this.clusterIdentifier.get(i);
            if (clusterid != null) {
                CyNode clusterNode = Cytoscape.getCyNode((String)clusterid);
                this.clusterIdentifier.set(i, null);
                if (clusterNode != null) {
                    NodeContextMenuItems.UndoNestedNetwork.undoNestedNode(clusterNode);
                }
            }
            --i;
            --this.previousMergeOrder;
        }
        Cytoscape.getVisualMappingManager().applyAppearances();
        return mergeOrder;
    }

    public void showNestedNetworkDetails() {
        int previous = this.previousMergeOrder;
        boolean previousView = this.previousRenderNestedView;
        this.createNestedGraphIncremental(0, this.previousRenderNestedView);
        CyNetworkView currentView = Cytoscape.getCurrentNetworkView();
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        this.originalNetworkId = currentNetwork.getIdentifier();
        String title = currentNetwork.getTitle() + "_Merge" + Integer.toString(previous);
        CyNetwork nestedNetwork = Cytoscape.createNetwork((String)title, (boolean)true);
        nestedNetwork.appendNetwork(currentNetwork);
        CyNetworkView nestedView = Cytoscape.createNetworkView((CyNetwork)nestedNetwork, (String)title);
        this.nestedDetailedGraphId = nestedNetwork.getIdentifier();
        String vsName = "default";
        if (currentView != Cytoscape.getNullNetworkView()) {
            Iterator i = nestedNetwork.nodesIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                nestedView.getNodeView(node).setOffset(currentView.getNodeView(node).getXPosition(), currentView.getNodeView(node).getYPosition());
            }
            nestedView.fitContent();
            VisualStyle newVS = currentView.getVisualStyle();
            if (newVS != null) {
                vsName = newVS.getName();
            }
        }
        Cytoscape.getVisualMappingManager().setVisualStyle(vsName);
        this.createNestedGraphAbsolute(previous, true);
        Cytoscape.getVisualMappingManager().applyAppearances();
        Cytoscape.setCurrentNetwork((String)currentNetwork.getIdentifier());
        Cytoscape.setCurrentNetworkView((String)currentView.getTitle());
        Cytoscape.getDesktop().setFocus(currentNetwork.getIdentifier());
        this.previousMergeOrder = 0;
        int numClusters = this.clusterIdentifier.size();
        this.clusterIdentifier.clear();
        for (int i = 0; i < numClusters; ++i) {
            this.clusterIdentifier.add(null);
        }
        this.createNestedGraphIncremental(previous, previousView);
        Cytoscape.getDesktop().setFocus(nestedNetwork.getIdentifier());
    }

    private void createNestedGraphAbsolute(int mergeOrder, boolean renderNestedView) {
        for (int clusterNum = mergeOrder; clusterNum >= 0; --clusterNum) {
            CyNode retRootNode;
            HashSet<CyNode> nodes = new HashSet<CyNode>();
            for (int nodeId : this.absoluteClusterNodes.get(clusterNum)) {
                CyNode cyNode = Cytoscape.getCyNode((String)Integer.toString(nodeId));
                if (cyNode == null || NodeContextMenuItems.MakeNestedNetwork.isNested(cyNode)) continue;
                nodes.add(cyNode);
            }
            if (nodes.isEmpty() || (retRootNode = NodeContextMenuItems.MakeNestedNetwork.makeNestedNode(nodes, renderNestedView)) == null) continue;
            this.tempNodeViews.add(0, ((CyNetwork)retRootNode.getNestedNetwork()).getIdentifier());
        }
    }

    public void destroyNestedNetworkDetails() {
        CyNetwork network = Cytoscape.getNetwork((String)this.nestedDetailedGraphId);
        Cytoscape.setCurrentNetwork((String)this.nestedDetailedGraphId);
        Cytoscape.setCurrentNetworkView((String)this.nestedDetailedGraphId);
        if (this.tempNodeViews.size() > 0) {
            for (int i = 0; i < this.tempNodeViews.size(); ++i) {
                Cytoscape.destroyNetworkView((String)this.tempNodeViews.get(i));
            }
        }
        Cytoscape.destroyNetworkView((CyNetwork)network);
        Cytoscape.destroyNetwork((CyNetwork)network);
        Cytoscape.setCurrentNetwork((String)this.originalNetworkId);
        Cytoscape.setCurrentNetworkView((String)this.originalNetworkId);
        Cytoscape.getDesktop().setFocus(this.originalNetworkId);
    }
}

