
## ----'setup', include = FALSE, cache = FALSE-----------------------------
library(knitr)
opts_chunk$set(fig.align = 'center', 
               fig.show = 'hold', 
               par = TRUE,
               prompt = TRUE,
               comment = NA)
options(replace.assign = TRUE, 
        width = 65)


## ----'env', echo = FALSE-------------------------------------------------
library("xtable")
suppressPackageStartupMessages(library("GO.db"))
suppressPackageStartupMessages(library("rols"))
nonto <- length(ontologyNames())


## ----'ontTable', results='asis', echo = FALSE----------------------------
  tab <- ontologies()
  o <- order(tab$Name)
  print(xtable(tab[o,],
               align=c("l", "l", "l"),
               label="tab:onto",
               caption='Available ontologies in the OLS and \\Rpackage{rols} package.'),
        tabular.environment="longtable",
        floating=FALSE,
        include.rownames=FALSE)


## ----'funTables', results='asis', echo = FALSE---------------------------
funTab <- data.frame(rbind(
  c("olsVersion", "Returns the OLS version"),
  c("ontologies", "Returns all available ontologies"),
  c("ontologyNames", "Returns all ontologyNames"), 
  c("ontologyLoadDate", "Returns the ontology load date"), 
  c("isIdObsolete", "Is the ontology id obsolete"), 
  c("term", "Returns the term of a given identifier"),
  c("termMetadata", "Retuns an identifier's metadata"),
  c("termXrefs", "Returns the idenifier's ontology cross references"),
  c("rootId", "Retuns the root identifiers of an ontology"), 
  c("allIds", "Returns all identifiers and terms of an ontology"), 
  c("olsQuery", "Returns matching identifiers"), 
  c("parents", "Returns the parent(s) of a term."),
  c("childrenRelations", "Returns the children relation type(s).")
))
colnames(funTab) <- c("Function", "Description")
print(xtable(funTab,
             align=c("l", "l", "l"),
             label="tab:fun",
             caption='Functions available to query the ontologies.'),
      include.rownames=FALSE)


## ----'tgnquery', eval = TRUE---------------------------------------------
library("rols")
alltgns <- olsQuery("trans-golgi network")


## ----'tgnqueryShow'------------------------------------------------------
alltgns
allonts <- sapply(strsplit(names(alltgns), ":"), "[", 1)
onto.tab <- table(allonts)
onto.tab


## ----'ontocnt', echo = FALSE---------------------------------------------


## ----'tgnqueryTable'-----------------------------------------------------
ontologies()[names(onto.tab),]


## ----'gotgnquery'--------------------------------------------------------
gotgns <- olsQuery("trans-golgi network", "GO")
gotgns


## ----'godetails'---------------------------------------------------------
term("GO:0005802", "GO")
mtd <- termMetadata("GO:0005802", "GO")
names(mtd)
mtd["comment"]
mtd["definition"]
## same as from GO.db
GOTERM[["GO:0005802"]]


## ----sessioninfo, results='asis', echo = FALSE, cache = FALSE------------
toLatex(sessionInfo())


