### R code from vignette source 'prot2D.Rnw'

###################################################
### code chunk number 1: prot2D.Rnw:65-66
###################################################
library(prot2D)


###################################################
### code chunk number 2: prot2D.Rnw:69-71
###################################################
data(pecten)
data(pecten.fac)


###################################################
### code chunk number 3: prot2D.Rnw:88-89
###################################################
RIplot(pecten, n1=6, n2=6)


###################################################
### code chunk number 4: prot2D.Rnw:95-96
###################################################
pecten.norm <- Norm.qt(pecten, n1=6, n2=6, plot=TRUE)


###################################################
### code chunk number 5: prot2D.Rnw:104-105
###################################################



###################################################
### code chunk number 6: prot2D.Rnw:110-111
###################################################
ES.p <- ES.prot(pecten.norm, n1=6, n2=6, f=pecten.fac)


###################################################
### code chunk number 7: prot2D.Rnw:135-137
###################################################
ES.diff <- modT.Prot(ES.p, plot=TRUE, fdr.thr=0.1, 
                     method.fdr="BH" )


###################################################
### code chunk number 8: prot2D.Rnw:140-141
###################################################
featureNames(ES.diff)


###################################################
### code chunk number 9: prot2D.Rnw:144-145
###################################################
head(fData(ES.diff))


###################################################
### code chunk number 10: prot2D.Rnw:148-149
###################################################
head(exprs(ES.diff))


###################################################
### code chunk number 11: prot2D.Rnw:164-166
###################################################
Sim.data <- Sim.Prot.2D(data=pecten, nsp=700,
                        nr=10, p0=0.1, s2_0=0.2, d0=3)


###################################################
### code chunk number 12: prot2D.Rnw:169-171
###################################################
res.stud <- ttest.Prot(Sim.data, fdr.thr=0.1, plot=FALSE)
res.mo <- modT.Prot(Sim.data, fdr.thr=0.1, plot=FALSE)


###################################################
### code chunk number 13: prot2D.Rnw:174-175
###################################################
featureNames(res.stud) 


###################################################
### code chunk number 14: prot2D.Rnw:178-179
###################################################
featureNames(res.mo) 


###################################################
### code chunk number 15: prot2D.Rnw:182-183
###################################################
notes(Sim.data)$SpotSig 


###################################################
### code chunk number 16: prot2D.Rnw:188-189
###################################################
sessionInfo()


