/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.ImplUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLClassExpressionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassImpl
extends OWLClassExpressionImpl
implements OWLClass {
    private IRI iri;
    private boolean isThing;
    private boolean isNothing;

    public OWLClassImpl(OWLDataFactory dataFactory, IRI iri) {
        super(dataFactory);
        this.iri = iri;
        this.isThing = this.getIRI().equals(OWLRDFVocabulary.OWL_THING.getIRI());
        this.isNothing = this.getIRI().equals(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    @Override
    public boolean isTopEntity() {
        return this.isOWLThing();
    }

    @Override
    public boolean isBottomEntity() {
        return this.isOWLNothing();
    }

    @Override
    public ClassExpressionType getClassExpressionType() {
        return ClassExpressionType.OWL_CLASS;
    }

    @Override
    public OWLClassExpression getObjectComplementOf() {
        return this.getOWLDataFactory().getOWLObjectComplementOf(this);
    }

    @Override
    public EntityType<?> getEntityType() {
        return EntityType.CLASS;
    }

    @Override
    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType) {
        return this.getOWLDataFactory().getOWLEntity(entityType, this.getIRI());
    }

    @Override
    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    @Override
    public String toStringID() {
        return this.iri.toString();
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public boolean isBuiltIn() {
        return this.isOWLThing() || this.isOWLNothing();
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology) {
        return ontology.getReferencingAxioms(this);
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology, boolean includeImports) {
        return ontology.getReferencingAxioms(this, includeImports);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isClassExpressionLiteral() {
        return true;
    }

    @Override
    public OWLClass asOWLClass() {
        return this;
    }

    public URI getURI() {
        return this.iri.toURI();
    }

    @Override
    public boolean isOWLThing() {
        return this.isThing;
    }

    @Override
    public boolean isOWLNothing() {
        return this.isNothing;
    }

    @Override
    public OWLClassExpression getNNF() {
        return this;
    }

    @Override
    public Set<OWLClassExpression> asConjunctSet() {
        return Collections.singleton(this);
    }

    @Override
    public boolean containsConjunct(OWLClassExpression ce) {
        return ce.equals(this);
    }

    @Override
    public Set<OWLClassExpression> asDisjunctSet() {
        return Collections.singleton(this);
    }

    @Override
    public OWLClassExpression getComplementNNF() {
        return this.getOWLDataFactory().getOWLObjectComplementOf(this);
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxioms(OWLOntology ontology) {
        return ontology.getSubClassAxiomsForSubClass(this);
    }

    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLOntology ontology) {
        return ontology.getEquivalentClassesAxioms(this);
    }

    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLOntology ontology) {
        return ontology.getDisjointClassesAxioms(this);
    }

    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLOntology ontology) {
        return ontology.getDisjointUnionAxioms(this);
    }

    @Override
    public Set<OWLClassExpression> getSuperClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLSubClassOfAxiom axiom : this.getSubClassAxioms(ontology)) {
            result.add(axiom.getSuperClass());
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getSuperClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getSuperClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getSubClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLSubClassOfAxiom axiom : ontology.getSubClassAxiomsForSuperClass(this)) {
            result.add(axiom.getSubClass());
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getSubClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getSubClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getEquivalentClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLEquivalentClassesAxiom axiom : this.getEquivalentClassesAxioms(ontology)) {
            result.addAll(axiom.getClassExpressions());
        }
        result.remove(this);
        return result;
    }

    @Override
    public Set<OWLClassExpression> getEquivalentClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getEquivalentClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getDisjointClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLDisjointClassesAxiom axiom : this.getDisjointClassesAxioms(ontology)) {
            result.addAll(axiom.getClassExpressions());
        }
        result.remove(this);
        return result;
    }

    @Override
    public Set<OWLClassExpression> getDisjointClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getDisjointClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLIndividual> getIndividuals(OWLOntology ontology) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLClassAssertionAxiom ax : ontology.getClassAssertionAxioms(this)) {
            result.add(ax.getIndividual());
        }
        return result;
    }

    @Override
    public Set<OWLIndividual> getIndividuals(Set<OWLOntology> ontologies) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getIndividuals(ont));
        }
        return result;
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations(this, Collections.singleton(ontology));
    }

    @Override
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms(this, Collections.singleton(ontology));
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return ImplUtils.getAnnotations(this, annotationProperty, Collections.singleton(ontology));
    }

    @Override
    public boolean isDefined(OWLOntology ontology) {
        return !ontology.getEquivalentClassesAxioms(this).isEmpty();
    }

    @Override
    public boolean isDefined(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isDefined(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    @Override
    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    @Override
    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not an individual!");
    }

    @Override
    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an object property");
    }

    @Override
    public boolean isOWLClass() {
        return true;
    }

    @Override
    public boolean isOWLDataProperty() {
        return false;
    }

    @Override
    public boolean isOWLDatatype() {
        return false;
    }

    @Override
    public boolean isOWLNamedIndividual() {
        return false;
    }

    @Override
    public boolean isOWLObjectProperty() {
        return false;
    }

    @Override
    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    @Override
    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLClass)) {
                return false;
            }
            IRI otherIRI = ((OWLClass)obj).getIRI();
            return otherIRI.equals(this.iri);
        }
        return false;
    }

    @Override
    public void accept(OWLClassExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLClassExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLClass other = (OWLClass)object;
        return this.iri.compareTo(other.getIRI());
    }
}

