/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.HermiT.blocking.BlockingSignature;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.blocking.SetFactory;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.NodeType;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatedSingleDirectBlockingChecker
implements DirectBlockingChecker,
Serializable {
    private static final long serialVersionUID = 9093753046859877016L;
    protected final SetFactory<AtomicConcept> m_atomicConceptsSetFactory = new SetFactory();
    protected final SetFactory<AtomicRole> m_atomicRolesSetFactory = new SetFactory();
    protected final List<AtomicConcept> m_atomicConceptsBuffer = new ArrayList<AtomicConcept>();
    protected final List<AtomicRole> m_atomicRolesBuffer = new ArrayList<AtomicRole>();
    protected final boolean m_hasInverses;
    protected Tableau m_tableau;
    protected ExtensionTable.Retrieval m_binaryTableSearch1Bound;
    protected ExtensionTable.Retrieval m_ternaryTableSearch12Bound;

    public ValidatedSingleDirectBlockingChecker(boolean bl) {
        this.m_hasInverses = bl;
    }

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_binaryTableSearch1Bound = tableau.getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
        this.m_ternaryTableSearch12Bound = tableau.getExtensionManager().getTernaryExtensionTable().createRetrieval(new boolean[]{false, true, true}, ExtensionTable.View.TOTAL);
    }

    @Override
    public void clear() {
        this.m_atomicConceptsSetFactory.clearNonpermanent();
        this.m_atomicRolesSetFactory.clearNonpermanent();
        this.m_binaryTableSearch1Bound.clear();
        this.m_ternaryTableSearch12Bound.clear();
    }

    @Override
    public boolean isBlockedBy(Node node, Node node2) {
        boolean bl = !node.isBlocked() && node.getNodeType() == NodeType.TREE_NODE && node2.getNodeType() == NodeType.TREE_NODE && ((ValidatedSingleBlockingObject)node.getBlockingObject()).getAtomicConceptsLabel() == ((ValidatedSingleBlockingObject)node2.getBlockingObject()).getAtomicConceptsLabel();
        return bl;
    }

    @Override
    public int blockingHashCode(Node node) {
        return ((ValidatedSingleBlockingObject)node.getBlockingObject()).m_blockingRelevantHashCode;
    }

    @Override
    public boolean canBeBlocker(Node node) {
        Node node2 = node.getParent();
        return node.getNodeType() == NodeType.TREE_NODE && (!this.m_hasInverses || node.getParent().getNodeType() == NodeType.TREE_NODE || node2.getNodeType() == NodeType.GRAPH_NODE);
    }

    @Override
    public boolean canBeBlocked(Node node) {
        Node node2 = node.getParent();
        return node.getNodeType() == NodeType.TREE_NODE && (!this.m_hasInverses || node.getParent().getNodeType() == NodeType.TREE_NODE || node2.getNodeType() == NodeType.GRAPH_NODE);
    }

    @Override
    public boolean hasBlockingInfoChanged(Node node) {
        return ((ValidatedSingleBlockingObject)node.getBlockingObject()).m_hasChangedForBlocking;
    }

    @Override
    public void clearBlockingInfoChanged(Node node) {
        ((ValidatedSingleBlockingObject)node.getBlockingObject()).m_hasChangedForBlocking = false;
    }

    @Override
    public boolean hasChangedSinceValidation(Node node) {
        return ((ValidatedSingleBlockingObject)node.getBlockingObject()).m_hasChangedForValidation;
    }

    @Override
    public void setHasChangedSinceValidation(Node node, boolean bl) {
        ((ValidatedSingleBlockingObject)node.getBlockingObject()).m_hasChangedForValidation = bl;
    }

    @Override
    public void nodeInitialized(Node node) {
        if (node.getBlockingObject() == null) {
            node.setBlockingObject(new ValidatedSingleBlockingObject(node));
        }
        ((ValidatedSingleBlockingObject)node.getBlockingObject()).initialize();
    }

    @Override
    public void nodeDestroyed(Node node) {
        ((ValidatedSingleBlockingObject)node.getBlockingObject()).destroy();
    }

    @Override
    public Node assertionAdded(Concept concept, Node node, boolean bl) {
        ((ValidatedSingleBlockingObject)node.getBlockingObject()).addConcept(concept, bl);
        return concept instanceof AtomicConcept && bl ? node : null;
    }

    @Override
    public Node assertionRemoved(Concept concept, Node node, boolean bl) {
        ((ValidatedSingleBlockingObject)node.getBlockingObject()).removeConcept(concept, bl);
        return concept instanceof AtomicConcept && bl ? node : null;
    }

    @Override
    public Node assertionAdded(DataRange dataRange, Node node, boolean bl) {
        return null;
    }

    @Override
    public Node assertionRemoved(DataRange dataRange, Node node, boolean bl) {
        return null;
    }

    @Override
    public Node assertionAdded(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        return null;
    }

    @Override
    public Node assertionRemoved(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        return null;
    }

    @Override
    public Node nodesMerged(Node node, Node node2) {
        return null;
    }

    @Override
    public Node nodesUnmerged(Node node, Node node2) {
        return null;
    }

    protected Set<AtomicConcept> fetchAtomicConceptsLabel(Node node, boolean bl) {
        Set<AtomicConcept> set;
        this.m_atomicConceptsBuffer.clear();
        this.m_binaryTableSearch1Bound.getBindingsBuffer()[1] = node;
        this.m_binaryTableSearch1Bound.open();
        Object[] objectArray = this.m_binaryTableSearch1Bound.getTupleBuffer();
        while (!this.m_binaryTableSearch1Bound.afterLast()) {
            set = objectArray[0];
            if (set instanceof AtomicConcept && (!bl || this.m_binaryTableSearch1Bound.isCore())) {
                this.m_atomicConceptsBuffer.add((AtomicConcept)((Object)set));
            }
            this.m_binaryTableSearch1Bound.next();
        }
        set = this.m_atomicConceptsSetFactory.getSet(this.m_atomicConceptsBuffer);
        this.m_atomicConceptsBuffer.clear();
        return set;
    }

    protected Set<AtomicRole> fetchAtomicRolesLabel(Node node, Node node2, boolean bl) {
        Set<AtomicRole> set;
        this.m_atomicRolesBuffer.clear();
        this.m_ternaryTableSearch12Bound.getBindingsBuffer()[1] = node;
        this.m_ternaryTableSearch12Bound.getBindingsBuffer()[2] = node2;
        this.m_ternaryTableSearch12Bound.open();
        Object[] objectArray = this.m_ternaryTableSearch12Bound.getTupleBuffer();
        while (!this.m_ternaryTableSearch12Bound.afterLast()) {
            set = objectArray[0];
            if (set instanceof AtomicRole && (!bl || this.m_binaryTableSearch1Bound.isCore())) {
                this.m_atomicRolesBuffer.add((AtomicRole)((Object)set));
            }
            this.m_ternaryTableSearch12Bound.next();
        }
        set = this.m_atomicRolesSetFactory.getSet(this.m_atomicRolesBuffer);
        this.m_atomicRolesBuffer.clear();
        return set;
    }

    @Override
    public BlockingSignature getBlockingSignatureFor(Node node) {
        return new ValidatedBlockingSignature(this, node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValidatedBlockingObject {
        public void initialize();

        public void destroy();

        public Set<AtomicConcept> getAtomicConceptsLabel();

        public void addConcept(Concept var1, boolean var2);

        public void removeConcept(Concept var1, boolean var2);

        public Set<AtomicConcept> getFullAtomicConceptsLabel();

        public Set<AtomicRole> getFullFromParentLabel();

        public Set<AtomicRole> getFullToParentLabel();

        public void setBlockViolatesParentConstraints(boolean var1);

        public void setHasAlreadyBeenChecked(boolean var1);

        public boolean hasAlreadyBeenChecked();

        public boolean blockViolatesParentConstraints();
    }

    protected static class ValidatedBlockingSignature
    extends BlockingSignature {
        protected final Set<AtomicConcept> m_blockingRelevantConceptsLabel;
        protected final Set<AtomicConcept> m_fullAtomicConceptsLabel;
        protected final Set<AtomicConcept> m_parentFullAtomicConceptsLabel;
        protected final Set<AtomicRole> m_fromParentLabel;
        protected final Set<AtomicRole> m_toParentLabel;
        protected final int m_hashCode;

        public ValidatedBlockingSignature(ValidatedSingleDirectBlockingChecker validatedSingleDirectBlockingChecker, Node node) {
            ValidatedSingleBlockingObject validatedSingleBlockingObject = (ValidatedSingleBlockingObject)node.getBlockingObject();
            this.m_blockingRelevantConceptsLabel = validatedSingleBlockingObject.getAtomicConceptsLabel();
            this.m_fullAtomicConceptsLabel = validatedSingleBlockingObject.getFullAtomicConceptsLabel();
            this.m_parentFullAtomicConceptsLabel = ((ValidatedSingleBlockingObject)node.getParent().getBlockingObject()).getFullAtomicConceptsLabel();
            this.m_fromParentLabel = validatedSingleBlockingObject.getFullFromParentLabel();
            this.m_toParentLabel = validatedSingleBlockingObject.getFullToParentLabel();
            this.m_hashCode = ((Object)this.m_blockingRelevantConceptsLabel).hashCode();
            validatedSingleDirectBlockingChecker.m_atomicConceptsSetFactory.makePermanent(this.m_fullAtomicConceptsLabel);
            validatedSingleDirectBlockingChecker.m_atomicConceptsSetFactory.makePermanent(this.m_parentFullAtomicConceptsLabel);
            validatedSingleDirectBlockingChecker.m_atomicRolesSetFactory.makePermanent(this.m_fromParentLabel);
            validatedSingleDirectBlockingChecker.m_atomicRolesSetFactory.makePermanent(this.m_toParentLabel);
        }

        public boolean blocksNode(Node node) {
            ValidatedSingleBlockingObject validatedSingleBlockingObject = (ValidatedSingleBlockingObject)node.getBlockingObject();
            return validatedSingleBlockingObject.getAtomicConceptsLabel() == this.m_blockingRelevantConceptsLabel;
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ValidatedBlockingSignature)) {
                return false;
            }
            ValidatedBlockingSignature validatedBlockingSignature = (ValidatedBlockingSignature)object;
            return this.m_blockingRelevantConceptsLabel == validatedBlockingSignature.m_blockingRelevantConceptsLabel && this.m_fullAtomicConceptsLabel == validatedBlockingSignature.m_fullAtomicConceptsLabel && this.m_parentFullAtomicConceptsLabel == validatedBlockingSignature.m_parentFullAtomicConceptsLabel && this.m_fromParentLabel == validatedBlockingSignature.m_fromParentLabel && this.m_toParentLabel == validatedBlockingSignature.m_toParentLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValidatedSingleBlockingObject
    implements ValidatedBlockingObject {
        protected final Node m_node;
        protected boolean m_hasChangedForBlocking;
        protected boolean m_hasChangedForValidation;
        protected Set<AtomicConcept> m_blockingRelevantLabel;
        protected Set<AtomicConcept> m_fullAtomicConceptsLabel;
        protected Set<AtomicRole> m_fullFromParentLabel;
        protected Set<AtomicRole> m_fullToParentLabel;
        protected int m_blockingRelevantHashCode;
        public boolean m_blockViolatesParentConstraints = false;
        public boolean m_hasAlreadyBeenChecked = false;

        public ValidatedSingleBlockingObject(Node node) {
            this.m_node = node;
        }

        @Override
        public void initialize() {
            this.m_blockingRelevantLabel = null;
            this.m_blockingRelevantHashCode = 0;
            this.m_fullAtomicConceptsLabel = null;
            this.m_fullFromParentLabel = null;
            this.m_fullToParentLabel = null;
            this.m_hasChangedForBlocking = true;
            this.m_hasChangedForValidation = true;
        }

        @Override
        public void destroy() {
            if (this.m_blockingRelevantLabel != null) {
                ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_blockingRelevantLabel);
                this.m_blockingRelevantLabel = null;
            }
            if (this.m_fullAtomicConceptsLabel != null) {
                ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_fullAtomicConceptsLabel);
                this.m_fullAtomicConceptsLabel = null;
            }
            if (this.m_fullFromParentLabel != null) {
                ValidatedSingleDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_fullFromParentLabel);
                this.m_fullFromParentLabel = null;
            }
            if (this.m_fullToParentLabel != null) {
                ValidatedSingleDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_fullToParentLabel);
                this.m_fullToParentLabel = null;
            }
        }

        @Override
        public Set<AtomicConcept> getAtomicConceptsLabel() {
            if (this.m_blockingRelevantLabel == null) {
                this.m_blockingRelevantLabel = ValidatedSingleDirectBlockingChecker.this.fetchAtomicConceptsLabel(this.m_node, true);
                ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.addReference(this.m_blockingRelevantLabel);
            }
            return this.m_blockingRelevantLabel;
        }

        @Override
        public void addConcept(Concept concept, boolean bl) {
            this.m_hasChangedForValidation = true;
            if (concept instanceof AtomicConcept) {
                if (this.m_fullAtomicConceptsLabel != null) {
                    ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_fullAtomicConceptsLabel);
                    this.m_fullAtomicConceptsLabel = null;
                }
                if (bl) {
                    if (this.m_blockingRelevantLabel != null) {
                        ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_blockingRelevantLabel);
                        this.m_blockingRelevantLabel = null;
                    }
                    this.m_blockingRelevantHashCode += concept.hashCode();
                    this.m_hasChangedForBlocking = true;
                }
            }
        }

        @Override
        public void removeConcept(Concept concept, boolean bl) {
            this.m_hasChangedForValidation = true;
            if (concept instanceof AtomicConcept) {
                if (this.m_fullAtomicConceptsLabel != null) {
                    ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_fullAtomicConceptsLabel);
                    this.m_fullAtomicConceptsLabel = null;
                }
                if (bl) {
                    if (this.m_blockingRelevantLabel != null) {
                        ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_blockingRelevantLabel);
                        this.m_blockingRelevantLabel = null;
                    }
                    this.m_blockingRelevantHashCode -= concept.hashCode();
                    this.m_hasChangedForBlocking = true;
                }
            }
        }

        @Override
        public Set<AtomicConcept> getFullAtomicConceptsLabel() {
            if (this.m_fullAtomicConceptsLabel == null) {
                this.m_fullAtomicConceptsLabel = ValidatedSingleDirectBlockingChecker.this.fetchAtomicConceptsLabel(this.m_node, false);
                ValidatedSingleDirectBlockingChecker.this.m_atomicConceptsSetFactory.addReference(this.m_fullAtomicConceptsLabel);
            }
            return this.m_fullAtomicConceptsLabel;
        }

        @Override
        public Set<AtomicRole> getFullFromParentLabel() {
            if (this.m_hasChangedForValidation || this.m_fullFromParentLabel == null) {
                this.m_fullFromParentLabel = ValidatedSingleDirectBlockingChecker.this.fetchAtomicRolesLabel(this.m_node.getParent(), this.m_node, false);
                ValidatedSingleDirectBlockingChecker.this.m_atomicRolesSetFactory.addReference(this.m_fullFromParentLabel);
            }
            return this.m_fullFromParentLabel;
        }

        @Override
        public Set<AtomicRole> getFullToParentLabel() {
            if (this.m_hasChangedForValidation || this.m_fullToParentLabel == null) {
                this.m_fullToParentLabel = ValidatedSingleDirectBlockingChecker.this.fetchAtomicRolesLabel(this.m_node, this.m_node.getParent(), false);
                ValidatedSingleDirectBlockingChecker.this.m_atomicRolesSetFactory.addReference(this.m_fullToParentLabel);
            }
            return this.m_fullToParentLabel;
        }

        @Override
        public void setBlockViolatesParentConstraints(boolean bl) {
            this.m_blockViolatesParentConstraints = bl;
        }

        @Override
        public void setHasAlreadyBeenChecked(boolean bl) {
            this.m_hasAlreadyBeenChecked = bl;
        }

        @Override
        public boolean hasAlreadyBeenChecked() {
            return this.m_hasAlreadyBeenChecked;
        }

        @Override
        public boolean blockViolatesParentConstraints() {
            return this.m_blockViolatesParentConstraints;
        }
    }
}

