/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxmlparser;

import org.coode.owlapi.owlxmlparser.AbstractIRIElementHandler;
import org.coode.owlapi.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLXMLParserElementNotFoundException;
import org.coode.owlapi.owlxmlparser.OWLXMLParserException;
import org.coode.owlapi.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;

public class OWLAnnotationPropertyDomainElementHandler
extends AbstractOWLAxiomElementHandler {
    private IRI domain;
    private OWLAnnotationProperty property;

    public OWLAnnotationPropertyDomainElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    public void handleChild(AbstractIRIElementHandler handler) throws OWLXMLParserException {
        this.domain = (IRI)handler.getOWLObject();
    }

    public void handleChild(OWLAnnotationPropertyElementHandler handler) throws OWLXMLParserException {
        this.property = handler.getOWLObject();
    }

    protected OWLAxiom createAxiom() throws OWLXMLParserException {
        if (this.property == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), this.getColumnNumber(), "Expected annotation property element");
        }
        if (this.domain == null) {
            throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), this.getColumnNumber(), "Expected iri element");
        }
        return this.getOWLDataFactory().getOWLAnnotationPropertyDomainAxiom(this.property, this.domain, this.getAnnotations());
    }
}

