### R code from vignette source 'neaGUI_vignette.Rnw'

###################################################
### code chunk number 1: neaGUI_vignette.Rnw:183-202
###################################################
library(neaGUI)

AGS<-c("AIFM3","DIMT1L","ADNP","AHCYL1","EIF4H","RGL1",
		"SEC23IP","EIF4A1","CSNK2B","NOS3")

NETWORK<-c("DNAJC6 RGL1","C1ORF156 NCBP2","AHCYL1 RTN3",
		"PLK4 SKIV2L2","C22ORF28 MESDC2","TINP1 UTP23",    
		"HEATR3 MVD","WBP11 XAB2","CSNK2B PA2G4","GCN1L1 RRM2",
		"DIMT1L SMC1A","GPN3 THOC3", "DLG3 GPHN",
		"C19ORF29 EXOSC4","AIFM3 SFXN5","HSPA1L RUVBL2",
		"DLAT EIF4A1","ADNP XRCC5", "NOS2 NOS3","CIZ1 TLK2",
		"MRPL49 RPS7","GSPT1 SLK","LUC7L2 SEC23IP","DHX8 IGF2BP3",   
		"CNTROB SASS6","MRPS12 RPLP2","DHODH EIF4H","GINS3 KIF23",
		"ANXA5 TGFBI","CDK5 PMM1")

res <- nea(ags=AGS, fgs = "KEGG", fgslib = "KEGG.db", network=NETWORK,
		pnet = NULL, nperm = 10, stat="F", seed = 1234)

head(res$MainResult) 


