### R code from vignette source 'genoset.Rnw'

###################################################
### code chunk number 1: <options
###################################################
  options(width=90)


###################################################
### code chunk number 2: objectcreation
###################################################
library(genoset)
data(genoset)
gs = GenoSet( locData=locData.gr, cn=fake.cn, pData=fake.pData, annotation="SNP6" )
gs

rle.ds = GenoSet( locData=locData.gr,
  cn = fake.cn,
  cn.segments=DataFrame(
    K=Rle(c(rep(1.5,300),rep(2.3,700))),L=Rle( c(rep(3.2,700),rep(2.1,300)) ),
    M=Rle(rep(1.1,1000)),row.names=rownames(fake.cn)),
  pData=fake.pData,
  annotation="SNP6"
  )


###################################################
### code chunk number 3: objectassaydata
###################################################
names(rle.ds)
head( rle.ds[,,"cn"] )
head( rle.ds[,,"cn.segments"] )


###################################################
### code chunk number 4: accessgenomeinfo
###################################################
head( locData(gs) )
chrNames(gs)
chrOrder(c("chr12","chr12","chrX","chr8","chr7","chrY"))
chrInfo(gs)
chrIndices(gs)
elementLengths(gs)

head(chr(gs))
head(start(gs))
head(end(gs))
head(pos(gs))
head(genoPos(gs))


###################################################
### code chunk number 5: genomeorder
###################################################
chrOrder(chrNames(gs))
gs = toGenomeOrder(gs, strict=TRUE)
isGenomeOrder(gs, strict=TRUE)


###################################################
### code chunk number 6: subsetbychr
###################################################
chr12.ds = gs[ chrIndices(gs,"chr12"), ]
dim(chr12.ds)
chrIndices(chr12.ds)


###################################################
### code chunk number 7: subsetbygene
###################################################
gene.gr = GRanges(ranges=IRanges(start=c(35e6,127e6),end=c(35.5e6,129e6),                       
                       names=c("HER2","CMYC")), seqnames=c("chr17","chr8"))
gene.ds = gs[ gene.gr, ]
dim(gene.ds)
chrIndices(gene.ds)


###################################################
### code chunk number 8: subsetsamples
###################################################
dim(gs[1:4,1:2])


###################################################
### code chunk number 9: subsetassaydata
###################################################
all( gs[ 1:4,1:2,"cn"] == assayDataElement(gs,"cn")[1:4,1:2] )


###################################################
### code chunk number 10: GC (eval = FALSE)
###################################################
## library(BSgenome.Hsapiens.UCSC.hg19)
## gc = rnorm(nrow(cn.ds))
## gs[,,"cn"] = gcCorrect(gs[,,"cn"],gc)


###################################################
### code chunk number 11: cbsdirect
###################################################
library(DNAcopy)
cbs.cna = CNA(gs[,,"cn"], chr(gs), pos(gs) )
cbs.smoothed.CNA = smooth.CNA( cbs.cna )
cbs.segs = segment( cbs.cna )


###################################################
### code chunk number 12: runCBS
###################################################
gs[,,"cn.segs"] = runCBS(gs[,,"cn"],locData(gs))


###################################################
### code chunk number 13: cbsmulticore (eval = FALSE)
###################################################
## library(parallel)
## gs[,,"cn.segs"] = runCBS(cn(cn.ds),locData(cn.ds), n.cores=3)
## gs[,,"cn.segs"][1:5,1:3]


###################################################
### code chunk number 14: segments
###################################################
head( gs[,,"cn.segs"] )

segs = segTable( gs[,2,"cn.segs"], locData(gs) )
list.of.segs = segTable( gs[,,"cn.segs"], locData(gs) )
rbind.list.of.segs = segTable( gs[,,"cn.segs"], locData(gs), stack=TRUE )
two.kinds.of.segs = segPairTable( gs[,2,"cn.segs"], gs[,3,"cn.segs"], locData(gs) )

rle = segs2Rle( segs, locData(gs) )
rle.df = segs2RleDataFrame( list.of.segs, locData(gs) )

bounds = matrix( c(1,3,4,6,7,10),ncol=2,byrow=TRUE)
cn = c(1,3,2)
rle = bounds2Rle( bounds, cn, 10 )


###################################################
### code chunk number 15: genelevel
###################################################
boundingIndicesByChr( gene.gr, locData(gs) )
rangeSampleMeans(gene.gr, gs, "cn.segs")


###################################################
### code chunk number 16: genoset.Rnw:321-322
###################################################
png(file="genoset-plotgenome.png",width=12,height=5,res=150,units="in")


###################################################
### code chunk number 17: plotgenome
###################################################
genoPlot(gs, gs[ , 1, "cn"])
genoPlot(gs, gs[ , 1, "cn.segs"], add=TRUE, col="red")


###################################################
### code chunk number 18: genoset.Rnw:330-331
###################################################
invisible(dev.off())


###################################################
### code chunk number 19: genoset.Rnw:343-344
###################################################
png(file="genoset-plotchr.png",width=12,height=5,res=150,units="in")


###################################################
### code chunk number 20: plotchr
###################################################
genoPlot(gs,gs[,1,"cn"],chr="chr12")
genoPlot(gs,gs[,1,"cn.segs"],chr="chr12",add=TRUE, col="red")


###################################################
### code chunk number 21: genoset.Rnw:352-353
###################################################
invisible(dev.off())


###################################################
### code chunk number 22: plotchrsimple (eval = FALSE)
###################################################
## chr12.ds = cn.ds[chr(cn.ds) == "chr12",]
## genoPlot(pos(chr12.ds),chr12.ds[,1,"cn"],locs=locData(chr12.ds))  # Numeric data and location
## genoPlot(pos(chr12.ds),chr12.ds[,1,"cn.segs"],add=TRUE, col="red") # Rle data and numeric position


###################################################
### code chunk number 23: mbafcutoff
###################################################
baf.ds = GenoSet( locData=locData.gr, lrr=fake.lrr, baf=fake.baf, pData=fake.pData, annotation="SNP6" )
baf.ds[, , "mbaf"] = baf2mbaf(baf.ds[, , "baf"], hom.cutoff = 0.90)


###################################################
### code chunk number 24: mbaftorle
###################################################
mbaf.data = DataFrame( sapply(colnames( baf.ds),
  function(x) { Rle( baf.ds[,x, "mbaf"] ) },
  USE.NAMES=TRUE, simplify=FALSE ) )
as.numeric(object.size( baf.ds[, ,"mbaf"]))  / as.numeric( object.size(mbaf.data))


###################################################
### code chunk number 25: segment
###################################################
baf.ds[,,"baf.segs"] = runCBS( baf.ds[, ,"mbaf"], locData(baf.ds) )
baf.ds[,,"lrr.segs"] = runCBS( baf.ds[, , "lrr"], locData(baf.ds) )


###################################################
### code chunk number 26: genoset.Rnw:426-427
###################################################
png(file="genoset-plotlrr.png",width=7,height=4,res=150,units="in")


###################################################
### code chunk number 27: plotlrr
###################################################
genoPlot(baf.ds,baf.ds[,1,"lrr"],chr="chr12",main="LRR of chr12")
genoPlot(baf.ds,baf.ds[,1,"lrr.segs"],chr="chr12",add=TRUE,col="red")


###################################################
### code chunk number 28: genoset.Rnw:433-434
###################################################
invisible(dev.off())


###################################################
### code chunk number 29: genoset.Rnw:447-448
###################################################
png(file="genoset-plotbaf.png",width=7,height=8,res=150,units="in")


###################################################
### code chunk number 30: plotbaf
###################################################
par(mfrow=c(2,1))
genoPlot(baf.ds,baf.ds[,1,"baf"],chr="chr12", main="BAF of chr12")
genoPlot(baf.ds,baf.ds[,1,"mbaf"],chr="chr12", main="mBAF of chr12")
genoPlot(baf.ds,baf.ds[,1,"baf.segs"],chr="chr12", add=TRUE,col="red")


###################################################
### code chunk number 31: genoset.Rnw:456-457
###################################################
invisible(dev.off())


###################################################
### code chunk number 32: crosssample
###################################################
gain.list = lapply(colnames(baf.ds),
  function(sample.name) {
    as.logical( baf.ds[, sample.name, "lrr.segs"] > 0.3 )
})
gain.mat = do.call(cbind, gain.list)
gain.freq = rowMeans(gain.mat,na.rm=TRUE)


