/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.scale.Scale;
import facs.scale.ScaleArgument;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class PopulationL {
    private static final ColumnComparatorDouble COLUMN_COMPARATOR = new ColumnComparatorDouble(0);

    public static int[][] getBinValues(Scale xScale, Scale yScale, ScaleArgument xScaleArgument, ScaleArgument yScaleArgument, int numXBins, int numYBins, double xMin, double xMax, double yMin, double yMax, double[] xChannelEvents, double[] yChannelEvents) throws IOException {
        double yScaleFactor;
        double scaledYMin;
        double xScaleFactor;
        double scaledXMin;
        double temp;
        if (xMax < xMin) {
            temp = xMin;
            xMin = xMax;
            xMax = temp;
        }
        if (yMax < yMin) {
            temp = yMin;
            yMin = yMax;
            yMax = temp;
        }
        int maxXBin = numXBins - 1;
        int maxYBin = numYBins - 1;
        if (xScaleArgument == null) {
            scaledXMin = xScale.getValue(xMin);
            xScaleFactor = (double)numXBins / (xScale.getValue(xMax) - scaledXMin);
        } else {
            scaledXMin = xScale.getValue(xMin, xScaleArgument);
            xScaleFactor = (double)numXBins / (xScale.getValue(xMax, xScaleArgument) - scaledXMin);
        }
        if (yScaleArgument == null) {
            scaledYMin = yScale.getValue(yMin);
            yScaleFactor = (double)numYBins / (yScale.getValue(yMax) - scaledYMin);
        } else {
            scaledYMin = yScale.getValue(yMin, yScaleArgument);
            yScaleFactor = (double)numYBins / (yScale.getValue(yMax, yScaleArgument) - scaledYMin);
        }
        int[][] bins = new int[numXBins][numYBins];
        for (int i = 0; i < numXBins; ++i) {
            for (int j = 0; j < numYBins; ++j) {
                bins[i][j] = 0;
            }
        }
        int eventCount = xChannelEvents.length;
        for (int eventNumber = 0; eventNumber < eventCount; ++eventNumber) {
            int xBin = xScaleArgument == null ? (int)((xScale.getValue(xChannelEvents[eventNumber]) - scaledXMin) * xScaleFactor) : (int)((xScale.getValue(xChannelEvents[eventNumber], xScaleArgument) - scaledXMin) * xScaleFactor);
            int yBin = yScaleArgument == null ? (int)((yScale.getValue(yChannelEvents[eventNumber]) - scaledYMin) * yScaleFactor) : (int)((yScale.getValue(yChannelEvents[eventNumber], yScaleArgument) - scaledYMin) * yScaleFactor);
            if (xBin < 0) {
                xBin = 0;
            } else if (xBin > maxXBin) {
                xBin = maxXBin;
            }
            if (yBin < 0) {
                yBin = 0;
            } else if (yBin > maxYBin) {
                yBin = maxYBin;
            }
            int[] nArray = bins[xBin];
            int n = yBin;
            nArray[n] = nArray[n] + 1;
        }
        return bins;
    }

    public static double[][] sortBinValues(int[][] binValues) {
        if (binValues == null || binValues.length == 0) {
            return new double[0][0];
        }
        int numXBins = binValues.length;
        int numYBins = binValues[0].length;
        double[][] sortedBinValues = new double[numXBins * numYBins][3];
        int index = 0;
        for (int i = 0; i < binValues.length; ++i) {
            for (int j = 0; j < binValues[i].length; ++j) {
                sortedBinValues[index][0] = binValues[i][j];
                sortedBinValues[index][1] = i;
                sortedBinValues[index][2] = j;
                ++index;
            }
        }
        Arrays.sort(sortedBinValues, COLUMN_COMPARATOR);
        return sortedBinValues;
    }

    public static double[][] sortDensityValues(double[][] densityValues) {
        if (densityValues == null || densityValues.length == 0) {
            return new double[0][0];
        }
        int numXBins = densityValues.length;
        int numYBins = densityValues[0].length;
        double[][] sortedDensityValues = new double[numXBins * numYBins][3];
        int index = 0;
        for (int i = 0; i < densityValues.length; ++i) {
            for (int j = 0; j < densityValues[i].length; ++j) {
                sortedDensityValues[index][0] = densityValues[i][j];
                sortedDensityValues[index][1] = i;
                sortedDensityValues[index][2] = j;
                ++index;
            }
        }
        Arrays.sort(sortedDensityValues, COLUMN_COMPARATOR);
        return sortedDensityValues;
    }

    public static double[][] getTriweightKernelDensityValues(int[][] binValues, double smoothing) {
        int i;
        if (binValues == null || binValues.length <= 0) {
            return new double[0][0];
        }
        int dimensions = 2;
        int numXBins = binValues.length;
        int numYBins = binValues[0].length;
        int numEvents = 0;
        for (int i2 = 0; i2 < numXBins; ++i2) {
            for (int j = 0; j < numYBins; ++j) {
                numEvents += binValues[i2][j];
            }
        }
        double xmean = 0.0;
        for (int x = 0; x < numXBins; ++x) {
            for (int y = 0; y < numYBins; ++y) {
                xmean += (double)(binValues[x][y] * x);
            }
        }
        xmean /= (double)numEvents;
        double xsd = 0.0;
        for (int x = 0; x < numXBins; ++x) {
            for (int y = 0; y < numYBins; ++y) {
                xsd += (double)binValues[x][y] * ((double)x - xmean) * ((double)x - xmean);
            }
        }
        xsd = Math.sqrt(xsd / (double)numEvents);
        double a = Math.pow(4.0 / (double)(4 * numEvents), 0.16666666666666666);
        double xBandwidth = smoothing * xsd * a;
        double ymean = 0.0;
        for (int x = 0; x < numXBins; ++x) {
            for (int y = 0; y < numYBins; ++y) {
                ymean += (double)(binValues[x][y] * y);
            }
        }
        ymean /= (double)numEvents;
        double ysd = 0.0;
        for (int x = 0; x < numXBins; ++x) {
            for (int y = 0; y < numYBins; ++y) {
                ysd += (double)binValues[x][y] * ((double)y - ymean) * ((double)y - ymean);
            }
        }
        ysd = Math.sqrt(ysd / (double)numEvents);
        double yBandwidth = smoothing * ysd * a;
        int nx = (int)xBandwidth;
        int ny = (int)yBandwidth;
        double[] kernelEvaluationsX = new double[nx + 1];
        double[] kernelEvaluationsY = new double[ny + 1];
        for (i = 0; i < nx + 1; ++i) {
            kernelEvaluationsX[i] = PopulationL.computeTriweightAtPoint((double)i / xBandwidth);
        }
        for (i = 0; i < ny + 1; ++i) {
            kernelEvaluationsY[i] = PopulationL.computeTriweightAtPoint((double)i / yBandwidth);
        }
        double[][] densityValues = new double[numXBins][numYBins];
        for (int i3 = 0; i3 < numXBins; ++i3) {
            for (int j = 0; j < numYBins; ++j) {
                if (binValues[i3][j] == 0) continue;
                int startP = Math.max(-nx, -i3);
                int endP = Math.min(nx, numXBins - 1 - i3);
                for (int p = startP; p <= endP; ++p) {
                    int startQ = Math.max(-ny, -j);
                    int endQ = Math.min(ny, numYBins - 1 - j);
                    for (int q = startQ; q <= endQ; ++q) {
                        double[] dArray = densityValues[i3 + p];
                        int n = j + q;
                        dArray[n] = dArray[n] + (double)binValues[i3][j] * kernelEvaluationsX[Math.abs(p)] * kernelEvaluationsY[Math.abs(q)];
                    }
                }
            }
        }
        return densityValues;
    }

    static double computeTriweightAtPoint(double p) {
        if (p < -1.0 || p > 1.0) {
            return 0.0;
        }
        double oneminuspsquared = 1.0 - p * p;
        return oneminuspsquared * oneminuspsquared * oneminuspsquared;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ColumnComparatorDouble
    implements Comparator<double[]> {
        private final int col;

        private ColumnComparatorDouble(int col) {
            this.col = col < 0 ? 0 : col;
        }

        @Override
        public int compare(double[] a, double[] b) {
            if (this.col >= a.length && this.col >= b.length) {
                return 0;
            }
            if (this.col >= a.length) {
                return -1;
            }
            if (this.col >= b.length) {
                return 1;
            }
            return (int)Math.signum(a[this.col] - b[this.col]);
        }
    }
}

