/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.virtual;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import uk.ac.ebi.ontocat.AbstractOntologyService;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyIdTranslator;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatedOntologyService
extends AbstractOntologyService {
    private OntologyService os;
    private OntologyIdTranslator translator;
    private static final Logger log = Logger.getLogger(TranslatedOntologyService.class);

    public TranslatedOntologyService(OntologyService os, OntologyIdTranslator translator) {
        this.os = os;
        this.translator = translator;
    }

    @Override
    public Map<String, List<String>> getAnnotations(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getAnnotations(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public List<OntologyTerm> getChildren(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getChildren(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public List<String> getDefinitions(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getDefinitions(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public List<Ontology> getOntologies() throws OntologyServiceException {
        return this.os.getOntologies();
    }

    @Override
    public Ontology getOntology(String ontologyAccession) throws OntologyServiceException {
        return this.os.getOntology(this.translator.getTranslatedOntologyAccession(ontologyAccession));
    }

    @Override
    public List<OntologyTerm> getParents(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getParents(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public Map<String, Set<OntologyTerm>> getRelations(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getRelations(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public List<OntologyTerm> getRootTerms(String ontologyAccession) throws OntologyServiceException {
        return this.os.getRootTerms(this.translator.getTranslatedOntologyAccession(ontologyAccession));
    }

    @Override
    public List<String> getSynonyms(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getSynonyms(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public OntologyTerm getTerm(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getTerm(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public List<OntologyTerm> getTermPath(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.os.getTermPath(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public List<OntologyTerm> searchAll(String query, OntologyService.SearchOptions ... options) throws OntologyServiceException {
        return this.os.searchAll(query, options);
    }

    @Override
    public List<OntologyTerm> searchOntology(String ontologyAccession, String query, OntologyService.SearchOptions ... options) throws OntologyServiceException {
        return this.os.searchOntology(this.translator.getTranslatedOntologyAccession(ontologyAccession), query, options);
    }

    @Override
    public OntologyTerm getTerm(String termAccession) throws OntologyServiceException {
        return this.os.getTerm(this.translator.getOntologyAccFromTermAcc(termAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    @Override
    public String makeLookupHyperlink(String termAccession) {
        try {
            return this.os.makeLookupHyperlink(this.translator.getOntologyAccFromTermAcc(termAccession), this.translator.getTranslatedTermAccession(termAccession));
        }
        catch (OntologyServiceException e) {
            e.printStackTrace();
            log.error("Making lookup hyperlink failed for " + termAccession);
            return null;
        }
    }

    @Override
    public String makeLookupHyperlink(String ontologyAccession, String termAccession) {
        try {
            return this.os.makeLookupHyperlink(this.translator.getTranslatedOntologyAccession(ontologyAccession), this.translator.getTranslatedTermAccession(termAccession));
        }
        catch (OntologyServiceException e) {
            e.printStackTrace();
            log.error("Making lookup hyperlink failed for " + termAccession);
            return null;
        }
    }

    public List<String> getSynonyms(String termAccession) throws OntologyServiceException {
        return this.os.getSynonyms(this.translator.getOntologyAccFromTermAcc(termAccession), this.translator.getTranslatedTermAccession(termAccession));
    }

    public List<String> getDefinitions(String termAccession) throws OntologyServiceException {
        return this.os.getDefinitions(this.translator.getOntologyAccFromTermAcc(termAccession), this.translator.getTranslatedTermAccession(termAccession));
    }
}

