/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.file;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.file.FileOntologyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonedFileOntologyService
extends FileOntologyService
implements OntologyService {
    private OWLReasoner reasoner;
    private Map<OWLObjectProperty, OWLObjectProperty> cacheInverseProperty = new HashMap<OWLObjectProperty, OWLObjectProperty>();
    private Map<OWLObjectProperty, String> cachePropertyLabel = new HashMap<OWLObjectProperty, String>();
    private Map<String, OWLObjectProperty> cachePropertyByLabel = new HashMap<String, OWLObjectProperty>();
    private OWLDataFactory factory;
    private static final Logger log = Logger.getLogger(ReasonedFileOntologyService.class);

    public ReasonedFileOntologyService(URI uriOntology) throws OntologyServiceException {
        super(uriOntology);
        this.runCommonInstantiationCode(uriOntology);
    }

    public ReasonedFileOntologyService(URI uriOntology, String ontologyAccession) throws OntologyServiceException {
        super(uriOntology, ontologyAccession);
        this.runCommonInstantiationCode(uriOntology);
    }

    private void runCommonInstantiationCode(URI uriOntology) throws OntologyServiceException {
        this.fixPropertiesURIs();
        this.injectInverseObjectProperties();
        this.instantiateReasoner(uriOntology);
    }

    private void fixPropertiesURIs() {
        for (OWLObjectProperty prop : this.ontology.getObjectPropertiesInSignature()) {
            if (prop.getReferencingAxioms(this.ontology).size() != 1) continue;
            this.loader.getManager().removeAxiom(this.ontology, this.loader.getManager().getOWLDataFactory().getOWLDeclarationAxiom(prop));
        }
    }

    private void injectInverseObjectProperties() throws OntologyServiceException {
        this.factory = this.loader.getManager().getOWLDataFactory();
        HashMap<String, OWLObjectProperty> propertyCache = new HashMap<String, OWLObjectProperty>();
        for (OWLObjectProperty rel : this.ontology.getObjectPropertiesInSignature()) {
            propertyCache.put(this.getLabel(rel), rel);
        }
        HashMap<String, String> ROinverses = new HashMap<String, String>();
        ROinverses.put("part_of", "has_part");
        ROinverses.put("has_part", "part_of");
        ROinverses.put("integral_part_of", "has_integral_part");
        ROinverses.put("has_integral_part", "integral_part_of");
        ROinverses.put("proper_part_of", "has_proper_part");
        ROinverses.put("has_proper_part", "proper_part_of");
        ROinverses.put("located_in", "location_of");
        ROinverses.put("location_of", "located_in");
        ROinverses.put("improper_part_of", "has_improper_part");
        ROinverses.put("has_improper_part", "improper_part_of");
        ROinverses.put("agent_in", "has_agent");
        ROinverses.put("has_agent", "agent_in");
        ROinverses.put("participates_in", "has_participant");
        ROinverses.put("has_participant", "participates_in");
        ROinverses.put("precedes", "preceded_by");
        ROinverses.put("preceded_by", "precedes");
        ROinverses.put("derived_into", "derives_from");
        ROinverses.put("derives_from", "derived_into");
        ROinverses.put("transformation_of", "transformed_into");
        ROinverses.put("transformed_into", "transformation_of");
        ROinverses.put("contained_in", "contains");
        ROinverses.put("contains", "contained_in");
        HashSet<OWLInverseObjectPropertiesAxiom> axiomsToAdd = new HashSet<OWLInverseObjectPropertiesAxiom>();
        for (Map.Entry e : propertyCache.entrySet()) {
            OWLObjectProperty forward = (OWLObjectProperty)e.getValue();
            if (!ROinverses.containsKey(e.getKey())) continue;
            String inverseLabel = (String)ROinverses.get(e.getKey());
            if (propertyCache.containsKey(inverseLabel)) {
                OWLObjectProperty inverse = (OWLObjectProperty)propertyCache.get(inverseLabel);
                OWLInverseObjectPropertiesAxiom inverseAxiom = this.factory.getOWLInverseObjectPropertiesAxiom(forward, inverse);
                axiomsToAdd.add(inverseAxiom);
                continue;
            }
            log.warn("The inverse object property " + inverseLabel + " for " + (String)e.getKey() + " was not found in the ontology");
        }
        this.loader.getManager().addAxioms(this.ontology, axiomsToAdd);
    }

    private void instantiateReasoner(URI uriOntology) throws OntologyServiceException {
        Reasoner.ReasonerFactory reasonerFactory = new Reasoner.ReasonerFactory();
        this.reasoner = reasonerFactory.createReasoner(this.ontology);
        this.reasoner.precomputeInferences(new InferenceType[0]);
        if (!this.reasoner.isConsistent()) {
            throw new OntologyServiceException("Inconsistent ontology according to HermiT reasoner - " + uriOntology.toString());
        }
        log.info("Classified the ontology " + uriOntology.toString());
        this.factory = this.loader.getManager().getOWLDataFactory();
        for (OWLObjectProperty prop : this.ontology.getObjectPropertiesInSignature(false)) {
            OWLObjectProperty inverse = this.findInverseObjectProperty(prop);
            this.cacheInverseProperty.put(prop, inverse);
            this.cachePropertyLabel.put(prop, this.getLabel(prop));
            this.cachePropertyByLabel.put(this.getLabel(prop), prop);
        }
    }

    @Override
    public Map<String, Set<OntologyTerm>> getRelations(String ontologyAccession, String termAccession) throws OntologyServiceException {
        OWLEntity ent = this.getOwlEntity(termAccession);
        if (!ent.isOWLClass()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<OntologyTerm>> result = new HashMap<String, Set<OntologyTerm>>();
        for (OWLObjectProperty prop : this.cacheInverseProperty.keySet()) {
            Set<OntologyTerm> relatedTerms = this.getSpecificRelation(ent.asOWLClass(), prop);
            if (relatedTerms == null) continue;
            result.put(this.cachePropertyLabel.get(prop), relatedTerms);
        }
        return result;
    }

    private Set<OntologyTerm> getSpecificRelation(OWLClass clsQueried, OWLObjectProperty prop) throws OntologyServiceException {
        OWLObjectProperty inverse = this.cacheInverseProperty.get(prop);
        if (inverse == null) {
            return null;
        }
        OWLObjectSomeValuesFrom relationSomeObject = this.factory.getOWLObjectSomeValuesFrom(inverse, clsQueried);
        HashSet<OWLClass> sRelatedClasses = new HashSet<OWLClass>();
        sRelatedClasses.addAll(this.reasoner.getSubClasses(relationSomeObject, true).getFlattened());
        HashSet<OntologyTerm> sFilteredResult = new HashSet<OntologyTerm>();
        for (OWLClass cls : sRelatedClasses) {
            if (cls.isBuiltIn()) continue;
            sFilteredResult.add(this.getTerm(cls));
        }
        return sFilteredResult;
    }

    public Set<OntologyTerm> getSpecificRelation(String ontologyAccession, String termAccession, String relation) throws OntologyServiceException {
        OWLEntity ent = this.getOwlEntity(termAccession);
        if (!ent.isOWLClass()) {
            return Collections.emptySet();
        }
        OWLObjectProperty prop = this.cachePropertyByLabel.get(relation);
        if (prop == null) {
            return Collections.emptySet();
        }
        Set<OntologyTerm> relatedTerms = this.getSpecificRelation(ent.asOWLClass(), prop);
        if (relatedTerms != null) {
            return relatedTerms;
        }
        return Collections.emptySet();
    }

    private OWLObjectProperty findInverseObjectProperty(OWLObjectProperty prop) {
        Set<OWLObjectPropertyExpression> inverse = this.reasoner.getInverseObjectProperties(prop).getEntities();
        for (OWLObjectPropertyExpression pe : inverse) {
            if (pe.isAnonymous()) continue;
            return pe.asOWLObjectProperty();
        }
        return null;
    }

    @Override
    public List<OntologyTerm> getChildren(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        ArrayList<OntologyTerm> list = new ArrayList<OntologyTerm>();
        OWLEntity ent = this.getOwlEntity(termAccession);
        if (ent == null) {
            return Collections.emptyList();
        }
        if (ent.isOWLClass()) {
            for (OWLClass cls : this.reasoner.getSubClasses(ent.asOWLClass(), true).getFlattened()) {
                if (cls.isBuiltIn()) continue;
                list.add(this.getTerm(cls));
            }
        }
        return list;
    }

    @Override
    public List<OntologyTerm> getParents(String ontologyAccession, String termAccession) throws OntologyServiceException {
        if (!this.ontoAccessions.contains(ontologyAccession)) {
            return Collections.emptyList();
        }
        ArrayList<OntologyTerm> list = new ArrayList<OntologyTerm>();
        OWLEntity ent = this.getOwlEntity(termAccession);
        if (ent == null) {
            return Collections.emptyList();
        }
        if (ent.isOWLClass()) {
            for (OWLClass cls : this.reasoner.getSuperClasses(ent.asOWLClass(), true).getFlattened()) {
                if (cls.isBuiltIn()) continue;
                list.add(this.getTerm(cls));
            }
        }
        if (ent.isOWLNamedIndividual()) {
            for (OWLClass cls : this.reasoner.getTypes(ent.asOWLNamedIndividual(), true).getFlattened()) {
                list.add(this.getTerm(cls));
            }
        }
        return list;
    }
}

