/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.HashMap;
import java.util.Iterator;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;
import rationals.properties.ContainsEpsilon;
import rationals.transformations.BinaryTransformation;
import rationals.transformations.Normalizer;

public class Concatenation
implements BinaryTransformation {
    public Automaton transform(Automaton a, Automaton b) {
        Transition t;
        State n;
        State e;
        Automaton ap = new Normalizer().transform(a);
        Automaton bp = new Normalizer().transform(b);
        ContainsEpsilon ce = new ContainsEpsilon();
        boolean ace = ce.test(a);
        boolean bce = ce.test(b);
        if (ap.states().size() == 0 && ace) {
            return b;
        }
        if (bp.states().size() == 0 && bce) {
            return a;
        }
        State junc = null;
        Automaton c = new Automaton();
        HashMap<State, State> map = new HashMap<State, State>();
        Iterator i = ap.states().iterator();
        while (i.hasNext()) {
            e = (State)i.next();
            if (e.isInitial()) {
                n = c.addState(true, ace && bce);
            } else {
                if (e.isTerminal()) continue;
                n = c.addState(false, e.isTerminal() && bce);
            }
            map.put(e, n);
        }
        i = bp.states().iterator();
        while (i.hasNext()) {
            e = (State)i.next();
            if (e.isInitial()) continue;
            n = c.addState(false, e.isTerminal());
            map.put(e, n);
        }
        junc = c.addState(ace, bce);
        i = ap.delta().iterator();
        while (i.hasNext()) {
            t = (Transition)i.next();
            try {
                if (t.end().isTerminal()) {
                    c.addTransition(new Transition((State)map.get(t.start()), t.label(), junc));
                    continue;
                }
                c.addTransition(new Transition((State)map.get(t.start()), t.label(), (State)map.get(t.end())));
            }
            catch (NoSuchStateException x) {}
        }
        i = bp.delta().iterator();
        while (i.hasNext()) {
            t = (Transition)i.next();
            try {
                if (t.start().isInitial()) {
                    c.addTransition(new Transition(junc, t.label(), (State)map.get(t.end())));
                    continue;
                }
                c.addTransition(new Transition((State)map.get(t.start()), t.label(), (State)map.get(t.end())));
            }
            catch (NoSuchStateException x) {}
        }
        return c;
    }
}

