/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.TupleTableFullIndex;

public class ExtensionTableWithFullIndex
extends ExtensionTable {
    private static final long serialVersionUID = 2856811178050960058L;
    protected final TupleTableFullIndex m_tupleTableFullIndex;
    protected final Object[] m_auxiliaryTuple;

    public ExtensionTableWithFullIndex(Tableau tableau, int n, boolean bl) {
        super(tableau, n, bl);
        this.m_tupleTableFullIndex = new TupleTableFullIndex(this.m_tupleTable, this.m_tupleArity);
        this.m_auxiliaryTuple = new Object[this.m_tupleArity];
    }

    public int sizeInMemory() {
        return this.m_tupleTable.sizeInMemory() + this.m_tupleTableFullIndex.sizeInMemory();
    }

    public boolean addTuple(Object[] objectArray, DependencySet dependencySet, boolean bl) {
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.addFactStarted(objectArray, bl);
        }
        if (!(!this.isTupleActive(objectArray) || !this.m_tableau.m_needsThingExtension && AtomicConcept.THING.equals(objectArray[0]) || !this.m_tableau.m_needsRDFSLiteralExtension && InternalDatatype.RDFS_LITERAL.equals(objectArray[0]))) {
            int n = this.m_tupleTable.getFirstFreeTupleIndex();
            int n2 = this.m_tupleTableFullIndex.addTuple(objectArray, n);
            if (n2 == n) {
                this.m_tupleTable.addTuple(objectArray);
                this.m_dependencySetManager.setDependencySet(n2, dependencySet);
                this.m_coreManager.setCore(n2, bl);
                this.m_afterDeltaNewTupleIndex = this.m_tupleTable.getFirstFreeTupleIndex();
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.addFactFinished(objectArray, bl, true);
                }
                this.postAdd(objectArray, dependencySet, n2, bl);
                return true;
            }
            if (bl && !this.m_coreManager.isCore(n2)) {
                this.m_coreManager.addCore(n2);
                Object object = objectArray[0];
                if (object instanceof Concept) {
                    this.m_tableau.m_existentialExpansionStrategy.assertionCoreSet((Concept)object, (Node)objectArray[1]);
                } else if (object instanceof AtomicRole) {
                    this.m_tableau.m_existentialExpansionStrategy.assertionCoreSet((AtomicRole)object, (Node)objectArray[1], (Node)objectArray[2]);
                }
            }
        }
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.addFactFinished(objectArray, bl, false);
        }
        return false;
    }

    public boolean containsTuple(Object[] objectArray) {
        int n = this.m_tupleTableFullIndex.getTupleIndex(objectArray);
        return n != -1 && this.isTupleActive(n);
    }

    public DependencySet getDependencySet(Object[] objectArray) {
        int n = this.m_tupleTableFullIndex.getTupleIndex(objectArray);
        if (n == -1) {
            return null;
        }
        return this.m_dependencySetManager.getDependencySet(n);
    }

    public boolean isCore(Object[] objectArray) {
        int n = this.m_tupleTableFullIndex.getTupleIndex(objectArray);
        if (n == -1) {
            return false;
        }
        return this.m_coreManager.isCore(n);
    }

    public ExtensionTable.Retrieval createRetrieval(int[] nArray, Object[] objectArray, Object[] objectArray2, boolean bl, ExtensionTable.View view) {
        int n = 0;
        for (int i = this.m_tupleArity - 1; i >= 0; --i) {
            if (nArray[i] == -1) continue;
            ++n;
        }
        if (n == this.m_tupleArity) {
            return new IndexedRetrieval(nArray, objectArray, objectArray2, bl, view);
        }
        return new ExtensionTable.UnindexedRetrieval(nArray, objectArray, objectArray2, bl, view);
    }

    protected void removeTuple(int n) {
        this.m_tupleTableFullIndex.removeTuple(n);
        this.m_tupleTable.retrieveTuple(this.m_auxiliaryTuple, n);
        this.postRemove(this.m_auxiliaryTuple, n);
    }

    public void clear() {
        super.clear();
        this.m_tupleTableFullIndex.clear();
    }

    protected class IndexedRetrieval
    implements ExtensionTable.Retrieval,
    Serializable {
        private static final long serialVersionUID = 5984560476970027366L;
        protected final int[] m_bindingPositions;
        protected final Object[] m_bindingsBuffer;
        protected final Object[] m_tupleBuffer;
        protected final boolean m_ownsBuffers;
        protected final ExtensionTable.View m_extensionView;
        protected int m_currentTupleIndex;

        public IndexedRetrieval(int[] nArray, Object[] objectArray, Object[] objectArray2, boolean bl, ExtensionTable.View view) {
            this.m_bindingPositions = nArray;
            this.m_bindingsBuffer = objectArray;
            this.m_tupleBuffer = objectArray2;
            this.m_ownsBuffers = bl;
            this.m_extensionView = view;
        }

        public ExtensionTable getExtensionTable() {
            return ExtensionTableWithFullIndex.this;
        }

        public ExtensionTable.View getExtensionView() {
            return this.m_extensionView;
        }

        public void clear() {
            if (this.m_ownsBuffers) {
                int n;
                for (n = this.m_bindingsBuffer.length - 1; n >= 0; --n) {
                    this.m_bindingsBuffer[n] = null;
                }
                for (n = this.m_tupleBuffer.length - 1; n >= 0; --n) {
                    this.m_tupleBuffer[n] = null;
                }
            }
        }

        public int[] getBindingPositions() {
            return this.m_bindingPositions;
        }

        public Object[] getBindingsBuffer() {
            return this.m_bindingsBuffer;
        }

        public Object[] getTupleBuffer() {
            return this.m_tupleBuffer;
        }

        public DependencySet getDependencySet() {
            if (this.m_currentTupleIndex == -1) {
                return null;
            }
            return ExtensionTableWithFullIndex.this.m_dependencySetManager.getDependencySet(this.m_currentTupleIndex);
        }

        public boolean isCore() {
            if (this.m_currentTupleIndex == -1) {
                return false;
            }
            return ExtensionTableWithFullIndex.this.m_coreManager.isCore(this.m_currentTupleIndex);
        }

        public void open() {
            this.m_currentTupleIndex = ExtensionTableWithFullIndex.this.m_tupleTableFullIndex.getTupleIndex(this.m_bindingsBuffer, this.m_bindingPositions);
            switch (this.m_extensionView) {
                case EXTENSION_THIS: {
                    if (0 <= this.m_currentTupleIndex && this.m_currentTupleIndex < ExtensionTableWithFullIndex.this.m_afterExtensionThisTupleIndex) break;
                    this.m_currentTupleIndex = -1;
                    break;
                }
                case EXTENSION_OLD: {
                    if (0 <= this.m_currentTupleIndex && this.m_currentTupleIndex < ExtensionTableWithFullIndex.this.m_afterExtensionOldTupleIndex) break;
                    this.m_currentTupleIndex = -1;
                    break;
                }
                case DELTA_OLD: {
                    if (ExtensionTableWithFullIndex.this.m_afterExtensionOldTupleIndex <= this.m_currentTupleIndex && this.m_currentTupleIndex < ExtensionTableWithFullIndex.this.m_afterExtensionThisTupleIndex) break;
                    this.m_currentTupleIndex = -1;
                    break;
                }
                case TOTAL: {
                    if (0 <= this.m_currentTupleIndex && this.m_currentTupleIndex < ExtensionTableWithFullIndex.this.m_afterDeltaNewTupleIndex) break;
                    this.m_currentTupleIndex = -1;
                }
            }
            if (this.m_currentTupleIndex != -1) {
                ExtensionTableWithFullIndex.this.m_tupleTable.retrieveTuple(this.m_tupleBuffer, this.m_currentTupleIndex);
                if (!ExtensionTableWithFullIndex.this.isTupleActive(this.m_tupleBuffer)) {
                    this.m_currentTupleIndex = -1;
                }
            }
        }

        public boolean afterLast() {
            return this.m_currentTupleIndex == -1;
        }

        public int getCurrentTupleIndex() {
            return this.m_currentTupleIndex;
        }

        public void next() {
            ++this.m_currentTupleIndex;
        }
    }
}

