/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.DatatypeRestriction;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.model.ExistsDescriptionGraph;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.model.LiteralConcept;
import org.semanticweb.HermiT.model.NodeIDLessEqualThan;
import org.semanticweb.HermiT.model.NodeIDsAscendingOrEqual;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLOntology
implements Serializable {
    private static final long serialVersionUID = 3189937959595369812L;
    protected static final String CRLF = System.getProperty("line.separator");
    protected static final int CONTAINS_NO_ROLES = 0;
    protected static final int CONTAINS_ONLY_GRAPH_ROLES = 1;
    protected static final int CONTAINS_ONLY_TREE_ROLES = 2;
    protected static final int CONTAINS_GRAPH_AND_TREE_ROLES = 3;
    protected final String m_ontologyIRI;
    protected final Set<DLClause> m_dlClauses;
    protected final Set<Atom> m_positiveFacts;
    protected final Set<Atom> m_negativeFacts;
    protected final boolean m_hasInverseRoles;
    protected final boolean m_hasAtMostRestrictions;
    protected final boolean m_hasNominals;
    protected final boolean m_hasDatatypes;
    protected final boolean m_isHorn;
    protected final Set<AtomicConcept> m_allAtomicConcepts;
    protected final int m_numberOfExternalConcepts;
    protected final Set<AtomicRole> m_allAtomicObjectRoles;
    protected final Set<Role> m_allComplexObjectRoles;
    protected final Set<AtomicRole> m_allAtomicDataRoles;
    protected final Set<DatatypeRestriction> m_allUnknownDatatypeRestrictions;
    protected final Set<String> m_definedDatatypeIRIs;
    protected final Set<Individual> m_allIndividuals;
    protected final Set<DescriptionGraph> m_allDescriptionGraphs;
    protected final Map<AtomicRole, Map<Individual, Set<Constant>>> m_dataPropertyAssertions;

    public DLOntology(String string, Set<DLClause> set, Set<Atom> set2, Set<Atom> set3, Set<AtomicConcept> set4, Set<AtomicRole> set5, Set<Role> set6, Set<AtomicRole> set7, Set<DatatypeRestriction> set8, Set<String> set9, Set<Individual> set10, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        this.m_ontologyIRI = string;
        this.m_dlClauses = set;
        this.m_positiveFacts = set2;
        this.m_negativeFacts = set3;
        this.m_hasInverseRoles = bl;
        this.m_hasAtMostRestrictions = bl2;
        this.m_hasNominals = bl3;
        this.m_hasDatatypes = bl4;
        this.m_allAtomicConcepts = set4 == null ? new TreeSet<AtomicConcept>(AtomicConceptComparator.INSTANCE) : set4;
        int n = 0;
        for (AtomicConcept object2 : this.m_allAtomicConcepts) {
            if (Prefixes.isInternalIRI(object2.getIRI())) continue;
            ++n;
        }
        this.m_numberOfExternalConcepts = n;
        this.m_allAtomicObjectRoles = set5 == null ? new TreeSet<AtomicRole>(AtomicRoleComparator.INSTANCE) : set5;
        this.m_allComplexObjectRoles = set6 == null ? new HashSet<Role>() : set6;
        this.m_allAtomicDataRoles = set7 == null ? new TreeSet<AtomicRole>(AtomicRoleComparator.INSTANCE) : set7;
        this.m_allUnknownDatatypeRestrictions = set8 == null ? new HashSet<DatatypeRestriction>() : set8;
        this.m_definedDatatypeIRIs = set9 == null ? new HashSet<String>() : set9;
        this.m_allIndividuals = set10 == null ? new TreeSet<Individual>(IndividualComparator.INSTANCE) : set10;
        this.m_allDescriptionGraphs = new HashSet<DescriptionGraph>();
        boolean bl5 = true;
        for (DLClause dLClause : this.m_dlClauses) {
            int n2;
            if (dLClause.getHeadLength() > 1) {
                bl5 = false;
            }
            for (n2 = dLClause.getBodyLength() - 1; n2 >= 0; --n2) {
                object = dLClause.getBodyAtom(n2).getDLPredicate();
                this.addDLPredicate((DLPredicate)object);
            }
            for (n2 = dLClause.getHeadLength() - 1; n2 >= 0; --n2) {
                object = dLClause.getHeadAtom(n2).getDLPredicate();
                this.addDLPredicate((DLPredicate)object);
            }
        }
        this.m_isHorn = bl5;
        this.m_dataPropertyAssertions = new HashMap<AtomicRole, Map<Individual, Set<Constant>>>();
        for (Atom atom : this.m_positiveFacts) {
            Set<Constant> set11;
            Map<Object, Object> map;
            Term term;
            this.addDLPredicate(atom.getDLPredicate());
            for (int i = 0; i < atom.getArity(); ++i) {
                object = atom.getArgument(i);
                if (!(object instanceof Individual)) continue;
                this.m_allIndividuals.add((Individual)object);
            }
            if (atom.getArity() != 2 || !((term = atom.getArgument(1)) instanceof Constant)) continue;
            object = (Individual)atom.getArgument(0);
            assert (atom.getDLPredicate() instanceof AtomicRole);
            AtomicRole atomicRole = (AtomicRole)atom.getDLPredicate();
            if (this.m_dataPropertyAssertions.containsKey(atomicRole)) {
                map = this.m_dataPropertyAssertions.get(atomicRole);
            } else {
                map = new HashMap();
                this.m_dataPropertyAssertions.put(atomicRole, map);
            }
            if (map.containsKey(object)) {
                set11 = (Set)map.get(object);
            } else {
                set11 = new HashSet();
                map.put(object, set11);
            }
            set11.add((Constant)term);
        }
        for (Atom atom : this.m_negativeFacts) {
            this.addDLPredicate(atom.getDLPredicate());
            for (int i = 0; i < atom.getArity(); ++i) {
                object = atom.getArgument(i);
                if (!(object instanceof Individual)) continue;
                this.m_allIndividuals.add((Individual)object);
            }
        }
    }

    protected void addDLPredicate(DLPredicate dLPredicate) {
        if (dLPredicate instanceof AtomicConcept) {
            this.m_allAtomicConcepts.add((AtomicConcept)dLPredicate);
        } else if (dLPredicate instanceof AtLeastConcept) {
            LiteralConcept literalConcept = ((AtLeastConcept)dLPredicate).getToConcept();
            if (literalConcept instanceof AtomicConcept) {
                this.m_allAtomicConcepts.add((AtomicConcept)literalConcept);
            }
        } else if (dLPredicate instanceof DescriptionGraph) {
            this.m_allDescriptionGraphs.add((DescriptionGraph)dLPredicate);
        } else if (dLPredicate instanceof ExistsDescriptionGraph) {
            this.m_allDescriptionGraphs.add(((ExistsDescriptionGraph)dLPredicate).getDescriptionGraph());
        }
    }

    public String getOntologyIRI() {
        return this.m_ontologyIRI;
    }

    public Set<AtomicConcept> getAllAtomicConcepts() {
        return this.m_allAtomicConcepts;
    }

    public boolean containsAtomicConcept(AtomicConcept atomicConcept) {
        return this.m_allAtomicConcepts.contains(atomicConcept);
    }

    public int getNumberOfExternalConcepts() {
        return this.m_numberOfExternalConcepts;
    }

    public Set<AtomicRole> getAllAtomicObjectRoles() {
        return this.m_allAtomicObjectRoles;
    }

    public boolean containsObjectRole(AtomicRole atomicRole) {
        return this.m_allAtomicObjectRoles.contains(atomicRole);
    }

    public Set<Role> getAllComplexObjectRoles() {
        return this.m_allComplexObjectRoles;
    }

    public boolean isComplexObjectRole(Role role) {
        return this.m_allComplexObjectRoles.contains(role);
    }

    public Set<AtomicRole> getAllAtomicDataRoles() {
        return this.m_allAtomicDataRoles;
    }

    public boolean containsDataRole(AtomicRole atomicRole) {
        return this.m_allAtomicDataRoles.contains(atomicRole);
    }

    public Set<DatatypeRestriction> getAllUnknownDatatypeRestrictions() {
        return this.m_allUnknownDatatypeRestrictions;
    }

    public Set<Individual> getAllIndividuals() {
        return this.m_allIndividuals;
    }

    public boolean containsIndividual(Individual individual) {
        return this.m_allIndividuals.contains(individual);
    }

    public Set<DescriptionGraph> getAllDescriptionGraphs() {
        return this.m_allDescriptionGraphs;
    }

    public Set<DLClause> getDLClauses() {
        return this.m_dlClauses;
    }

    public Set<Atom> getPositiveFacts() {
        return this.m_positiveFacts;
    }

    public Map<AtomicRole, Map<Individual, Set<Constant>>> getDataPropertyAssertions() {
        return this.m_dataPropertyAssertions;
    }

    public Set<Atom> getNegativeFacts() {
        return this.m_negativeFacts;
    }

    public boolean hasInverseRoles() {
        return this.m_hasInverseRoles;
    }

    public boolean hasAtMostRestrictions() {
        return this.m_hasAtMostRestrictions;
    }

    public boolean hasNominals() {
        return this.m_hasNominals;
    }

    public boolean hasDatatypes() {
        return this.m_hasDatatypes;
    }

    public boolean hasUnknownDatatypeRestrictions() {
        return !this.m_allUnknownDatatypeRestrictions.isEmpty();
    }

    public boolean isHorn() {
        return this.m_isHorn;
    }

    public Set<String> getDefinedDatatypeIRIs() {
        return this.m_definedDatatypeIRIs;
    }

    public Collection<DLClause> getNonadmissibleDLClauses() {
        Set<AtomicConcept> set = this.getBodyOnlyAtomicConcepts();
        HashSet<DLClause> hashSet = new HashSet<DLClause>();
        Set<AtomicRole> set2 = this.computeGraphAtomicRoles();
        for (DLClause dLClause : this.m_dlClauses) {
            if (dLClause.isKnownToBeAdmissible()) continue;
            int n = this.getUsedRoleTypes(dLClause, set2);
            switch (n) {
                case 0: 
                case 2: {
                    if (this.isTreeDLClause(dLClause, set2, set)) break;
                    hashSet.add(dLClause);
                    break;
                }
                case 1: {
                    if (this.isGraphDLClause(dLClause)) break;
                    hashSet.add(dLClause);
                    break;
                }
                case 3: {
                    hashSet.add(dLClause);
                }
            }
        }
        return hashSet;
    }

    protected Set<AtomicConcept> getBodyOnlyAtomicConcepts() {
        HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>(this.m_allAtomicConcepts);
        for (DLClause dLClause : this.m_dlClauses) {
            for (int i = 0; i < dLClause.getHeadLength(); ++i) {
                DLPredicate dLPredicate = dLClause.getHeadAtom(i).getDLPredicate();
                hashSet.remove(dLPredicate);
                if (!(dLPredicate instanceof AtLeastConcept)) continue;
                hashSet.remove(((AtLeastConcept)dLPredicate).getToConcept());
            }
        }
        return hashSet;
    }

    protected Set<AtomicRole> computeGraphAtomicRoles() {
        HashSet<AtomicRole> hashSet = new HashSet<AtomicRole>();
        for (DescriptionGraph object : this.m_allDescriptionGraphs) {
            for (int dLClause = 0; dLClause < object.getNumberOfEdges(); ++dLClause) {
                DescriptionGraph.Edge edge = object.getEdge(dLClause);
                hashSet.add(edge.getAtomicRole());
            }
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (DLClause dLClause : this.m_dlClauses) {
                if (!this.containsAtomicRoles(dLClause, hashSet) || !this.addAtomicRoles(dLClause, hashSet)) continue;
                bl = true;
            }
        }
        return hashSet;
    }

    protected boolean containsAtomicRoles(DLClause dLClause, Set<AtomicRole> set) {
        DLPredicate dLPredicate;
        int n;
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            dLPredicate = dLClause.getBodyAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set.contains(dLPredicate)) continue;
            return true;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            dLPredicate = dLClause.getHeadAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set.contains(dLPredicate)) continue;
            return true;
        }
        return false;
    }

    protected boolean addAtomicRoles(DLClause dLClause, Set<AtomicRole> set) {
        DLPredicate dLPredicate;
        int n;
        boolean bl = false;
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            dLPredicate = dLClause.getBodyAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set.add((AtomicRole)dLPredicate)) continue;
            bl = true;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            dLPredicate = dLClause.getHeadAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set.add((AtomicRole)dLPredicate)) continue;
            bl = true;
        }
        return bl;
    }

    protected int getUsedRoleTypes(DLClause dLClause, Set<AtomicRole> set) {
        DLPredicate dLPredicate;
        int n;
        int n2 = 0;
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            dLPredicate = dLClause.getBodyAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole)) continue;
            if (n2 == 0) {
                n2 = set.contains(dLPredicate) ? 1 : 2;
                continue;
            }
            if (!(n2 == 1 ? !set.contains(dLPredicate) : set.contains(dLPredicate))) continue;
            return 3;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            dLPredicate = dLClause.getHeadAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole)) continue;
            if (n2 == 0) {
                n2 = set.contains(dLPredicate) ? 1 : 2;
                continue;
            }
            if (!(n2 == 1 ? !set.contains(dLPredicate) : set.contains(dLPredicate))) continue;
            return 3;
        }
        return n2;
    }

    protected boolean isTreeDLClause(DLClause dLClause, Set<AtomicRole> set, Set<AtomicConcept> set2) {
        Object object2;
        int n;
        if (dLClause.getHeadLength() == 0 && dLClause.getBodyLength() == 0) {
            return true;
        }
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            object2 = dLClause.getBodyAtom(n);
            ((Atom)object2).getVariables(hashSet);
            DLPredicate object3 = ((Atom)object2).getDLPredicate();
            if (object3 instanceof AtomicRole || object3 instanceof AtomicConcept || object3 instanceof InternalDatatype || object3.equals(NodeIDLessEqualThan.INSTANCE) || object3 instanceof NodeIDsAscendingOrEqual) continue;
            return false;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            AtLeastConcept atLeastConcept;
            object2 = dLClause.getHeadAtom(n);
            ((Atom)object2).getVariables(hashSet);
            DLPredicate dLPredicate = ((Atom)object2).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole || dLPredicate instanceof AtomicConcept || dLPredicate instanceof DataRange || dLPredicate instanceof ExistentialConcept || Equality.INSTANCE.equals(dLPredicate) || Inequality.INSTANCE.equals(dLPredicate) || dLPredicate instanceof AnnotatedEquality)) {
                return false;
            }
            if (!(dLPredicate instanceof AtLeastConcept) || !set.contains((atLeastConcept = (AtLeastConcept)dLPredicate).getOnRole())) continue;
            return false;
        }
        Variable variable = Variable.create("X");
        if (hashSet.contains(variable) && this.isTreeWithCenterVariable(dLClause, variable, set2)) {
            return true;
        }
        for (Variable variable2 : hashSet) {
            if (!this.isTreeWithCenterVariable(dLClause, variable2, set2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isTreeWithCenterVariable(DLClause dLClause, Variable variable, Set<AtomicConcept> set) {
        Atom atom;
        int n;
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            atom = dLClause.getBodyAtom(n);
            if (!(atom.getDLPredicate() instanceof AtomicRole) || atom.containsVariable(variable)) continue;
            return false;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            atom = dLClause.getHeadAtom(n);
            if (atom.getDLPredicate() instanceof AtomicRole && !atom.containsVariable(variable)) {
                return false;
            }
            if (!Equality.INSTANCE.equals(atom.getDLPredicate()) && !(atom.getDLPredicate() instanceof AnnotatedEquality)) continue;
            if (atom.getDLPredicate() instanceof AnnotatedEquality && !variable.equals(atom.getArgumentVariable(2))) {
                return false;
            }
            Variable variable2 = null;
            if (variable.equals(atom.getArgument(0)) ? (variable2 = atom.getArgumentVariable(1)) == null : variable.equals(atom.getArgument(1)) && (variable2 = atom.getArgumentVariable(0)) == null) {
                return false;
            }
            if (variable2 == null) continue;
            boolean bl = false;
            for (int i = 0; i < dLClause.getBodyLength(); ++i) {
                Atom atom2 = dLClause.getBodyAtom(i);
                if (atom2.getArity() != 1 || !atom2.getArgument(0).equals(variable2) || !set.contains(atom2.getDLPredicate())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected boolean isGraphDLClause(DLClause dLClause) {
        DLPredicate dLPredicate;
        int n;
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            dLPredicate = dLClause.getBodyAtom(n).getDLPredicate();
            if (dLPredicate instanceof AtomicRole || dLPredicate instanceof AtomicConcept) continue;
            return false;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            dLPredicate = dLClause.getHeadAtom(n).getDLPredicate();
            if (dLPredicate instanceof AtomicRole || dLPredicate instanceof AtomicConcept || Equality.INSTANCE.equals(dLPredicate)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Prefixes prefixes) {
        void var4_8;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Prefixes: [");
        stringBuffer.append(CRLF);
        for (Map.Entry<String, String> object : prefixes.getPrefixIRIsByPrefixName().entrySet()) {
            stringBuffer.append("  ");
            stringBuffer.append(object.getKey());
            stringBuffer.append(": = <");
            stringBuffer.append(object.getValue());
            stringBuffer.append('>');
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("Deterministic DL-clauses: [");
        stringBuffer.append(CRLF);
        int n = 0;
        for (DLClause dLClause : this.m_dlClauses) {
            if (dLClause.getHeadLength() > 1) continue;
            ++n;
            stringBuffer.append("  ");
            stringBuffer.append(dLClause.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("Disjunctive DL-clauses: [");
        stringBuffer.append(CRLF);
        boolean bl = false;
        int n2 = 0;
        for (DLClause dLClause : this.m_dlClauses) {
            if (dLClause.getHeadLength() <= 1) continue;
            ++var4_8;
            n2 += dLClause.getHeadLength();
            stringBuffer.append("  ");
            stringBuffer.append(dLClause.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("ABox: [");
        stringBuffer.append(CRLF);
        for (Atom atom : this.m_positiveFacts) {
            stringBuffer.append("  ");
            stringBuffer.append(atom.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        for (Atom atom : this.m_negativeFacts) {
            stringBuffer.append("  !");
            stringBuffer.append(atom.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("Statistics: [");
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of deterministic clauses: " + n);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of nondeterministic clauses: " + (int)var4_8);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of disjunctions: " + n2);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of positive facts: " + this.m_positiveFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of negative facts: " + this.m_negativeFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getStatistics() {
        return this.getStatistics(null, null, null);
    }

    protected String getStatistics(Integer n, Integer n2, Integer n3) {
        if (n == null || n2 == null || n3 == null) {
            n = 0;
            n2 = 0;
            n3 = 0;
            for (DLClause dLClause : this.m_dlClauses) {
                Integer n4;
                Integer n5;
                if (dLClause.getHeadLength() <= 1) {
                    n5 = n;
                    n4 = n = Integer.valueOf(n + 1);
                    continue;
                }
                n5 = n2;
                n4 = n2 = Integer.valueOf(n2 + 1);
                n3 = n3 + dLClause.getHeadLength();
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DL clauses statistics: [");
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of deterministic clauses: " + n);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of nondeterministic clauses: " + n2);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Overall number of disjunctions: " + n3);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of positive facts: " + this.m_positiveFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of negative facts: " + this.m_negativeFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Inverses: " + this.hasInverseRoles());
        stringBuffer.append(CRLF);
        stringBuffer.append("  At-Mosts: " + this.hasAtMostRestrictions());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Datatypes: " + this.hasDatatypes());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Nominals: " + this.hasNominals());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of atomic concepts: " + this.m_allAtomicConcepts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of object properties: " + this.m_allAtomicObjectRoles.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of data properties: " + this.m_allAtomicDataRoles.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of individuals: " + this.m_allIndividuals.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public static DLOntology load(InputStream inputStream) throws IOException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            return (DLOntology)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException();
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DLOntology load(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            DLOntology dLOntology = DLOntology.load(bufferedInputStream);
            return dLOntology;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndividualComparator
    implements Serializable,
    Comparator<Individual> {
        private static final long serialVersionUID = 2386841732225838685L;
        public static final Comparator<Individual> INSTANCE = new IndividualComparator();

        @Override
        public int compare(Individual individual, Individual individual2) {
            return individual.getIRI().compareTo(individual2.getIRI());
        }

        protected Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicRoleComparator
    implements Serializable,
    Comparator<AtomicRole> {
        private static final long serialVersionUID = 3483541702854959793L;
        public static final Comparator<AtomicRole> INSTANCE = new AtomicRoleComparator();

        @Override
        public int compare(AtomicRole atomicRole, AtomicRole atomicRole2) {
            return atomicRole.getIRI().compareTo(atomicRole2.getIRI());
        }

        protected Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicConceptComparator
    implements Serializable,
    Comparator<AtomicConcept> {
        private static final long serialVersionUID = 2386841732225838685L;
        public static final Comparator<AtomicConcept> INSTANCE = new AtomicConceptComparator();

        @Override
        public int compare(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
            return atomicConcept.getIRI().compareTo(atomicConcept2.getIRI());
        }

        protected Object readResolve() {
            return INSTANCE;
        }
    }
}

