/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.anyuri;

import dk.brics.automaton.Automaton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.anyuri.AnyURIValueSpaceSubset;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyURIDatatypeHandler
implements DatatypeHandler {
    protected static final String XSD_NS = Prefixes.s_semanticWebPrefixes.get("xsd");
    protected static final ValueSpaceSubset ANY_URI_ALL = new AnyURIValueSpaceSubset(AnyURIValueSpaceSubset.s_anyURI);
    protected static final ValueSpaceSubset EMPTY_SUBSET = new AnyURIValueSpaceSubset(AnyURIValueSpaceSubset.s_empty);
    protected static final Set<String> s_managedDatatypeURIs = Collections.singleton(XSD_NS + "anyURI");

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_managedDatatypeURIs;
    }

    @Override
    public Object parseLiteral(String string, String string2) throws MalformedLiteralException {
        assert (s_managedDatatypeURIs.contains(string2));
        if (!AnyURIValueSpaceSubset.s_anyURI.run(string)) {
            throw new MalformedLiteralException(string, string2);
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedLiteralException(string, string2);
        }
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string = datatypeRestriction.getFacetURI(i);
            Constant constant = datatypeRestriction.getFacetValue(i);
            Object object = constant.getDataValue();
            if ((XSD_NS + "minLength").equals(string) || (XSD_NS + "maxLength").equals(string) || (XSD_NS + "length").equals(string)) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    if (n >= 0 && n != Integer.MAX_VALUE) continue;
                    throw new UnsupportedFacetException("The datatype restriction " + this.toString() + " cannot be handled. The facet with URI '" + string + "' does not support integer " + n + " as value. " + (n < 0 ? "The value should not be negative. " : "The value is outside of the supported integer range, i.e., it is larger than 2147483647"));
                }
                throw new UnsupportedFacetException("The datatype xsd:anyURI accepts only integers as facet values for the facet with URI '" + string + "', but in the ontology we have a datatype restriction " + this.toString() + ". The value '" + constant.toString() + "' does not seem to be an integer.");
            }
            if ((XSD_NS + "pattern").equals(string)) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    if (AnyURIValueSpaceSubset.isValidPattern(string2)) continue;
                    throw new UnsupportedFacetException("String '" + string2 + "' in the datatype restriction " + this.toString() + " is not a valid regular expression.");
                }
                throw new UnsupportedFacetException("The facet with URI '" + string + "' supports only strings as values, but '" + constant.toString() + "' in the restriction " + this.toString() + " does not seem to be a string. It is an instance of the class " + constant.getClass() + ". ");
            }
            throw new UnsupportedFacetException("Facet with URI '" + string + "' is not supported on xsd:anyURI; only xsd:minLength, xsd:maxLength, xsd:length, and xsd:pattern are supported, but the ontology contains the restriction: " + this.toString());
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return ANY_URI_ALL;
        }
        Automaton automaton = this.getAutomatonFor(AnyURIValueSpaceSubset.s_anyURI, datatypeRestriction);
        if (automaton == null) {
            return EMPTY_SUBSET;
        }
        return new AnyURIValueSpaceSubset(automaton);
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        if (valueSpaceSubset == EMPTY_SUBSET || datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return valueSpaceSubset;
        }
        Automaton automaton = this.getAutomatonFor(((AnyURIValueSpaceSubset)valueSpaceSubset).m_automaton, datatypeRestriction);
        if (automaton == null) {
            return EMPTY_SUBSET;
        }
        return new AnyURIValueSpaceSubset(automaton);
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        if (valueSpaceSubset == EMPTY_SUBSET || datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return EMPTY_SUBSET;
        }
        Automaton automaton = this.getAutomatonFor(AnyURIValueSpaceSubset.s_anyURI, datatypeRestriction);
        if (automaton == null) {
            return valueSpaceSubset;
        }
        Automaton automaton2 = ((AnyURIValueSpaceSubset)valueSpaceSubset).m_automaton.minus(automaton);
        if (automaton2.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new AnyURIValueSpaceSubset(automaton2);
    }

    protected Automaton getAutomatonFor(Automaton automaton, DatatypeRestriction datatypeRestriction) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string = datatypeRestriction.getFacetURI(i);
            Object object = datatypeRestriction.getFacetValue(i).getDataValue();
            if ((XSD_NS + "minLength").equals(string)) {
                n = Math.max(n, (Integer)object);
                continue;
            }
            if ((XSD_NS + "maxLength").equals(string)) {
                n2 = Math.min(n2, (Integer)object);
                continue;
            }
            if ((XSD_NS + "length").equals(string)) {
                n = Math.max(n, (Integer)object);
                n2 = Math.min(n2, (Integer)object);
                continue;
            }
            if ((XSD_NS + "pattern").equals(string)) {
                String string2 = (String)object;
                Automaton automaton2 = AnyURIValueSpaceSubset.getPatternAutomaton(string2);
                automaton = automaton.intersection(automaton2);
                continue;
            }
            throw new UnsupportedFacetException("Facet with URI '" + string + "' not supported on xsd:anyURI.");
        }
        if (n > n2) {
            return null;
        }
        if (n != 0 || n2 != Integer.MAX_VALUE) {
            automaton = automaton.intersection(AnyURIValueSpaceSubset.toAutomaton(n, n2));
        }
        if (automaton.isEmpty()) {
            return null;
        }
        return automaton;
    }

    @Override
    public boolean isSubsetOf(String string, String string2) {
        assert (s_managedDatatypeURIs.contains(string));
        assert (s_managedDatatypeURIs.contains(string2));
        return true;
    }

    @Override
    public boolean isDisjointWith(String string, String string2) {
        assert (s_managedDatatypeURIs.contains(string));
        assert (s_managedDatatypeURIs.contains(string2));
        return false;
    }
}

