#! /usr/bin/perl
# perl chrstrloc.pl file.to.be.reformatted
# remember column numbering start from 0
# perl ./shrimpENSEMBL2genominator.mm.pl xxx.out
#hs >@HWI-EAS269B:1:1:1614:601      gi|224589800|ref|NC_000001.10| Homo sapiens chromosome 1, GRCh37 primary reference assembly      -       31208008        31208025        5       22      32      180     18	
#mm >@HWI-EAS225_0011:1:1:2227:10951#0/1    gi|149354224|ref|NC_000071.5|NC_000071 Mus musculus chromosome 5, reference assembly (C57BL/6J) -       107081667       107081702       1       36      36      360     36
my ($mappingFileName) = @ARGV;

open INFILE_MAP, "<$mappingFileName" or die $!;
open OUTFILE_MAP, ">$mappingFileName.bed" or die $!;
print OUTFILE_MAP "track name=";
print OUTFILE_MAP "\"MACS peaks for s1_vs_s5_mfold_5_40\"\n";
  while (my $line = <INFILE_MAP>){
          if($line =~ /^>/){
             my @myarr = split('\t', $line);
             my @tmparr = split('\|', $myarr[1]);
             my @chr1 = split(',', $tmparr[4]);
             my @chr2 = split('chromosome ', $chr1[0]);
             $chr = "chr" . $chr2[1];
             $strand = $myarr[2];
             if ($strand =~ /\+/) {
                  $strand = "1"; #
             } 
             elsif ($strand =~ /-/) {
                  $strand = "-1"; #
             }
             my $string = join("\t", $chr, $strand, $myarr[3], $myarr[4]);
             print OUTFILE_MAP $string;
             print OUTFILE_MAP "\n";
          }
  }  
close INFILE_MAP;
close OUTFILE_MAP;
