### R code from vignette source 'networkBMA.Rnw'

###################################################
### code chunk number 1: vignette.data
###################################################
library(networkBMA)
data(vignette)

dim(timeSeries)
dim(reg.prob)
dim(brem.data)
reg.known


###################################################
### code chunk number 2: networkBMA
###################################################
edges <- networkBMA(data = timeSeries[,-(1:2)], 
                    nTimePoints = length(unique(timeSeries$time)), 
                    prior.prob = reg.prob, known = reg.known, 
                    nvar = 50, ordering = "bic1+prior")
edges[1:9,]


###################################################
### code chunk number 3: contingency.tables
###################################################
ctables <- contabs.netwBMA( edges, referencePairs, reg.known, 
                              thresh=c(.5,.75,.9))
ctables


###################################################
### code chunk number 4: scores
###################################################
scores( ctables, what = c("FDR", "precision", "recall"))


###################################################
### code chunk number 5: rocANDprc
###################################################
roc( contabs.netwBMA( edges, referencePairs), plotit = TRUE)
title("ROC")

prc( contabs.netwBMA( edges, referencePairs), plotit = TRUE)
title("Precision-Recall")


###################################################
### code chunk number 6: iterateBMAlm
###################################################
gene <- "YNL037C"
variables <- which(rownames(brem.data) != gene)

control <- iBMAcontrolLM(OR = 50, nbest = 20, thresProbne0 = 5)

iBMAmodel.YNL037C <- iterateBMAlm( x = t(brem.data[variables,]),
                  y = unlist(brem.data[gene,]), control = control)


###################################################
### code chunk number 7: probne0
###################################################
iBMAmodel.YNL037C$probne0[iBMAmodel.YNL037C$probne0 > 0]


