### R code from vignette source 'jmosaics.Rnw'

###################################################
### code chunk number 1: preliminaries
###################################################
options(prompt = "R> ")


###################################################
### code chunk number 2: jmosaics-prelim
###################################################
library("jmosaics")


###################################################
### code chunk number 3: toy example (eval = FALSE)
###################################################
## bin1_toy=readBins(type = c("chip","input"),
## fileName = c(system.file(file.path("extdata","h3k27me3_chip_chr10.txt"),
## package="jmosaics"),
## system.file(file.path("extdata","h3k27me3_input_chr10.txt"),
## package="jmosaics")))
## bin2_toy <- readBins(type = c("chip","input"),
## fileName = c(system.file(file.path("extdata","h3k4me1_chip_chr10.txt"),
## package="jmosaics"),
## system.file(file.path("extdata","h3k4me1_input_chr10.txt"),
## package="jmosaics")))
## origin_bin_toy=list(bin1_toy,bin2_toy)


###################################################
### code chunk number 4: loadTextData (eval = FALSE)
###################################################
## bin1_toy <- readBins(type = c("chip", "input"), 
##     fileName = c("h3k27me3_chip_chr10.txt",
##     "h3k27me3_input_chr10.txt"))
## bin2_toy <- readBins(type = c("chip", "input"), 
##     fileName = c("h3k4me1_chip_chr10.txt",
##     "h3k4me1_input_chr10.txt"))
## origin_bin_toy <- list(bin1_toy,bin2)


###################################################
### code chunk number 5: load data
###################################################
data("jmosaics_example_data")


###################################################
### code chunk number 6: readBinsMultiple
###################################################
bin<- readBinsMultiple(origin_bin)
str(bin)


###################################################
### code chunk number 7: Fit by mosaics
###################################################
fit1 <- mosaicsFit(bin[[1]], analysisType = "IO", bgEst="automatic")
fit2 <- mosaicsFit(bin[[2]], analysisType = "IO", bgEst="automatic")


###################################################
### code chunk number 8: Create an input list for jmosaics
###################################################
fit <- list(fit1, fit2) 


###################################################
### code chunk number 9: jmosaicsPattern
###################################################
result<-jmosaicsPattern(fit, region_length=1, FDR=0.05, thres=c(10,10), 
type=c('B', 'E', 'Pattern'), patternInfo='FALSE')


###################################################
### code chunk number 10: see all result
###################################################



###################################################
### code chunk number 11: see pattern result
###################################################
id=which(result$Pattern[,2]==5018000)
result$Pattern[id:(id+2),]


###################################################
### code chunk number 12: see E_layer result
###################################################
id=which(result$E_LAYER[[1]][,2]==5018000)
result$E_LAYER[[1]][id:(id+2),]

 id=which(result$E_LAYER[[2]][,2]==5018000)
result$E_LAYER[[2]][id:(id+2),]


###################################################
### code chunk number 13: see B_layer result
###################################################
id=which(result$B_LAYER[,2]==5018000)
result$B_LAYER[id:(id+2),]


