### R code from vignette source 'iontree_doc.Rnw'

###################################################
### code chunk number 1: iontree_doc.Rnw:26-34
###################################################
rm(list=ls())
library(iontree)
library(iontreeData)
data(MS2RAW)
data(MS3RAW)
ls()
length(MS2RAW)
attributes(MS2RAW[[1]])


###################################################
### code chunk number 2: iontree_doc.Rnw:37-39
###################################################
mzxml=system.file("mzxml/DIMS1.mzXML", package="iontreeData")
getMetaInfo(mzxml)


###################################################
### code chunk number 3: iontree_doc.Rnw:47-61
###################################################
mz=554.5
mzDelta=0.5
mzRange=c(mz-mzDelta, mz+mzDelta)
rtRange=c(0,600)

idx=hasMS2(MS2RAW, mzRange, rtRange)

idx.ms2=idx[1]
ms2=MS2RAW[[idx.ms2]]
ms3=MS3RAW[[idx.ms2]]

tree1=buildIonTree(mzRange, rtRange=c(0, 600), ms2, ms3)
tree1
plot(tree1)


###################################################
### code chunk number 4: iontree_doc.Rnw:72-85
###################################################
dbname=system.file("db/mzDB.db", package = "iontreeData")

db=dbConnect(dbDriver("SQLite"), dbname)
sql="SELECT mz, ms2, ms3 FROM mz WHERE mz=596"
q1=dbSendQuery(db, sql) 
rs=fetch(q1, n=-1) 
dim(rs)
t1=rs2iontree(rs)

dbClearResult(q1)
dbDisconnect(db)

plot(t1[[1]])


###################################################
### code chunk number 5: iontree_doc.Rnw:92-97
###################################################
query=t1[[1]]@MS3[[2]]$sp3
premz=t1[[1]]@MS3[[2]]$premz
premz

searchMS2(query, premz, dbname, scoreFun="d")


###################################################
### code chunk number 6: iontree_doc.Rnw:100-101
###################################################
searchMS2(query, premz, dbname, scoreFun="t")


###################################################
### code chunk number 7: iontree_doc.Rnw:104-105
###################################################
searchMS2(query, premz, dbname, scoreFun="c")


###################################################
### code chunk number 8: iontree_doc.Rnw:114-130
###################################################
dbname=system.file("db/mzDB.db", package = "iontreeData")
db=dbConnect(dbDriver("SQLite"), dbname)
sql="SELECT mz, ms2, ms3 FROM mz WHERE mz=244"
q1=dbSendQuery(db, sql) 
rs=fetch(q1, n=-1) 
dim(rs)
t1=rs2iontree(rs)
dbClearResult(q1)
dbDisconnect(db)

x=t1[[1]]@MS2
dim(x)
y=topIons(query[,1], query[,2], top=nrow(x))
x
y
round(cor(x[,2], y[,2]),2)


###################################################
### code chunk number 9: iontree_doc.Rnw:145-146
###################################################
sessionInfo()


