### R code from vignette source 'flowFlowJo.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: flowFlowJo.Rnw:118-124
###################################################
library(flowCore);
library(XML);
library(flowFlowJo);
demoLocation <- system.file("extdata", "DemoWorkspace.wsp", package="flowFlowJo");
actualFCSLoc <- system.file("extdata/fcsFiles", package="flowFlowJo");
testList <- readFlowJoList(demoLocation, altFileLocation=actualFCSLoc);


###################################################
### code chunk number 2: flowFlowJo.Rnw:157-160
###################################################
z <- getFlowJoGates(testList, fileNamePatterns=c("C02"));
print(summary(z));
print(summary(z$filter));


###################################################
### code chunk number 3: flowFlowJo.Rnw:261-263
###################################################
getFlowJoSummary(testList, gatesByFile=FALSE, removeParentalNames=TRUE); 
getFlowJoSummary(testList, removeParentalNames=TRUE);


###################################################
### code chunk number 4: flowFlowJo.Rnw:279-280
###################################################
summaryStatsObj <- collectSummaryFlowInfo(testList);


###################################################
### code chunk number 5: flowFlowJo.Rnw:338-344
###################################################
expDescFrame <- data.frame(Drug=c(rep("Amospho", 3), 
                                  rep("Gleevec", 3), 
                                  rep("Chloro", 3)), 
   Conc=rep(c(0.001, 0.0001, 0.00001), 3), 
   FCSFilename=dir(actualFCSLoc, full.names=TRUE), 
   FlowJoWorkspace=rep(demoLocation, length(dir(actualFCSLoc)))); 


###################################################
### code chunk number 6: flowFlowJo.Rnw:356-358
###################################################
flowReport <- createFlowReport(summaryStatsObj,  factorsFrame=expDescFrame);
print(head(flowReport));


