### R code from vignette source 'chimera.Rnw'

###################################################
### code chunk number 1: chimera.Rnw:66-83
###################################################
#creating a fusion report from output of fusionMap
library(chimera)
tmp <- importFusionData("fusionmap", paste(find.package(package="chimera"),
"/examples/mcf7.FMFusionReport", sep=""), org="hs")
#extracting the fSet object for one of the fusions
myset <- tmp[[13]]
#constructing the fused sequence(s)
trs <- chimeraSeqs(myset, type="transcripts")
#adding the sequences to the fSet object
myset <- addRNA(myset , trs)
#extracting sequences from an fSet object
tmp.seq <- fusionRNA(myset)
#adding reads mapped on the fusion generated using tophatRun function
myset <- addGA(myset, paste(path.package(package="chimera"),
"/examples/mcf7_trs_accepted_hits.bam",sep=""))
#extracting the GAlignments from an fSet object
ga <- fusionGA(myset)


###################################################
### code chunk number 2: chimera.Rnw:90-92
###################################################
supporting.reads <- supportingReads(tmp)
supporting.reads


###################################################
### code chunk number 3: chimera.Rnw:96-98
###################################################
fusion.names <- fusionName(tmp)
fusion.names


###################################################
### code chunk number 4: chimera.Rnw:102-104
###################################################
myset <- tmp[[13]]
trs <- chimeraSeqs(myset, type="transcripts")


###################################################
### code chunk number 5: chimera.Rnw:112-120
###################################################
#the DNAStringSet of transcript fusions sequences is saved as fast file
#write.XStringSet(trs, paste("SULF2_ARFGEF2.fa",sep=""), format="fasta")
   if(require(Rsubread)){
    	subreadRun(ebwt=paste(find.package(package="chimera"),"/examples/SULF2_ARFGEF2.fa",sep=""), 
 	    input1=paste(find.package(package="chimera"),"/examples/mcf7_sample_1.fq",sep=""), 
 	    input2=paste(find.package(package="chimera"),"/examples/mcf7_sample_2.fq",sep=""), 
 	    outfile.prefix="accepted_hits", alignment="se", cores=1)
   }


###################################################
### code chunk number 6: chimera.Rnw:125-128
###################################################
tmp1 <- filterList(tmp, type="fusion.names", fusion.names[c(1,3,7)])
tmp2 <- filterList(tmp, type="supporting.reads", 2)
#tmp3 <- filterList(tmp, type="intronic")


###################################################
### code chunk number 7: chimera.Rnw:134-156
###################################################
tmp <- importFusionData("fusionmap", paste(find.package(package="chimera"),
"/examples/mcf7.FMFusionReport", sep=""), org="hs")
fusion.names <- fusionName(tmp)
myset <- tmp[[13]]
trs <- chimeraSeqs(myset, type="transcripts")
myset <- addRNA(myset , trs)
tmp.seq <- fusionRNA(myset)
myset <- addGA(myset, paste(path.package(package="chimera"),
"/examples/mcf7_trs_accepted_hits.bam",sep=""))
	
pdf("coverage1.pdf")
plotCoverage(myset, plot.type="exons", col.box1="red", 
col.box2="green", ybox.lim=c(-4,-1))
dev.off()
pdf("coverage2.pdf")
plotCoverage(myset, plot.type="junctions", col.box1="red", 
col.box2="yellow", ybox.lim=c(-4,-1))
dev.off()
pdf("coverage3.pdf")
plotCoverage(myset, junction.spanning=100, fusion.only=TRUE, col.box1="red", 
col.box2="yellow", ybox.lim=c(-4,-1))
dev.off()


###################################################
### code chunk number 8: chimera.Rnw:185-188
###################################################
mypeps <- fusionPeptides(fset=myset, which.isoform=1, 
donor.up=200, acceptor.down=200)
mypeps


###################################################
### code chunk number 9: chimera.Rnw:233-234
###################################################
dir(paste(find.package(package="chimera"),"/examples/",sep=""))


###################################################
### code chunk number 10: chimera.Rnw:246-247
###################################################
sessionInfo()


