### R code from vignette source 'bsseq.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=70)


###################################################
### code chunk number 2: load
###################################################
library(bsseq)


###################################################
### code chunk number 3: citation
###################################################
print(citation("bsseq"), style = "latex")


###################################################
### code chunk number 4: BSchr22
###################################################
BS.chr22


###################################################
### code chunk number 5: ov-granges
###################################################
head(granges(BS.chr22), n = 4)


###################################################
### code chunk number 6: ov-getCoverage
###################################################
head(getCoverage(BS.chr22, type = "M"), n = 4)
head(getCoverage(BS.chr22), n = 4)


###################################################
### code chunk number 7: using-examples
###################################################
head(start(BS.chr22), n = 4)
head(seqnames(BS.chr22), n = 4)
sampleNames(BS.chr22)
pData(BS.chr22)
dim(BS.chr22)
BS.chr22[1:6,1]
subsetByOverlaps(BS.chr22, 
                 GRanges(seqnames = "chr22", 
                         ranges = IRanges(start = 1, end = 2*10^7)))


###################################################
### code chunk number 8: data-bsseq
###################################################
M <- matrix(0:8, 3, 3)
Cov <- matrix(1:9, 3, 3)
BStmp <- BSseq(chr = c("chr1", "chrX", "chr1"), pos = 1:3, 
               M = M, Cov = Cov, sampleNames = c("A1","A2", "B"))


###################################################
### code chunk number 9: data-order
###################################################
granges(BStmp)
BStmp <- orderBSseq(BStmp, seqOrder = c("chr1", "chrX"))
granges(BStmp)


###################################################
### code chunk number 10: data-chrSelect
###################################################
chrSelectBSseq(BStmp, seqnames = "chr1", order = TRUE)


###################################################
### code chunk number 11: data-combine
###################################################
BStmp2 <- combine(BStmp, BS.chr22[1:3,])
granges(BStmp2)
getCoverage(BStmp2)


###################################################
### code chunk number 12: data-collapse
###################################################
collapseBSseq(BStmp, columns = c("A", "A", "B"))


###################################################
### code chunk number 13: getCoverage1
###################################################
head(getCoverage(BS.chr22, type = "Cov"), n = 4)
head(getCoverage(BS.chr22, type = "M"), n = 4)


###################################################
### code chunk number 14: regions
###################################################
regions <- GRanges(seqnames = c("chr22", "chr22"), 
                   ranges = IRanges(start = 1.5 * 10^7 + c(0,200000), 
                                    width = 1000))
getCoverage(BS.chr22, regions = regions, what = "perRegionTotal")


###################################################
### code chunk number 15: getCoverage2
###################################################
getCoverage(BS.chr22, regions = regions, what = "perBase")


###################################################
### code chunk number 16: getMeth
###################################################
getMeth(BS.chr22, regions, type = "raw")
getMeth(BS.chr22, regions[2], type = "raw", what = "perBase")


###################################################
### code chunk number 17: locateScript
###################################################
system.file("scripts", "get_BS.chr22.R", package = "bsseq")


###################################################
### code chunk number 18: BSmooth
###################################################
BS.chr22.1 <- BSmooth(BS.chr22[,"r1"], verbose = TRUE)
BS.chr22.1


###################################################
### code chunk number 19: sessionInfo
###################################################
toLatex(sessionInfo())


