### R code from vignette source 'attract.Rnw'

###################################################
### code chunk number 1: loadlib
###################################################
library(attract)
data(exprs.dat) 
data(samp.info)


###################################################
### code chunk number 2: makeESet
###################################################
loring.eset <- new("ExpressionSet")
loring.eset@assayData <- new.env()
assign("exprs", exprs.dat, loring.eset@assayData)
p.eset <- new("AnnotatedDataFrame", data=samp.info)
loring.eset@phenoData <- p.eset


###################################################
### code chunk number 3: findAttractors
###################################################
attractor.states <- findAttractors(loring.eset, "celltype", nperm=10, annotation="illuminaHumanv1.db")


###################################################
### code chunk number 4: showSlots
###################################################
class(attractor.states) 
slotNames(attractor.states) 


###################################################
### code chunk number 5: removeFlats
###################################################
remove.these.genes <- removeFlatGenes(loring.eset, "celltype", contrasts=NULL, limma.cutoff=0.05)


###################################################
### code chunk number 6: findSynE
###################################################
mapk.syn <- findSynexprs("04010", attractor.states, remove.these.genes)


###################################################
### code chunk number 7: showSynSlots
###################################################
class(mapk.syn)
slotNames(mapk.syn)


###################################################
### code chunk number 8: howMany
###################################################
length(mapk.syn@groups) 
sapply(mapk.syn@groups, length) 


###################################################
### code chunk number 9: findMultiSynE
###################################################
top5.syn <- findSynexprs(attractor.states@rankedPathways[1:5,1], attractor.states, removeGenes=remove.these.genes)


###################################################
### code chunk number 10: demoEnv
###################################################
ls(top5.syn) 


###################################################
### code chunk number 11: demoClass
###################################################
class(get(ls(top5.syn)[1], top5.syn))


###################################################
### code chunk number 12: plotSyn
###################################################
par(mfrow=c(2,2)) 
pretty.col <- rainbow(3) 
for( i in 1:3 ){
	plotsynexprs(mapk.syn, tickMarks=c(6, 28, 47, 60), tickLabels=c("ESC", "PRO", "NSC", "TER"), vertLines=c(12.5, 43.5, 51.5), index=i, 
			main=paste("Synexpression Group ", i, sep=""), col=pretty.col[i])
 }


###################################################
### code chunk number 13: findCorrP
###################################################
mapk.cor <- findCorrPartners(mapk.syn, loring.eset, remove.these.genes)


###################################################
### code chunk number 14: lookatCorr
###################################################
sapply(mapk.cor@groups, length)


###################################################
### code chunk number 15: funcE
###################################################
mapk.func <- calcFuncSynexprs(mapk.syn, attractor.states, "CC", annotation="illuminaHumanv1.db") 


###################################################
### code chunk number 16: SessionInfo
###################################################
sessionInfo()


