/*
 * Decompiled with CFR 0.152.
 */
package reder.io;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import reder.application.MainFrame;
import reder.network.EdgeBank;
import reder.network.LegendBank;
import reder.network.NodeBank;
import reder.plugins.Plugins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadData {
    protected static ArrayList<NodeBank> NodeList;
    protected static ArrayList<EdgeBank> EdgeList;
    private static ArrayList<LegendBank> LegendList;
    protected static ArrayList<String> keyNodeArray;
    private static Hashtable keyNodeHash;
    private NodeBank nodeAccount;
    private EdgeBank edgeAccount;
    private String openAddress;
    private String taskProgress;
    private float centroX;
    private float centroY;
    private Color backgroundColor;
    private double zoomInOut;
    private double edgeTarget;
    private double outedgeTarget;
    private double nodeSpeedLimit;
    private double repulserad;
    private double stiffness;
    private double repelFactor;
    private double outsideRepelFactor;
    private double perimeterEffect;
    private boolean isResource;

    public LoadData() {
        NodeList = new ArrayList();
        EdgeList = new ArrayList();
        LegendList = new ArrayList();
        keyNodeArray = new ArrayList();
        keyNodeHash = new Hashtable();
        this.nodeAccount = null;
        this.openAddress = null;
        this.taskProgress = "running";
        this.backgroundColor = new Color(255, 255, 255);
        this.zoomInOut = 1.0;
        this.edgeTarget = 100.0;
        this.repulserad = 100.0;
        this.outedgeTarget = 100.0;
        this.stiffness = 100.0;
        this.repelFactor = 100.0;
        this.perimeterEffect = 100.0;
        this.outsideRepelFactor = 0.0;
        this.nodeSpeedLimit = 100.0;
        this.isResource = false;
    }

    public ArrayList<NodeBank> getNodeBank() {
        return NodeList;
    }

    public ArrayList<EdgeBank> getEdgeBank() {
        return EdgeList;
    }

    public ArrayList<LegendBank> getLegendBank() {
        return LegendList;
    }

    public Hashtable getKeyNodeHash() {
        return keyNodeHash;
    }

    public ArrayList<String> getKeyNodeArray() {
        return keyNodeArray;
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public double getZoomInOut() {
        return this.zoomInOut;
    }

    public double getEdgeTarget() {
        return Math.max(this.edgeTarget, 1.0);
    }

    public double getOutedgeTarget() {
        return Math.max(this.outedgeTarget, 1.0);
    }

    public double getStiffness() {
        return Math.max(this.stiffness, 1.0);
    }

    public double getRepelFactor() {
        return Math.max(this.repelFactor, 1.0);
    }

    public double getOutsideRepelFactor() {
        return Math.max(this.outsideRepelFactor, 1.0);
    }

    public double getNodeSpeedLimit() {
        return Math.max(this.nodeSpeedLimit, 1.0);
    }

    public double getPerimeterEffect() {
        return Math.max(this.perimeterEffect, 1.0);
    }

    public double getRepulseRadius() {
        return Math.max(this.repulserad, 1.0);
    }

    public void inputAndGo(String openAddress, String fileType, float centroX, float centroY) {
        try {
            this.openAddress = openAddress;
            this.centroX = centroX;
            this.centroY = centroY;
            NodeList.clear();
            NodeList.clear();
            keyNodeHash.clear();
            keyNodeArray.clear();
            if (fileType.equals("default")) {
                String[] fileTest = openAddress.split("\\.");
                String end = fileTest[fileTest.length - 1];
                if (end.equals("dynn")) {
                    this.loadBasicNetwork();
                } else if (end.equals("dyn")) {
                    this.isResource = false;
                    this.loadDefault();
                }
            }
            if (fileType.equals("basicNetwork")) {
                this.loadBasicNetwork();
            }
            if (fileType.equals("edges")) {
                this.loadEdges();
            }
            if (fileType.equals("random")) {
                this.loadRandomGraph();
            }
            if (fileType.equals("xgmml")) {
                this.isResource = false;
                this.loadXgmml();
            }
            if (fileType.equals("resource")) {
                this.isResource = true;
                this.loadXgmml();
            }
            if (fileType.equals("nodes")) {
                this.loadNodes();
            }
            if (fileType.equals("importPlugins")) {
                this.customXmlPlugins();
            }
            if (fileType.equals("customPlugins")) {
                this.defaultXmlPlugins();
                this.customXmlPlugins();
            }
            if (fileType.equals("defaultPlugins")) {
                this.defaultXmlPlugins();
            }
        }
        catch (IOException ignore) {
            this.taskProgress = "halt";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDefault() throws IOException {
        File tempFile = File.createTempFile("datadyn", ".tmp");
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int n;
            fis = new FileInputStream(this.openAddress);
            fos = new FileOutputStream(tempFile.getPath());
            ZipInputStream zis = new ZipInputStream(fis);
            zis.getNextEntry();
            int BUFSIZ = 4096;
            byte[] inbuf = new byte[4096];
            while ((n = zis.read(inbuf, 0, 4096)) != -1) {
                fos.write(inbuf, 0, n);
            }
            zis.close();
            fis = null;
            fos.close();
            fos = null;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
        this.openAddress = tempFile.getPath();
        this.loadXgmml();
        tempFile.deleteOnExit();
    }

    private void loadBasicNetwork() throws FileNotFoundException, IOException {
        ArrayList<String> links = new ArrayList<String>();
        ArrayList<String> nodes = new ArrayList<String>();
        String strLine = "";
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        strLine = br.readLine();
        Pattern iniPattern = Pattern.compile("^(node_id)[\\s;]+(alias)[\\s;]+(shape)[\\s;]+(size)[\\s;]+(color)[\\s;]+(x)[\\s;]+(y)");
        Pattern endPattern = Pattern.compile("^(node_a)[\\s;]+(node_b)[\\s;]+(weight)");
        Matcher matcher = iniPattern.matcher(strLine);
        if (matcher.find()) {
            while (strLine != null && !(matcher = endPattern.matcher(strLine = br.readLine())).find()) {
                nodes.add(strLine);
            }
            if (nodes.size() > 0) {
                this.loadBasicNodes(nodes);
            }
        }
        if ((matcher = endPattern.matcher(strLine)).find()) {
            while (strLine != null && (strLine = br.readLine()) != null) {
                links.add(strLine);
            }
            if (links.size() > 0) {
                this.loadBasicLinks(links);
            }
        }
        br.close();
        in.close();
    }

    private void loadEdges() throws FileNotFoundException, IOException {
        ArrayList<String> links = new ArrayList<String>();
        String strLine = "";
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        strLine = br.readLine();
        while (strLine != null) {
            strLine = br.readLine();
            links.add(strLine);
        }
        this.loadBanksViaLinks(links);
        br.close();
        in.close();
    }

    private void loadNodes() throws FileNotFoundException, IOException {
        ArrayList<String> nodes = new ArrayList<String>();
        String strLine = "";
        FileReader in = new FileReader(this.openAddress);
        BufferedReader br = new BufferedReader(in);
        strLine = br.readLine();
        while (strLine != null) {
            strLine = br.readLine();
            nodes.add(strLine);
        }
        this.loadBanksViaNodes(nodes);
        br.close();
        in.close();
    }

    private void loadXgmml() {
        SAXBuilder parser = new SAXBuilder();
        Namespace ns = Namespace.getNamespace("http://www.cs.rpi.edu/XGMML");
        try {
            Document doc;
            if (this.isResource) {
                InputStream in = this.getClass().getResourceAsStream(this.openAddress);
                doc = parser.build(in);
            } else {
                doc = parser.build(this.openAddress);
            }
            Element root = doc.getRootElement();
            List graphAtt = root.getChildren("att", ns);
            float dX = this.centroX;
            float dY = this.centroY;
            for (int i = 0; i < graphAtt.size(); ++i) {
                Element att = (Element)graphAtt.get(i);
                String name = att.getAttributeValue("name");
                String value = att.getAttributeValue("value");
                if (name.equals("backgroundColor")) {
                    try {
                        this.backgroundColor = Color.decode(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("GRAPH_VIEW_ZOOM")) {
                    try {
                        this.zoomInOut = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("GRAPH_VIEW_CENTER_X")) {
                    try {
                        dX = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("GRAPH_VIEW_CENTER_Y")) {
                    try {
                        dY = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("RELAX_EDGETARGET")) {
                    try {
                        this.edgeTarget = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("RELAX_OUTEDGETARGET")) {
                    try {
                        this.outedgeTarget = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("RELAX_STIFFNESS")) {
                    try {
                        this.stiffness = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("RELAX_REPEL")) {
                    try {
                        this.repelFactor = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("RELAX_REPULSERAD")) {
                    try {
                        this.repulserad = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("RELAX_OUTREPEL")) {
                    try {
                        this.outsideRepelFactor = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (name.equals("RELAX_SPEED")) {
                    try {
                        this.nodeSpeedLimit = Float.parseFloat(value);
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (!name.equals("RELAX_PERIMETEREFFECT")) continue;
                try {
                    this.perimeterEffect = Float.parseFloat(value);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            dX -= this.centroX;
            dY -= this.centroY;
            Vector<Float> sizevec = new Vector<Float>();
            Vector<Color> colvec = new Vector<Color>();
            Vector<String> shapevec = new Vector<String>();
            Vector<String> labvec = new Vector<String>();
            float size = 0.0f;
            Color col = null;
            float interspace = 0.0f;
            int ftsize = 0;
            String labx = null;
            float labxdist = 0.0f;
            String position = null;
            float dxborder = 0.0f;
            float dyborder = 0.0f;
            boolean isVertical = false;
            float legbend = 0.0f;
            float edgelen = 50.0f;
            List legs = root.getChildren("legend", ns);
            for (int i = 0; i < legs.size(); ++i) {
                Object value;
                String label;
                Element member;
                Element leg = (Element)legs.get(i);
                String legtype = leg.getAttributeValue("legtype");
                List legAtt = leg.getChildren("att", ns);
                for (int j = 0; j < legAtt.size(); ++j) {
                    Element att = (Element)legAtt.get(j);
                    String name = att.getAttributeValue("name");
                    String value2 = att.getAttributeValue("value");
                    if (name.equals("size")) {
                        try {
                            size = Float.parseFloat(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("bend")) {
                        try {
                            legbend = Float.parseFloat(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("color")) {
                        try {
                            col = Color.decode(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("intersp")) {
                        try {
                            interspace = Float.parseFloat(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("ftsize")) {
                        try {
                            ftsize = Integer.parseInt(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("labx")) {
                        labx = value2;
                        continue;
                    }
                    if (name.equals("labxdist")) {
                        try {
                            labxdist = Float.parseFloat(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("position")) {
                        position = value2;
                        continue;
                    }
                    if (name.equals("legdx")) {
                        try {
                            dxborder = Float.parseFloat(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("legdy")) {
                        try {
                            dyborder = Float.parseFloat(value2);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("vertical")) {
                        try {
                            isVertical = Boolean.parseBoolean(value2);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (!name.equals("edgelen")) continue;
                    try {
                        edgelen = Float.parseFloat(value2);
                        continue;
                    }
                    catch (NumberFormatException ignore) {
                        // empty catch block
                    }
                }
                sizevec.clear();
                colvec.clear();
                shapevec.clear();
                labvec.clear();
                List members = leg.getChildren("member", ns);
                if (legtype.equals("edgewidth") || legtype.equals("nodesize")) {
                    for (int j = 0; j < members.size(); ++j) {
                        float value3 = 0.0f;
                        member = (Element)members.get(j);
                        label = member.getAttributeValue("label");
                        try {
                            value3 = Float.parseFloat(member.getText());
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                        labvec.add(label);
                        sizevec.add(Float.valueOf(value3));
                    }
                    this.addLegendSize(sizevec, labvec, col, interspace, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype, edgelen);
                    continue;
                }
                if (legtype.equals("nodecolor") || legtype.equals("edgecolor")) {
                    for (int j = 0; j < members.size(); ++j) {
                        value = Color.BLACK;
                        member = (Element)members.get(j);
                        label = member.getAttributeValue("label");
                        try {
                            value = Color.decode(member.getText());
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                        labvec.add(label);
                        colvec.add((Color)value);
                    }
                    this.addLegendColor(colvec, labvec, size, legbend, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype);
                    continue;
                }
                if (!legtype.equals("nodeshape") && !legtype.equals("edgeshape")) continue;
                for (int j = 0; j < members.size(); ++j) {
                    value = "";
                    member = (Element)members.get(j);
                    label = member.getAttributeValue("label");
                    value = member.getText();
                    labvec.add(label);
                    shapevec.add((String)value);
                }
                this.addLegendShape(shapevec, labvec, col, size, interspace, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype);
            }
            Hashtable<String, Integer> xmlKeyHash = new Hashtable<String, Integer>();
            List xmlNodeList = root.getChildren("node", ns);
            for (int i = 0; i < xmlNodeList.size(); ++i) {
                float width;
                float y;
                float x;
                float w;
                float h;
                boolean b;
                Element node = (Element)xmlNodeList.get(i);
                String label = node.getAttributeValue("label");
                String id = node.getAttributeValue("id");
                Element graphics = null;
                String corLine = "";
                String corFill = "";
                String widthg = "";
                String yg = "";
                String xg = "";
                String wg = "";
                String hg = "";
                String nodeShape = "";
                try {
                    graphics = node.getChild("graphics", ns);
                }
                catch (Exception ignore) {
                    graphics = null;
                }
                if (graphics != null) {
                    nodeShape = graphics.getAttributeValue("type");
                    hg = graphics.getAttributeValue("h");
                    wg = graphics.getAttributeValue("w");
                    xg = graphics.getAttributeValue("x");
                    yg = graphics.getAttributeValue("y");
                    widthg = graphics.getAttributeValue("width");
                    corFill = graphics.getAttributeValue("fill");
                    corLine = graphics.getAttributeValue("outline");
                }
                if (!(b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", nodeShape))) {
                    nodeShape = "ELLIPSE";
                }
                Color fill = new Color(255, 102, 102);
                try {
                    fill = Color.decode(corFill);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
                Color outline = new Color(255, 0, 0);
                try {
                    outline = Color.decode(corLine);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
                try {
                    h = Float.parseFloat(hg);
                    w = Float.parseFloat(wg);
                    x = Float.parseFloat(xg);
                    y = Float.parseFloat(yg);
                    width = Float.parseFloat(widthg);
                }
                catch (NumberFormatException ignore) {
                    w = 20.0f;
                    h = 20.0f;
                    width = 1.0f;
                    x = (float)Math.random() * 600.0f;
                    y = (float)Math.random() * 400.0f;
                }
                List attributes = node.getChildren("att", ns);
                String alias = label;
                boolean nodeIsGroup = false;
                String groupComponets = "";
                int groupCompNumber = 0;
                boolean nodeIsContainer = false;
                boolean isContainerAnchored = false;
                boolean isContainerHided = false;
                boolean isContainerTransparent = false;
                String nodeLineType = "SOLID";
                boolean nodeGradient = false;
                float bend = 50.0f;
                Font font = new Font("Arial", 0, 12);
                double nodeWeight = 0.0;
                float fontXposition = 10.0f;
                float fontYposition = 12.0f;
                float nodeSize = (h + w) / 2.0f / 20.0f;
                Color labelColor = new Color(51, 51, 51);
                double relativeSize = 1.0;
                for (int j = 0; j < attributes.size(); ++j) {
                    Element att = (Element)attributes.get(j);
                    String name = att.getAttributeValue("name");
                    String value = att.getAttributeValue("value");
                    if (name.equals("group")) {
                        groupComponets = value;
                        nodeIsGroup = true;
                        continue;
                    }
                    if (name.equals("componets")) {
                        try {
                            groupCompNumber = Integer.parseInt(value);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("container.rsize")) {
                        nodeIsContainer = true;
                        try {
                            relativeSize = Double.parseDouble(value);
                            relativeSize /= 100.0;
                            if (!(relativeSize < 0.0)) continue;
                            relativeSize = 1.0;
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("container.status")) {
                        if (value.equals("TTT")) {
                            isContainerAnchored = true;
                            isContainerHided = true;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("TFT")) {
                            isContainerAnchored = true;
                            isContainerHided = false;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("FTT")) {
                            isContainerAnchored = false;
                            isContainerHided = true;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("FFT")) {
                            isContainerAnchored = false;
                            isContainerHided = false;
                            isContainerTransparent = true;
                            continue;
                        }
                        if (value.equals("TTF")) {
                            isContainerAnchored = true;
                            isContainerHided = true;
                            isContainerTransparent = false;
                            continue;
                        }
                        if (value.equals("TFF")) {
                            isContainerAnchored = true;
                            isContainerHided = false;
                            isContainerTransparent = false;
                            continue;
                        }
                        if (value.equals("FTF")) {
                            isContainerAnchored = false;
                            isContainerHided = true;
                            isContainerTransparent = false;
                            continue;
                        }
                        if (!value.equals("FFF")) continue;
                        isContainerAnchored = false;
                        isContainerHided = false;
                        isContainerTransparent = false;
                        continue;
                    }
                    if (name.equals("gradient")) {
                        if (!value.equals("true")) continue;
                        nodeGradient = true;
                        continue;
                    }
                    if (name.equals("alias")) {
                        alias = value;
                        continue;
                    }
                    if (name.equals("line.type")) {
                        b = Pattern.matches("SOLID|DOTTED_SHORT|LONG_DASH|DOTTED", value);
                        if (!b) continue;
                        nodeLineType = value;
                        continue;
                    }
                    if (name.equals("node.bend")) {
                        try {
                            bend = Float.parseFloat(value);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("node.weight")) {
                        try {
                            nodeWeight = Double.parseDouble(value);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("node.labelColor")) {
                        try {
                            labelColor = Color.decode(value);
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (name.equals("node.font")) {
                        try {
                            String[] splitFont = value.split("-");
                            String fontName = splitFont[0];
                            int fontType = Integer.parseInt(splitFont[1]);
                            int fontSize = Integer.parseInt(splitFont[2]);
                            font = new Font(fontName, fontType, fontSize);
                        }
                        catch (Exception ignore) {}
                        continue;
                    }
                    if (name.equals("font.x.position")) {
                        try {
                            fontXposition = Float.parseFloat(value);
                        }
                        catch (Exception ignore) {}
                        continue;
                    }
                    if (!name.equals("font.y.position")) continue;
                    try {
                        fontYposition = Float.parseFloat(value);
                        continue;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                NodeList.add(new NodeBank(label, NodeList.size()));
                keyNodeHash.put(label, new Integer(i));
                keyNodeArray.add(label);
                xmlKeyHash.put(id, new Integer(i));
                this.nodeAccount = NodeList.get(i);
                this.nodeAccount.setAsGroup(nodeIsGroup);
                this.nodeAccount.setGroupComponents(groupComponets);
                this.nodeAccount.setGroupCompNumber(groupCompNumber);
                this.nodeAccount.setContainer(nodeIsContainer);
                this.nodeAccount.setContainerAnchored(isContainerAnchored);
                this.nodeAccount.setContainerHided(isContainerHided);
                this.nodeAccount.setContainerTransparent(isContainerTransparent);
                this.nodeAccount.setRelativeSize(relativeSize);
                this.nodeAccount.setNodeGradient(nodeGradient);
                this.nodeAccount.setNodeShape(nodeShape);
                this.nodeAccount.setNodeLineType(nodeLineType);
                this.nodeAccount.setNode(x - dX, y - dY, h, w);
                this.nodeAccount.setNodeColor(fill);
                this.nodeAccount.setNodeLineWidth(width);
                this.nodeAccount.setNodeLineColor(outline);
                this.nodeAccount.setFont(font);
                this.nodeAccount.setFontColor(labelColor);
                this.nodeAccount.setFontX(fontXposition);
                this.nodeAccount.setFontY(fontYposition);
                this.nodeAccount.setAliases(alias);
                this.nodeAccount.setNodeBend(bend);
                this.nodeAccount.setNodeSize(nodeSize);
                this.nodeAccount.setWeight(nodeWeight);
            }
            List xmlEdgeList = root.getChildren("edge", ns);
            int cont = 0;
            for (int i = 0; i < xmlEdgeList.size(); ++i) {
                int direction;
                Element edge = (Element)xmlEdgeList.get(i);
                String idSource = edge.getAttributeValue("source");
                String idTarget = edge.getAttributeValue("target");
                String textDirection = edge.getAttributeValue("direction");
                try {
                    direction = Integer.parseInt(textDirection);
                }
                catch (NumberFormatException ignore) {
                    direction = 0;
                }
                List attributes = edge.getChildren("att", ns);
                double edgeWeight = 0.0;
                float arrowlen = 10.0f;
                float arrowangle = 45.0f;
                boolean defaultNesting = true;
                for (int j = 0; j < attributes.size(); ++j) {
                    Element att = (Element)attributes.get(j);
                    String name = att.getAttributeValue("name");
                    String value = att.getAttributeValue("value");
                    if (name.equals("weight")) {
                        try {
                            edgeWeight = Double.parseDouble(value);
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                    }
                    if (name.equals("arrowlength")) {
                        try {
                            arrowlen = Float.parseFloat(value);
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                    }
                    if (name.equals("arrowangle")) {
                        try {
                            arrowangle = Float.parseFloat(value);
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                    }
                    if (!name.equals("defaultnesting")) continue;
                    defaultNesting = !value.equals("false");
                }
                Element graphics = null;
                try {
                    graphics = edge.getChild("graphics", ns);
                }
                catch (Exception ignore) {
                    graphics = null;
                }
                String texto1 = "1.0";
                String texto2 = "#9999ff";
                String texto3 = "SOLID";
                if (graphics != null) {
                    texto1 = graphics.getAttributeValue("width");
                    texto2 = graphics.getAttributeValue("fill");
                    texto3 = graphics.getAttributeValue("edgeLineType");
                }
                float width = 1.0f;
                try {
                    width = Float.parseFloat(texto1);
                }
                catch (NumberFormatException ignore) {
                    width = 1.0f;
                }
                Color fill = new Color(255, 0, 0);
                try {
                    fill = Color.decode(texto2);
                }
                catch (NumberFormatException ignore) {
                    fill = new Color(255, 0, 0);
                }
                String edgeLineType = texto3;
                int intSource = (Integer)xmlKeyHash.get(idSource);
                int intTarget = (Integer)xmlKeyHash.get(idTarget);
                int n = EdgeList.size();
                boolean flagFound = false;
                for (int j = 0; j < n && !flagFound; ++j) {
                    this.edgeAccount = EdgeList.get(j);
                    if ((this.edgeAccount.getA() != intSource || this.edgeAccount.getB() != intTarget) && (this.edgeAccount.getA() != intTarget || this.edgeAccount.getB() != intSource)) continue;
                    flagFound = true;
                }
                if (flagFound) continue;
                boolean c1 = !NodeList.get(intSource).isContainer();
                boolean c2 = NodeList.get(intTarget).isContainer();
                if (c1 && c2) {
                    EdgeList.add(new EdgeBank(intSource, intTarget, EdgeList.size()));
                    EdgeList.get(cont).setDefaultContainerEdge(false);
                } else {
                    EdgeList.add(new EdgeBank(intSource, intTarget, EdgeList.size()));
                }
                this.edgeAccount = EdgeList.get(cont);
                this.edgeAccount.setLine(width, edgeLineType);
                this.edgeAccount.setArrowDirection(direction);
                this.edgeAccount.setColor(fill);
                this.edgeAccount.setWeight(edgeWeight);
                this.edgeAccount.setArrowLength(arrowlen);
                this.edgeAccount.setArrowAngle(arrowangle);
                this.edgeAccount.setDefaultContainerEdge(defaultNesting);
                this.nodeAccount = NodeList.get(intTarget);
                this.nodeAccount.addParceiro(intSource);
                this.nodeAccount = NodeList.get(intSource);
                this.nodeAccount.addParceiro(intTarget);
                ++cont;
            }
            this.taskProgress = "endload";
        }
        catch (JDOMException ignore) {
            this.taskProgress = "halt";
        }
        catch (IOException ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadBasicNodes(ArrayList<String> nodes) {
        Pattern nodePattern = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)");
        this.nodeAccount = null;
        for (int i = 0; i < nodes.size(); ++i) {
            float y;
            float x;
            int node;
            Matcher matcher;
            if (nodes.get(i) == null || !(matcher = nodePattern.matcher(nodes.get(i))).find()) continue;
            boolean flag = false;
            if (NodeList.isEmpty()) {
                NodeList.add(new NodeBank(matcher.group(2), NodeList.size()));
                node = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(2), new Integer(node));
                keyNodeArray.add(matcher.group(2));
                flag = true;
            } else if (!keyNodeHash.containsKey(matcher.group(2))) {
                NodeList.add(new NodeBank(matcher.group(2), NodeList.size()));
                node = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(2), new Integer(node));
                keyNodeArray.add(matcher.group(2));
                flag = true;
            }
            if (!flag) continue;
            node = NodeList.size() - 1;
            this.nodeAccount = NodeList.get(node);
            String nodeShape = matcher.group(3);
            boolean b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", nodeShape);
            if (!b) {
                nodeShape = "ELLIPSE";
            }
            float nodeSize = 1.0f;
            try {
                nodeSize = Float.parseFloat(matcher.group(4)) / 20.0f;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            Color nodeColor = new Color(255, 102, 102);
            try {
                nodeColor = Color.decode(matcher.group(5));
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            try {
                x = Float.parseFloat(matcher.group(6));
                y = Float.parseFloat(matcher.group(7));
            }
            catch (NumberFormatException ignore) {
                x = (float)Math.random() * 600.0f;
                y = (float)Math.random() * 400.0f;
            }
            double nodeWeight = 1.0;
            try {
                nodeWeight = Double.parseDouble(matcher.group(6));
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            this.nodeAccount.setNodeShape(nodeShape);
            this.nodeAccount.setNodeSize(nodeSize);
            this.nodeAccount.setNodeColor(nodeColor);
            this.nodeAccount.setNode(x, y);
            this.nodeAccount.setNodeWeight(nodeWeight);
        }
    }

    private void loadBasicLinks(ArrayList<String> links) {
        Pattern edgePattern = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)[\\s;]+([^\\s]+)");
        try {
            for (int i = 0; i < links.size(); ++i) {
                Matcher matcher;
                if (links.get(i) == null || !(matcher = edgePattern.matcher(links.get(i))).find()) continue;
                int nodeA = 0;
                int nodeB = 0;
                double value = 0.0;
                boolean depositoParceiroA = false;
                boolean depositoParceiroB = false;
                try {
                    nodeA = Integer.parseInt(matcher.group(1));
                    nodeB = Integer.parseInt(matcher.group(2));
                    value = Double.parseDouble(matcher.group(3));
                    NodeBank nodeAccount1 = NodeList.get(nodeA);
                    NodeBank nodeAccount2 = NodeList.get(nodeB);
                    depositoParceiroA = nodeAccount1.addParceiro(nodeB);
                    depositoParceiroB = nodeAccount2.addParceiro(nodeA);
                    if (!depositoParceiroA || !depositoParceiroB) continue;
                    EdgeList.add(new EdgeBank(nodeA, nodeB, EdgeList.size()));
                    this.edgeAccount = EdgeList.get(EdgeList.size() - 1);
                    this.edgeAccount.setWeight(value);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.taskProgress = "endload";
        }
        catch (Exception ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadBanksViaNodes(ArrayList<String> nodes) {
        Pattern nodePattern = Pattern.compile("^([^\\s]+)");
        try {
            this.nodeAccount = null;
            for (int i = 0; i < nodes.size(); ++i) {
                int intNodeID;
                Matcher matcher;
                if (nodes.get(i) == null || !(matcher = nodePattern.matcher(nodes.get(i))).find()) continue;
                if (NodeList.isEmpty()) {
                    NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                    intNodeID = NodeList.size() - 1;
                    keyNodeHash.put(matcher.group(1), new Integer(intNodeID));
                    keyNodeArray.add(matcher.group(1));
                    continue;
                }
                if (keyNodeHash.containsKey(matcher.group(1))) continue;
                NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                intNodeID = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(1), new Integer(intNodeID));
                keyNodeArray.add(matcher.group(1));
            }
            this.taskProgress = "endload";
        }
        catch (Exception e) {
            this.taskProgress = "halt";
        }
    }

    private void loadBanksViaLinks(ArrayList<String> links) {
        Pattern edgePattern = Pattern.compile("^([^\\s]+)[\\s;]+([^\\s]+)");
        try {
            this.nodeAccount = null;
            for (int i = 0; i < links.size(); ++i) {
                if (links.get(i) == null) continue;
                Matcher matcher = edgePattern.matcher(links.get(i));
                if (matcher.find()) {
                    NodeBank nodeAccount2;
                    int nodeB;
                    NodeBank nodeAccount1;
                    int nodeA;
                    boolean depositoParceiroA = false;
                    boolean depositoParceiroB = false;
                    if (NodeList.isEmpty()) {
                        NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                        nodeA = NodeList.size() - 1;
                        keyNodeHash.put(matcher.group(1), new Integer(nodeA));
                        keyNodeArray.add(matcher.group(1));
                        nodeAccount1 = NodeList.get(nodeA);
                        NodeList.add(new NodeBank(matcher.group(2), NodeList.size()));
                        nodeB = NodeList.size() - 1;
                        keyNodeHash.put(matcher.group(2), new Integer(nodeB));
                        keyNodeArray.add(matcher.group(2));
                        nodeAccount2 = NodeList.get(nodeB);
                    } else {
                        if (!keyNodeHash.containsKey(matcher.group(1))) {
                            NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                            nodeA = NodeList.size() - 1;
                            keyNodeHash.put(matcher.group(1), new Integer(nodeA));
                            keyNodeArray.add(matcher.group(1));
                            nodeAccount1 = NodeList.get(nodeA);
                        } else {
                            nodeA = (Integer)keyNodeHash.get(matcher.group(1));
                            nodeAccount1 = NodeList.get(nodeA);
                        }
                        if (!keyNodeHash.containsKey(matcher.group(2))) {
                            NodeList.add(new NodeBank(matcher.group(2), NodeList.size()));
                            nodeB = NodeList.size() - 1;
                            keyNodeHash.put(matcher.group(2), new Integer(nodeB));
                            keyNodeArray.add(matcher.group(2));
                            nodeAccount2 = NodeList.get(nodeB);
                        } else {
                            nodeB = (Integer)keyNodeHash.get(matcher.group(2));
                            nodeAccount2 = NodeList.get(nodeB);
                        }
                    }
                    depositoParceiroA = nodeAccount1.addParceiro(nodeB);
                    depositoParceiroB = nodeAccount2.addParceiro(nodeA);
                    if (!depositoParceiroA || !depositoParceiroB) continue;
                    EdgeList.add(new EdgeBank(nodeA, nodeB, EdgeList.size()));
                    continue;
                }
                Pattern nodePattern = Pattern.compile("^([^\\s]+)");
                matcher = nodePattern.matcher(links.get(i));
                if (!matcher.find()) continue;
                if (NodeList.isEmpty()) {
                    NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                    int node = NodeList.size() - 1;
                    keyNodeHash.put(matcher.group(1), new Integer(node));
                    keyNodeArray.add(matcher.group(1));
                    continue;
                }
                if (keyNodeHash.containsKey(matcher.group(1))) continue;
                NodeList.add(new NodeBank(matcher.group(1), NodeList.size()));
                int node = NodeList.size() - 1;
                keyNodeHash.put(matcher.group(1), new Integer(node));
                keyNodeArray.add(matcher.group(1));
            }
            this.taskProgress = "endload";
        }
        catch (Exception ignore) {
            this.taskProgress = "halt";
        }
    }

    private void loadRandomGraph() {
        ArrayList<String> links = new ArrayList<String>();
        links.add("n1;n2");
        links.add("n1;n3");
        links.add("n1;n4");
        links.add("n1;n5");
        links.add("n1;n6");
        links.add("n1;n7");
        links.add("n1;n8");
        links.add("n1;n9");
        links.add("n2;n10");
        links.add("n2;n11");
        links.add("n2;n12");
        links.add("n2;n13");
        links.add("n2;n14");
        links.add("n2;n15");
        links.add("n2;n16");
        links.add("n2;n17");
        links.add("n2;n18");
        links.add("n2;n19");
        this.loadBanksViaLinks(links);
    }

    private void customXmlPlugins() {
        SAXBuilder parser = new SAXBuilder();
        try {
            Document doc = parser.build(this.openAddress);
            Element root = doc.getRootElement();
            List xmlPluginList = root.getChildren("plugin");
            for (int i = 0; i < xmlPluginList.size(); ++i) {
                String pluginName = "NA";
                Element plugin = (Element)xmlPluginList.get(i);
                pluginName = plugin.getAttributeValue("name");
                if (pluginName == null) continue;
                List methodList = plugin.getChildren("method");
                List addonList = plugin.getChildren("addon");
                int id = MainFrame.methods.checkPluginName(pluginName);
                if (id < 0) {
                    MainFrame.PluginList.add(new Plugins(pluginName));
                    id = MainFrame.PluginList.size() - 1;
                }
                Plugins pluginAccount = MainFrame.PluginList.get(id);
                for (int j = 0; j < methodList.size(); ++j) {
                    String code;
                    Element method = (Element)methodList.get(j);
                    String name = method.getAttributeValue("name");
                    if (name == null || (code = method.getText()) == null) continue;
                    pluginAccount.addMethod(name, code);
                }
                for (int j = 0; j < addonList.size(); ++j) {
                    String code;
                    Element addon = (Element)addonList.get(j);
                    String name = addon.getAttributeValue("name");
                    if (name == null || (code = addon.getText()) == null) continue;
                    pluginAccount.addAddon(name, code);
                }
                methodList.clear();
                addonList.clear();
            }
        }
        catch (JDOMException ignore) {
            this.taskProgress = "halt";
        }
        catch (IOException ignore) {
            this.taskProgress = "halt";
        }
    }

    private void defaultXmlPlugins() {
        SAXBuilder parser = new SAXBuilder();
        try {
            InputStream in = this.getClass().getResourceAsStream("/reder/plugins/plugins.xml");
            Document doc = parser.build(in);
            Element root = doc.getRootElement();
            List xmlPluginList = root.getChildren("plugin");
            for (int i = 0; i < xmlPluginList.size(); ++i) {
                String pluginName = "NA";
                Element plugin = (Element)xmlPluginList.get(i);
                pluginName = plugin.getAttributeValue("name");
                if (pluginName == null) continue;
                List methodList = plugin.getChildren("method");
                List addonList = plugin.getChildren("addon");
                int id = MainFrame.methods.checkPluginName(pluginName);
                if (id < 0) {
                    MainFrame.PluginList.add(new Plugins(pluginName));
                    id = MainFrame.PluginList.size() - 1;
                }
                Plugins pluginAccount = MainFrame.PluginList.get(id);
                for (int j = 0; j < methodList.size(); ++j) {
                    String code;
                    Element method = (Element)methodList.get(j);
                    String name = method.getAttributeValue("name");
                    if (name == null || (code = method.getText()) == null) continue;
                    pluginAccount.addMethod(name, code);
                }
                for (int j = 0; j < addonList.size(); ++j) {
                    String code;
                    Element addon = (Element)addonList.get(j);
                    String name = addon.getAttributeValue("name");
                    if (name == null || (code = addon.getText()) == null) continue;
                    pluginAccount.addAddon(name, code);
                }
                methodList.clear();
                addonList.clear();
            }
            in.close();
            this.taskProgress = "endPluginload";
        }
        catch (JDOMException ignore) {
            this.taskProgress = "halt";
        }
        catch (IOException ignore) {
            this.taskProgress = "halt";
        }
    }

    private void addLegendSize(Vector<Float> sizevec, Vector<String> labvec, Color col, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype, float edgelen) {
        int nnodes = sizevec.size();
        this.clearLegend(legtype);
        float totalszH = 0.0f;
        float totalszW = 0.0f;
        float a = 0.0f;
        float b = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            if (a < sizevec.get(i).floatValue()) {
                a = sizevec.get(i).floatValue();
            }
            b = b + sizevec.get(i).floatValue() + interspace;
        }
        totalszH = a;
        totalszW = b;
        if (isVertical) {
            totalszH = b;
            totalszW = a;
        }
        float largerH = Math.min(a, b);
        float largerW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(col);
            legendAccount.setNodeLineColor(col);
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgewidth")) {
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f, sizevec.get(i).floatValue(), edgelen);
                    totalszW = edgelen;
                    largerW = edgelen;
                } else {
                    legendAccount.setNode(0.0f, 0.0f, edgelen, sizevec.get(i).floatValue());
                    totalszH = edgelen;
                    largerH = edgelen;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f, sizevec.get(i).floatValue(), sizevec.get(i).floatValue());
            }
            legendAccount.totalMembers(nnodes);
            legendAccount.setDim(totalszH, totalszW, largerH, largerW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
            legendAccount.setFontDist(12.0f, 3.0f);
        }
    }

    private void addLegendColor(Vector<Color> colvec, Vector<String> labvec, float size, float bend, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int nnodes = colvec.size();
        this.clearLegend(legtype);
        float totalszH = 0.0f;
        float totalszW = 0.0f;
        float largerH = size * (0.5f + bend / 100.0f);
        float largerW = size * (1.0f + (0.5f - bend / 100.0f));
        if (isVertical) {
            totalszH = largerH * (float)nnodes;
            totalszW = largerW;
        } else {
            totalszH = largerH;
            totalszW = largerW * (float)nnodes;
        }
        for (int i = 0; i < nnodes; ++i) {
            int legID = LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeSize(size / 20.0f);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegType(legtype);
            legendAccount.totalMembers(nnodes);
            legendAccount.setDim(totalszH, totalszW, largerH, largerW);
            legendAccount.setMembership(i);
            legendAccount.setLegShape("RECTANGLE");
            legendAccount.setNodeBend(bend);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setNodeLineWidth(0.5f);
            legendAccount.setFontDist(12.0f, 6.0f);
        }
    }

    private void addLegendShape(Vector<String> shapevec, Vector<String> labvec, Color col, float size, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int nnodes = shapevec.size();
        this.clearLegend(legtype);
        float totalszH = 0.0f;
        float totalszW = 0.0f;
        float a = 0.0f;
        float b = 0.0f;
        a = size;
        for (int i = 0; i < nnodes; ++i) {
            b = b + size + interspace;
        }
        totalszH = a;
        totalszW = b;
        if (isVertical) {
            totalszH = b;
            totalszW = a;
        }
        float largerH = Math.min(a, b);
        float largerW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(col);
            legendAccount.setNodeLineColor(col);
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgeshape")) {
                float len = 50.0f;
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f, size, len);
                    totalszW = len;
                    largerW = len;
                } else {
                    legendAccount.setNode(0.0f, 0.0f, len, size);
                    totalszH = len;
                    largerH = len;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f, size, size);
            }
            legendAccount.setLegShape(shapevec.get(i));
            legendAccount.totalMembers(nnodes);
            legendAccount.setDim(totalszH, totalszW, largerH, largerW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
            float fx = 14.0f;
            if (legtype.equals("nodeshape")) {
                fx = 20.0f;
            }
            legendAccount.setFontDist(fx, 6.0f);
        }
    }

    private void clearLegend(String type) {
        for (int i = 0; i < LegendList.size(); ++i) {
            LegendBank legAccount = LegendList.get(i);
            String tp = legAccount.getLegType();
            if (!tp.equals(type)) continue;
            LegendList.remove(i);
            --i;
        }
    }
}

