/*
 * Decompiled with CFR 0.152.
 */
package reder.cluster;

import java.util.Vector;
import reder.cluster.Centroid;
import reder.cluster.DataPoint;

class Cluster {
    private String mName;
    private Centroid mCentroid;
    private double mSumSqr;
    private Vector mDataPoints;

    public Cluster(String name) {
        this.mName = name;
        this.mCentroid = null;
        this.mDataPoints = new Vector();
    }

    public void setCentroid(Centroid c) {
        this.mCentroid = c;
    }

    public Centroid getCentroid() {
        return this.mCentroid;
    }

    public void addDataPoint(DataPoint dp) {
        dp.setCluster(this);
        this.mDataPoints.addElement(dp);
        this.calcSumOfSquares();
    }

    public void removeDataPoint(DataPoint dp) {
        this.mDataPoints.removeElement(dp);
        this.calcSumOfSquares();
    }

    public int getNumDataPoints() {
        return this.mDataPoints.size();
    }

    public DataPoint getDataPoint(int pos) {
        return (DataPoint)this.mDataPoints.elementAt(pos);
    }

    public void calcSumOfSquares() {
        int size = this.mDataPoints.size();
        double temp = 0.0;
        for (int i = 0; i < size; ++i) {
            temp += ((DataPoint)this.mDataPoints.elementAt(i)).getCurrentEuDt();
        }
        this.mSumSqr = temp;
    }

    public double getSumSqr() {
        return this.mSumSqr;
    }

    public String getName() {
        return this.mName;
    }

    public Vector getDataPoints() {
        return this.mDataPoints;
    }
}

