/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class LensTranslatingGraphMousePlugin
extends TranslatingGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected boolean dragOnLens;
    protected boolean dragOnEdge;
    protected double edgeOffset;

    public LensTranslatingGraphMousePlugin() {
        this(16);
    }

    public LensTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        MutableTransformer vt = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
        if (vt instanceof LensTransformer) {
            vt = ((LensTransformer)vt).getDelegate();
        }
        Point2D p = vt.inverseTransform(e.getPoint());
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            vv.setCursor(Cursor.getPredefinedCursor(13));
            this.testViewCenter(vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT), p);
            this.testViewCenter(vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW), p);
            vv.repaint();
        }
        super.mousePressed(e);
    }

    private void setViewCenter(MutableTransformer transformer, Point2D point) {
        if (transformer instanceof LensTransformer) {
            LensTransformer ht = (LensTransformer)transformer;
            ht.setViewCenter(point);
        }
    }

    private void setViewRadius(MutableTransformer transformer, Point2D point) {
        if (transformer instanceof LensTransformer) {
            LensTransformer ht = (LensTransformer)transformer;
            double distanceFromCenter = ht.getDistanceFromCenter(point);
            ht.setViewRadius(distanceFromCenter + this.edgeOffset);
        }
    }

    private void testViewCenter(MutableTransformer transformer, Point2D point) {
        if (transformer instanceof LensTransformer) {
            LensTransformer ht = (LensTransformer)transformer;
            double distanceFromCenter = ht.getDistanceFromCenter(point);
            if (distanceFromCenter < 10.0) {
                ht.setViewCenter(point);
                this.dragOnLens = true;
            } else if (Math.abs(distanceFromCenter - ht.getViewRadius()) < 10.0) {
                this.edgeOffset = ht.getViewRadius() - distanceFromCenter;
                ht.setViewRadius(distanceFromCenter + this.edgeOffset);
                this.dragOnEdge = true;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.dragOnLens = false;
        this.dragOnEdge = false;
        this.edgeOffset = 0.0;
    }

    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        MutableTransformer vt = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
        if (vt instanceof LensTransformer) {
            vt = ((LensTransformer)vt).getDelegate();
        }
        Point2D p = vt.inverseTransform(e.getPoint());
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
            vv.setCursor(Cursor.getPredefinedCursor(13));
            if (this.dragOnLens) {
                this.setViewCenter(modelTransformer, p);
                this.setViewCenter(vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW), p);
                e.consume();
                vv.repaint();
            } else if (this.dragOnEdge) {
                this.setViewRadius(modelTransformer, p);
                this.setViewRadius(vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW), p);
                e.consume();
                vv.repaint();
            } else {
                MutableTransformer mt = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
                Point2D iq = vt.inverseTransform(this.down);
                iq = mt.inverseTransform(iq);
                Point2D ip = vt.inverseTransform(e.getPoint());
                ip = mt.inverseTransform(ip);
                float dx = (float)(ip.getX() - iq.getX());
                float dy = (float)(ip.getY() - iq.getY());
                modelTransformer.translate(dx, dy);
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
        }
    }
}

