### R code from vignette source 'Rcade.Rnw'

###################################################
### code chunk number 1: Rcade.Rnw:80-82
###################################################
dir <- file.path(system.file("extdata", package="Rcade"), "STAT1")
dir


###################################################
### code chunk number 2: Rcade.Rnw:88-89
###################################################
library(Rcade)


###################################################
### code chunk number 3: Rcade.Rnw:111-112
###################################################
DE <- read.csv(file.path(dir, "DE.csv"))


###################################################
### code chunk number 4: Rcade.Rnw:117-119
###################################################
DElookup <- list(GeneID="ENSG", logFC="logFC", B="B",
"Genes.Location", "Symbol")


###################################################
### code chunk number 5: Rcade.Rnw:129-130
###################################################
dir(dir, pattern = ".bam")


###################################################
### code chunk number 6: Rcade.Rnw:142-144
###################################################
targets <- read.csv(file.path(dir, "targets.csv"), as.is = TRUE)
targets


###################################################
### code chunk number 7: Rcade.Rnw:156-168 (eval = FALSE)
###################################################
## library(biomaRt)
## 
## anno <- getBM(
## 		attributes= c("ensembl_gene_id", "chromosome_name",
## 			"transcript_start", "transcript_end", "strand"),
## 		mart= useDataset("hsapiens_gene_ensembl", useMart("ensembl"))
## 	)
## 
## ##order, to reduce size of ChIPannoZones object later
## anno <- anno[order(anno$chromosome_name),]
## ##use appropriate column names
## colnames(anno) <- c("ENSG","chr","start","end","str")


###################################################
### code chunk number 8: Rcade.Rnw:173-177
###################################################
anno <- read.csv(file.path(dir, "anno.csv"))

anno <- anno[order(anno$chromosome_name),]
colnames(anno) <- c("ENSG","chr","start","end","str")


###################################################
### code chunk number 9: Rcade.Rnw:182-183
###################################################
ChIPannoZones <- defineBins(anno, zone=c(-1500, 1500), geneID="ENSG")


###################################################
### code chunk number 10: Rcade.Rnw:193-195 (eval = FALSE)
###################################################
## library(parallel)
## cl <- makeCluster(4, "SOCK")


###################################################
### code chunk number 11: Rcade.Rnw:200-201
###################################################
cl <- NULL


###################################################
### code chunk number 12: Rcade.Rnw:206-210
###################################################
Rcade <- RcadeAnalysis(DE, ChIPannoZones, annoZoneGeneidName="ENSG",
	ChIPtargets=targets, ChIPfileDir = dir,
	shift = 0, cl=cl, DElookup=DElookup)
Rcade


###################################################
### code chunk number 13: Rcade.Rnw:214-215
###################################################
x <- getDE(Rcade)


###################################################
### code chunk number 14: Rcade.Rnw:219-220
###################################################
x <- getChIP(Rcade)


###################################################
### code chunk number 15: Rcade.Rnw:224-225
###################################################
x <- getRcade(Rcade)


###################################################
### code chunk number 16: P1
###################################################
plotPCA(Rcade)


###################################################
### code chunk number 17: P1fig
###################################################
plotPCA(Rcade)


###################################################
### code chunk number 18: P2
###################################################
plotMM(Rcade)


###################################################
### code chunk number 19: P2fig
###################################################
plotMM(Rcade)


###################################################
### code chunk number 20: P3 (eval = FALSE)
###################################################
## library(rgl)
## plotBBB(Rcade)


###################################################
### code chunk number 21: Rcade.Rnw:282-283 (eval = FALSE)
###################################################
## exportRcade(Rcade, directory="RcadeOutput")


###################################################
### code chunk number 22: Rcade.Rnw:288-289 (eval = FALSE)
###################################################
## ?exportRcade


###################################################
### code chunk number 23: Rcade.Rnw:294-295 (eval = FALSE)
###################################################
## exportRcade(Rcade, directory="RcadeOutput", cutoffArg=2000)


###################################################
### code chunk number 24: Rcade.Rnw:299-300 (eval = FALSE)
###################################################
## exportRcade(Rcade, directory="RcadeOutput", cutoffMode="B", cutoffArg=0)


###################################################
### code chunk number 25: Rcade.Rnw:318-319
###################################################
sessionInfo()


