### R code from vignette source 'MEDIPS.Rnw'

###################################################
### code chunk number 1: MEDIPS.Rnw:96-102 (eval = FALSE)
###################################################
## packageDescription("BSgenome")
## packageDescription("gtools")
## packageDescription("edgeR")
## packageDescription("DNAcopy")
## packageDescription("Rsamtools")
## packageDescription("rtracklayer")


###################################################
### code chunk number 2: MEDIPS.Rnw:108-115 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("BSgenome")
## biocLite("gtools")
## biocLite("edgeR")
## biocLite("DNAcopy")
## biocLite("Rsamtools")
## biocLite("rtracklayer")


###################################################
### code chunk number 3: MEDIPS.Rnw:121-123 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("MEDIPS")


###################################################
### code chunk number 4: MEDIPS.Rnw:129-130 (eval = FALSE)
###################################################
## library("BSgenome")


###################################################
### code chunk number 5: MEDIPS.Rnw:133-134 (eval = FALSE)
###################################################
## available.genomes()


###################################################
### code chunk number 6: MEDIPS.Rnw:140-142 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("BSgenome.Hsapiens.UCSC.hg19")


###################################################
### code chunk number 7: MEDIPS.Rnw:148-150 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("MEDIPSData")


###################################################
### code chunk number 8: MEDIPS.Rnw:161-162
###################################################
library(MEDIPS)


###################################################
### code chunk number 9: MEDIPS.Rnw:168-169
###################################################
library(BSgenome.Hsapiens.UCSC.hg19)


###################################################
### code chunk number 10: MEDIPS.Rnw:180-181
###################################################
library("MEDIPSData")


###################################################
### code chunk number 11: MEDIPS.Rnw:203-206
###################################################
bam.file.hESCs.Rep1.MeDIP = system.file("extdata", "hESCs.MeDIP.Rep1.chr22.bam", package="MEDIPSData")
bam.file.hESCs.Input = system.file("extdata", "hESCs.Input.chr22.bam", package="MEDIPSData")
bam.file.DE.Input = system.file("extdata", "DE.Input.chr22.bam", package="MEDIPSData")


###################################################
### code chunk number 12: MEDIPS.Rnw:216-217
###################################################
BSgenome="BSgenome.Hsapiens.UCSC.hg19"


###################################################
### code chunk number 13: MEDIPS.Rnw:220-221
###################################################
uniq=TRUE


###################################################
### code chunk number 14: MEDIPS.Rnw:224-225
###################################################
extend=300


###################################################
### code chunk number 15: MEDIPS.Rnw:230-231
###################################################
shift=0


###################################################
### code chunk number 16: MEDIPS.Rnw:234-235
###################################################
ws=100


###################################################
### code chunk number 17: MEDIPS.Rnw:240-241
###################################################
chr.select="chr22"


###################################################
### code chunk number 18: MEDIPS.Rnw:256-257
###################################################
sr=MEDIPS.saturation(file=bam.file.hESCs.Rep1.MeDIP, BSgenome=BSgenome, uniq=uniq, extend=extend, shift=shift, window_size=ws, chr.select=chr.select, nit=10, nrit=1, empty_bins=TRUE, rank=FALSE)


###################################################
### code chunk number 19: MEDIPS.Rnw:275-276
###################################################
sr


###################################################
### code chunk number 20: MEDIPS.Rnw:286-287
###################################################
MEDIPS.plotSaturation(sr)


###################################################
### code chunk number 21: MEDIPS.Rnw:313-314
###################################################
cr=MEDIPS.seqCoverage(file=bam.file.hESCs.Rep1.MeDIP, pattern="CG", BSgenome=BSgenome, chr.select=chr.select, extend=extend, shift=shift, uniq=uniq)


###################################################
### code chunk number 22: MEDIPS.Rnw:332-333
###################################################
MEDIPS.plotSeqCoverage(seqCoverageObj=cr, type="pie", cov.level = c(0,1, 2, 3, 4, 5))


###################################################
### code chunk number 23: MEDIPS.Rnw:340-341
###################################################
MEDIPS.plotSeqCoverage(seqCoverageObj=cr, type="hist", t = 15, main="Sequence pattern coverage, histogram")


###################################################
### code chunk number 24: MEDIPS.Rnw:358-359 (eval = FALSE)
###################################################
## er=MEDIPS.CpGenrich(file=bam.file.hESCs.Rep1.MeDIP, BSgenome=BSgenome, chr.select=chr.select, extend=extend, shift=shift, uniq=uniq)


###################################################
### code chunk number 25: MEDIPS.Rnw:378-379 (eval = FALSE)
###################################################
## hESCs_MeDIP = MEDIPS.createSet(file=bam.file.hESCs.Rep1.MeDIP, BSgenome=BSgenome, extend=extend, shift=shift, uniq=uniq, window_size=ws, chr.select=chr.select)


###################################################
### code chunk number 26: MEDIPS.Rnw:385-387 (eval = FALSE)
###################################################
## bam.file.hESCs.Rep2.MeDIP = system.file("extdata", "hESCs.MeDIP.Rep2.chr22.bam", package="MEDIPSData")
## hESCs_MeDIP = c(hESCs_MeDIP, MEDIPS.createSet(file=bam.file.hESCs.Rep2.MeDIP, BSgenome=BSgenome, extend=extend, shift=shift, uniq=uniq, window_size=ws, chr.select=chr.select))


###################################################
### code chunk number 27: MEDIPS.Rnw:391-393
###################################################
data(hESCs_MeDIP)
data(DE_MeDIP)


###################################################
### code chunk number 28: MEDIPS.Rnw:398-400
###################################################
hESCs_Input = MEDIPS.createSet(file=bam.file.hESCs.Input, BSgenome=BSgenome, extend=extend, shift=shift, uniq=uniq, window_size=ws, chr.select=chr.select)
DE_Input = MEDIPS.createSet(file=bam.file.DE.Input, BSgenome=BSgenome, extend=extend, shift=shift, uniq=uniq, window_size=ws, chr.select=chr.select)


###################################################
### code chunk number 29: MEDIPS.Rnw:413-414
###################################################
CS = MEDIPS.couplingVector(pattern="CG", refObj=hESCs_MeDIP[[1]])


###################################################
### code chunk number 30: MEDIPS.Rnw:422-423
###################################################
mr.edgeR = MEDIPS.meth(MSet1=hESCs_MeDIP, MSet2=DE_MeDIP, CSet=CS, ISet1=hESCs_Input, ISet2=DE_Input, p.adj="bonferroni", diff.method="edgeR", prob.method="poisson", MeDIP=T, CNV=F, type="rpkm", minRowSum=1)


###################################################
### code chunk number 31: MEDIPS.Rnw:486-487
###################################################
mr.edgeR.s = MEDIPS.selectSig(results=mr.edgeR, p.value=0.1, adj=T, ratio=NULL, bg.counts=NULL, CNV=F)


###################################################
### code chunk number 32: MEDIPS.Rnw:523-524
###################################################
mr.edgeR.s.gain = mr.edgeR.s[which(mr.edgeR.s[,grep("logFC", colnames(mr.edgeR.s))]<0),]


###################################################
### code chunk number 33: MEDIPS.Rnw:529-530
###################################################
mr.edgeR.s.gain.m = MEDIPS.mergeFrames(frames=mr.edgeR.s.gain, distance=0)


###################################################
### code chunk number 34: MEDIPS.Rnw:544-545 (eval = FALSE)
###################################################
## rois=MEDIPS.selectROIs(results=mr.edgeR, rois=mr.edgeR.s.loss.m, columns="counts", summarize=F)


###################################################
### code chunk number 35: MEDIPS.Rnw:558-559 (eval = FALSE)
###################################################
## rois.s=MEDIPS.selectROIs(results=mr.edgeR, rois=mr.edgeR.s.m, columns="counts", summarize=T)


###################################################
### code chunk number 36: MEDIPS.Rnw:573-574 (eval = FALSE)
###################################################
## MEDIPS.plotCalibrationPlot(CSet=CS, main="Calibration Plot", MSet=hESCs_MeDIP[[1]], plot_chr="chr22",  rpkm=TRUE,  xrange=TRUE)


###################################################
### code chunk number 37: MEDIPS.Rnw:601-602 (eval = FALSE)
###################################################
## MEDIPS.exportWIG(Set=hESCs_MeDIP[[1]], file="hESC.MeDIP.rep1.wig", format="rpkm", descr="")


###################################################
### code chunk number 38: MEDIPS.Rnw:621-622 (eval = FALSE)
###################################################
## Input.merged=MEDIPS.mergeSets(MSet1=hESCs_Input, MSet2=DE_Input, name="Input.hESCs.DE")


###################################################
### code chunk number 39: MEDIPS.Rnw:635-636 (eval = FALSE)
###################################################
## cor.matrix=MEDIPS.correlation(MSets=c(hESCs_MeDIP, DE_MeDIP, hESCs_Input, DE_Input))


###################################################
### code chunk number 40: MEDIPS.Rnw:645-646 (eval = FALSE)
###################################################
## anno.mart.gene = MEDIPS.getAnnotation(dataset=c("hsapiens_gene_ensembl"), annotation=c("GENE"), chr="chr22")


###################################################
### code chunk number 41: MEDIPS.Rnw:652-653 (eval = FALSE)
###################################################
## mr.edgeR.s = MEDIPS.setAnnotation(regions=mr.edgeR.s, annotation=anno.mart.gene)


###################################################
### code chunk number 42: MEDIPS.Rnw:666-667 (eval = FALSE)
###################################################
## mr.edgeR=MEDIPS.addCNV(cnv.Frame=10000, ISet1=hESCs_Input, ISet2=DE_Input, results=mr.edgeR)


