/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import ding.view.DGraphView;
import ding.view.ViewChangeEdit;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ViewState {
    protected double scaleFactor;
    protected Point2D center;
    protected Map<Node, Point2D.Double> points;
    protected Map<Edge, List> anchors;
    protected Map<Edge, Integer> linetype;
    protected DGraphView view;
    protected ViewChangeEdit.SavedObjs savedObjs;

    public ViewState(DGraphView v, ViewChangeEdit.SavedObjs whatToSave) {
        this.view = v;
        this.points = null;
        this.anchors = null;
        this.linetype = null;
        this.savedObjs = whatToSave;
        this.center = this.view.getCenter();
        this.scaleFactor = this.view.getZoom();
        if (whatToSave == ViewChangeEdit.SavedObjs.ALL || whatToSave == ViewChangeEdit.SavedObjs.NODES) {
            this.points = new HashMap<Node, Point2D.Double>();
            for (Node n : this.view.getGraphPerspective().nodesList()) {
                NodeView nv = this.view.getNodeView(n);
                this.points.put(n, new Point2D.Double(nv.getXPosition(), nv.getYPosition()));
            }
        }
        if (whatToSave == ViewChangeEdit.SavedObjs.ALL || whatToSave == ViewChangeEdit.SavedObjs.EDGES) {
            this.anchors = new HashMap<Edge, List>();
            this.linetype = new HashMap<Edge, Integer>();
            for (Edge e : this.view.getGraphPerspective().edgesList()) {
                EdgeView ev = this.view.getEdgeView(e);
                this.anchors.put(e, ev.getBend().getHandles());
                this.linetype.put(e, ev.getLineType());
            }
        }
        if (whatToSave == ViewChangeEdit.SavedObjs.SELECTED || whatToSave == ViewChangeEdit.SavedObjs.SELECTED_NODES) {
            this.points = new HashMap<Node, Point2D.Double>();
            for (NodeView nv : this.view.getSelectedNodes()) {
                Node n = nv.getNode();
                this.points.put(n, new Point2D.Double(nv.getXPosition(), nv.getYPosition()));
            }
        }
        if (whatToSave == ViewChangeEdit.SavedObjs.SELECTED || whatToSave == ViewChangeEdit.SavedObjs.SELECTED_EDGES) {
            this.anchors = new HashMap<Edge, List>();
            this.linetype = new HashMap<Edge, Integer>();
            for (EdgeView ev : this.view.getSelectedEdges()) {
                Edge e = ev.getEdge();
                this.anchors.put(e, ev.getBend().getHandles());
                this.linetype.put(e, ev.getLineType());
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ViewState)) {
            return false;
        }
        ViewState vs = (ViewState)o;
        if (this.view != vs.view) {
            return false;
        }
        if (!this.center.equals(vs.center)) {
            return false;
        }
        if (Double.compare(this.scaleFactor, vs.scaleFactor) != 0) {
            return false;
        }
        if (this.savedObjs != vs.savedObjs) {
            return false;
        }
        if (this.points != null) {
            if (vs.points == null || this.points.size() != vs.points.size()) {
                return false;
            }
            for (Node n : this.points.keySet()) {
                if (this.points.get(n).equals(vs.points.get(n))) continue;
                return false;
            }
        }
        if (this.anchors != null) {
            if (vs.anchors == null || this.anchors.size() != vs.anchors.size()) {
                return false;
            }
            for (Edge e : this.anchors.keySet()) {
                if (!((Object)this.anchors.get(e)).equals(vs.anchors.get(e))) {
                    return false;
                }
                if (this.linetype.get(e).equals(vs.linetype.get(e))) continue;
                return false;
            }
        }
        return true;
    }

    public void apply() {
        if (this.points != null) {
            for (Node n : this.points.keySet()) {
                NodeView nv = this.view.getNodeView(n);
                Point2D.Double p = this.points.get(n);
                nv.setXPosition(p.getX());
                nv.setYPosition(p.getY());
            }
        }
        this.view.setZoom(this.scaleFactor);
        this.view.setCenter(this.center.getX(), this.center.getY());
        this.view.updateView();
        if (this.anchors != null) {
            for (Edge e : this.anchors.keySet()) {
                EdgeView ev = this.view.getEdgeView(e);
                ev.getBend().setHandles(this.anchors.get(e));
                ev.setLineType(this.linetype.get(e));
            }
        }
    }
}

