/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import ding.view.ContentChangeListener;
import ding.view.DGraphView;
import ding.view.ViewportChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class BirdsEyeView
extends Component {
    private final double[] m_extents = new double[4];
    private DGraphView m_view;
    private final ContentChangeListener m_cLis = new InnerContentChangeListener();
    private final ViewportChangeListener m_vLis = new InnerViewportChangeListener();
    private Image m_img = null;
    private boolean m_contentChanged = false;
    private double m_myXCenter;
    private double m_myYCenter;
    private double m_myScaleFactor;
    private int m_viewWidth;
    private int m_viewHeight;
    private double m_viewXCenter;
    private double m_viewYCenter;
    private double m_viewScaleFactor;
    private Component m_desktopView;
    private int m_currMouseButton = 0;
    private int m_lastXMousePos = 0;
    private int m_lastYMousePos = 0;

    public BirdsEyeView(DGraphView view) {
        this(view, null);
    }

    public BirdsEyeView(DGraphView view, Component desktopView) {
        this.m_desktopView = desktopView;
        this.addMouseListener(new InnerMouseListener());
        this.addMouseMotionListener(new InnerMouseMotionListener());
        this.changeView(view);
    }

    public void changeView(DGraphView view) {
        this.destroy();
        this.m_view = view;
        if (this.m_view != null) {
            this.m_view.addContentChangeListener(this.m_cLis);
            this.m_view.addViewportChangeListener(this.m_vLis);
            this.updateBounds();
            Point2D pt = this.m_view.getCenter();
            this.m_viewXCenter = pt.getX();
            this.m_viewYCenter = pt.getY();
            this.m_viewScaleFactor = this.m_view.getZoom();
            this.m_contentChanged = true;
        }
        this.repaint();
    }

    private void updateBounds() {
        Rectangle2D viewable = this.getViewableRect();
        this.m_viewWidth = (int)viewable.getWidth();
        this.m_viewHeight = (int)viewable.getHeight();
        Rectangle2D viewableInView = this.getViewableRectInView(viewable);
        this.m_viewXCenter = viewableInView.getX() + viewableInView.getWidth() / 2.0;
        this.m_viewYCenter = viewableInView.getY() + viewableInView.getHeight() / 2.0;
    }

    private Rectangle2D getViewableRectInView(Rectangle2D viewable) {
        if (this.m_view == null || this.m_view.getCanvas() == null || this.m_view.getCanvas().m_grafx == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        double[] origin = new double[]{viewable.getX(), viewable.getY()};
        this.m_view.xformComponentToNodeCoords(origin);
        double[] destination = new double[]{viewable.getX() + viewable.getWidth(), viewable.getY() + viewable.getHeight()};
        this.m_view.xformComponentToNodeCoords(destination);
        Rectangle2D.Double result = new Rectangle2D.Double(origin[0], origin[1], destination[0] - origin[0], destination[1] - origin[1]);
        return result;
    }

    private Rectangle2D getViewableRect() {
        if (this.m_view == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        if (this.m_desktopView == null) {
            Rectangle r = this.m_view.getComponent().getBounds();
            return new Rectangle2D.Double(r.x, r.y, r.width, r.height);
        }
        Rectangle desktopRect = this.m_desktopView.getBounds();
        if (this.m_desktopView.isShowing()) {
            Point s = this.m_desktopView.getLocationOnScreen();
            desktopRect.x = s.x;
            desktopRect.y = s.y;
        }
        Rectangle viewRect = this.m_view.getComponent().getBounds();
        if (this.m_view.getComponent().isShowing()) {
            Point s = this.m_view.getComponent().getLocationOnScreen();
            viewRect.x = s.x;
            viewRect.y = s.y;
        }
        desktopRect.x -= viewRect.x;
        desktopRect.y -= viewRect.y;
        viewRect.x = 0;
        viewRect.y = 0;
        Rectangle viewable = desktopRect.intersection(viewRect);
        return viewable;
    }

    public void destroy() {
        if (this.m_view == null) {
            return;
        }
        this.m_view.removeContentChangeListener(this.m_cLis);
        this.m_view.removeViewportChangeListener(this.m_vLis);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 0 && height > 0) {
            this.m_img = new BufferedImage(width, height, 2);
        }
        this.m_contentChanged = true;
    }

    public void update(Graphics g) {
        if (this.m_img == null) {
            return;
        }
        if (this.m_view == null) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        this.updateBounds();
        if (this.m_contentChanged) {
            if (this.m_view.getExtents(this.m_extents)) {
                this.m_myXCenter = (this.m_extents[0] + this.m_extents[2]) / 2.0;
                this.m_myYCenter = (this.m_extents[1] + this.m_extents[3]) / 2.0;
                this.m_myScaleFactor = 0.8 * Math.min((double)this.getWidth() / (this.m_extents[2] - this.m_extents[0]), (double)this.getHeight() / (this.m_extents[3] - this.m_extents[1]));
            } else {
                this.m_myXCenter = 0.0;
                this.m_myYCenter = 0.0;
                this.m_myScaleFactor = 1.0;
            }
            this.m_view.drawSnapshot(this.m_img, this.m_view.getGraphLOD(), this.m_view.m_backgroundCanvas.getBackground(), this.m_myXCenter, this.m_myYCenter, this.m_myScaleFactor);
            this.m_contentChanged = false;
        }
        g.drawImage(this.m_img, 0, 0, null);
        double rectWidth = this.m_myScaleFactor * ((double)this.m_viewWidth / this.m_viewScaleFactor);
        double rectHeight = this.m_myScaleFactor * ((double)this.m_viewHeight / this.m_viewScaleFactor);
        double rectXCenter = (double)this.getWidth() / 2.0 + this.m_myScaleFactor * (this.m_viewXCenter - this.m_myXCenter);
        double rectYCenter = (double)this.getHeight() / 2.0 + this.m_myScaleFactor * (this.m_viewYCenter - this.m_myYCenter);
        Rectangle2D.Double rect = new Rectangle2D.Double(rectXCenter - rectWidth / 2.0, rectYCenter - rectHeight / 2.0, rectWidth, rectHeight);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(new Color(63, 63, 255, 63));
        g2.fill(rect);
        g2.setColor(Color.blue);
        g2.draw(rect);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    private final class InnerMouseMotionListener
    implements MouseMotionListener {
        private InnerMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (BirdsEyeView.this.m_currMouseButton == 1) {
                int currX = e.getX();
                int currY = e.getY();
                double deltaX = (double)(currX - BirdsEyeView.this.m_lastXMousePos) / BirdsEyeView.this.m_myScaleFactor;
                double deltaY = (double)(currY - BirdsEyeView.this.m_lastYMousePos) / BirdsEyeView.this.m_myScaleFactor;
                BirdsEyeView.this.m_lastXMousePos = currX;
                BirdsEyeView.this.m_lastYMousePos = currY;
                if (BirdsEyeView.this.m_view != null) {
                    Point2D pt = BirdsEyeView.this.m_view.getCenter();
                    BirdsEyeView.this.m_view.setCenter(pt.getX() + deltaX, pt.getY() + deltaY);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private final class InnerMouseListener
    implements MouseListener {
        private InnerMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                BirdsEyeView.this.m_currMouseButton = 1;
                BirdsEyeView.this.m_lastXMousePos = e.getX();
                BirdsEyeView.this.m_lastYMousePos = e.getY();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1 && BirdsEyeView.this.m_currMouseButton == 1) {
                BirdsEyeView.this.m_currMouseButton = 0;
            }
        }
    }

    private final class InnerViewportChangeListener
    implements ViewportChangeListener {
        private InnerViewportChangeListener() {
        }

        public void viewportChanged(int w, int h, double newXCenter, double newYCenter, double newScaleFactor) {
            BirdsEyeView.this.m_viewWidth = w;
            BirdsEyeView.this.m_viewHeight = h;
            BirdsEyeView.this.m_viewXCenter = newXCenter;
            BirdsEyeView.this.m_viewYCenter = newYCenter;
            BirdsEyeView.this.m_viewScaleFactor = newScaleFactor;
            BirdsEyeView.this.repaint();
        }
    }

    private final class InnerContentChangeListener
    implements ContentChangeListener {
        private InnerContentChangeListener() {
        }

        public void contentChanged() {
            BirdsEyeView.this.m_contentChanged = true;
            BirdsEyeView.this.repaint();
        }
    }
}

