/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.undo;

import cytoscape.logger.CyLogger;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.undo.CyUndo;
import java.awt.event.ActionEvent;
import javax.swing.event.MenuEvent;
import javax.swing.undo.CannotUndoException;

public class RedoAction
extends CytoscapeAction {
    private static CyLogger logger = CyLogger.getLogger(RedoAction.class);

    public RedoAction() {
        super("Redo");
        this.setAcceleratorCombo(89, 2);
        this.setPreferredMenu("Edit");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (CyUndo.undoManager.canRedo()) {
                CyUndo.undoManager.redo();
            }
        }
        catch (CannotUndoException ex) {
            logger.warn("Unable to redo: " + ex.getMessage(), ex);
        }
    }

    public void menuSelected(MenuEvent e) {
        if (CyUndo.undoManager.canRedo()) {
            this.setEnabled(true);
            this.putValue("Name", CyUndo.undoManager.getRedoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Redo");
        }
    }

    public void menuDeselected(MenuEvent e) {
        this.setEnabled(true);
    }
}

