/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.swing;

import cytoscape.Cytoscape;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterHistoryJList
extends JList {
    private FilterField filterField;
    private int DEFAULT_FIELD_WIDTH = 20;

    public FilterHistoryJList() {
        this.setModel((ListModel)new FilterModel());
        this.filterField = new FilterField(this.DEFAULT_FIELD_WIDTH);
        this.filterField.textField.requestFocus();
    }

    public void setModel(ListModel m) {
        if (!(m instanceof FilterModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(m);
    }

    public void addItem(Object o) {
        ((FilterModel)this.getModel()).addElement(o);
    }

    public FilterField getFilterField() {
        return this.filterField;
    }

    class PrevSearchAction
    extends AbstractAction {
        String term;

        public PrevSearchAction(String s) {
            this.term = s;
            this.putValue("Name", this.term);
        }

        public String toString() {
            return this.term;
        }

        public void actionPerformed(ActionEvent e) {
            FilterHistoryJList.this.getFilterField().textField.setText(this.term);
        }
    }

    class FilterField
    extends JComponent
    implements DocumentListener,
    ActionListener {
        LinkedList prevSearches;
        JTextField textField;
        JButton prevSearchButton;
        JPopupMenu prevSearchMenu;

        public FilterField(int width) {
            this.setLayout(new BorderLayout());
            this.textField = new JTextField(width);
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addActionListener(this);
            this.prevSearchButton = new JButton(new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_search.png")));
            this.prevSearchButton.setBorder(null);
            this.prevSearchButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent me) {
                    FilterField.this.popMenu(me.getX(), me.getY());
                }
            });
            this.add((Component)this.prevSearchButton, "West");
            this.add((Component)this.textField, "Center");
            this.prevSearches = new LinkedList();
        }

        public void popMenu(int x, int y) {
            this.prevSearchMenu = new JPopupMenu();
            Iterator it = this.prevSearches.iterator();
            while (it.hasNext()) {
                this.prevSearchMenu.add(new PrevSearchAction(it.next().toString()));
            }
            this.prevSearchMenu.show(this.prevSearchButton, x, y);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.textField) {
                this.prevSearches.addFirst(this.textField.getText());
                if (this.prevSearches.size() > 10) {
                    this.prevSearches.removeLast();
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
            ((FilterModel)FilterHistoryJList.this.getModel()).refilter();
        }

        public void insertUpdate(DocumentEvent e) {
            ((FilterModel)FilterHistoryJList.this.getModel()).refilter();
        }

        public void removeUpdate(DocumentEvent e) {
            ((FilterModel)FilterHistoryJList.this.getModel()).refilter();
        }
    }

    class FilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        public int getSize() {
            return this.filterItems.size();
        }

        public void addElement(Object o) {
            this.items.add(o);
            this.refilter();
        }

        private void refilter() {
            this.filterItems.clear();
            String term = FilterHistoryJList.this.getFilterField().textField.getText();
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i).toString().indexOf(term, 0) == -1) continue;
                this.filterItems.add(this.items.get(i));
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

