/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.readers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.synonyms.Thesaurus;
import cytoscape.logger.CyLogger;
import java.io.BufferedReader;
import java.io.File;
import java.util.Vector;

public class AnnotationFlatFileReader {
    Annotation annotation;
    String annotationType;
    String species;
    String curator;
    String filename;
    File directoryAbsolute;
    String fullText;
    String[] lines;
    Vector extractedLines;
    boolean flip;
    Thesaurus thr;

    public AnnotationFlatFileReader(File file) throws Exception {
        this(file.getPath(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AnnotationFlatFileReader(BufferedReader rd, Thesaurus th, boolean isFlip) throws Exception {
        block6: {
            this.fullText = null;
            this.extractedLines = new Vector();
            this.thr = th;
            this.flip = isFlip;
            String curLine = null;
            try {
                while (null != (curLine = rd.readLine())) {
                    this.extractedLines.add(curLine);
                }
                Object var6_5 = null;
                if (rd == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (rd != null) {
                    rd.close();
                }
                throw throwable;
            }
            rd.close();
        }
        Object[] entireFile = this.extractedLines.toArray();
        this.lines = new String[entireFile.length];
        System.arraycopy(entireFile, 0, this.lines, 0, this.lines.length);
        this.parseHeader(this.lines[0]);
        this.parse();
    }

    public AnnotationFlatFileReader(String filename, Thesaurus th) throws Exception {
        this.filename = filename;
        this.thr = th;
        try {
            if (filename.trim().startsWith("jar://")) {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else if (filename.trim().startsWith("http://")) {
                TextHttpReader reader = new TextHttpReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else {
                TextFileReader reader = new TextFileReader(filename);
                reader.read();
                this.fullText = reader.getText();
            }
        }
        catch (Exception e0) {
            CyLogger.getLogger().warn("-- Exception while reading ontology flat file " + filename, e0);
            return;
        }
        this.lines = this.fullText.split("\n");
        this.parseHeader(this.lines[0]);
        this.parse();
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public void parseHeader(String firstLine) throws Exception {
        String[] tokens = firstLine.trim().split("\\)");
        String errorMsg = "error in AnnotationFlatFileReader.parseHeader ().\n";
        errorMsg = errorMsg + "First line of " + this.filename + " must have form:\n";
        errorMsg = errorMsg + "   (species=Homo sapiens) (type=Biological Process) (curator=GO)\n";
        errorMsg = errorMsg + "instead found:\n";
        errorMsg = errorMsg + "   " + firstLine + "\n";
        if (tokens.length != 3) {
            throw new IllegalArgumentException(errorMsg);
        }
        for (int i = 0; i < tokens.length; ++i) {
            String[] subTokens = tokens[i].split("=");
            if (subTokens.length != 2) {
                throw new IllegalArgumentException(errorMsg);
            }
            String name = subTokens[0].trim();
            String value = subTokens[1].trim();
            if (name.equalsIgnoreCase("(species")) {
                this.species = value;
                continue;
            }
            if (name.equalsIgnoreCase("(type")) {
                this.annotationType = value;
                continue;
            }
            if (!name.equalsIgnoreCase("(curator")) continue;
            this.curator = value;
        }
    }

    private void parse() throws Exception {
        this.annotation = new Annotation(this.species, this.annotationType, this.curator);
        String key = null;
        for (int i = 1; i < this.lines.length; ++i) {
            String line = this.lines[i];
            if (line.length() < 2) continue;
            String[] tokens = line.split("=");
            String entityName = tokens[0].trim();
            int id = this.stringToInt(tokens[1].trim());
            if (!this.flip) {
                this.annotation.add(entityName, id);
                String[] syno = this.thr.getAllCommonNames(entityName);
                for (int idx = 0; idx < syno.length; ++idx) {
                    this.annotation.add(syno[idx], id);
                }
                continue;
            }
            if (!this.flip || (key = this.thr.getNodeLabel(entityName)) == null) continue;
            this.annotation.add(key, id);
        }
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

