/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileInfo;
import com.install4j.api.context.InstallationComponentSetup;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.context.WizardContext;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.Script;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class ContextImpl
implements Context {
    protected ScreenExecutor screenExecutor;
    private List installationComponentSetups = new ArrayList();
    private List launcherSetups = new ArrayList();
    private String languageId;
    private boolean languageInitialized = false;
    private InstallationProperties installationProperties;
    private boolean cancelling = false;
    private boolean askingForCancel = false;
    private final Object cancelWaiter = new Object();
    private static ContextImpl singleContextImpl;
    protected Set listeners = new HashSet();
    private Action currentAction;
    private boolean errorOccured = false;
    private Set hiddenVariables = new HashSet();

    public static ContextImpl getSingleContextImpl() {
        return singleContextImpl;
    }

    public static void immediateExit(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                System.out.flush();
                System.err.flush();
                System.exit(n);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void setSingleContextImpl(ContextImpl contextImpl) {
        if (singleContextImpl != null) {
            throw new UnsupportedOperationException("only one context impl can exist");
        }
        singleContextImpl = contextImpl;
    }

    public ContextImpl(ScreenExecutor screenExecutor) {
        Object object;
        Object object2;
        this.screenExecutor = screenExecutor;
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        List list = installerConfig.getComponents();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (ComponentConfig)object3.next();
            object = new InstallationComponentSetupImpl((ComponentConfig)object2);
            this.installationComponentSetups.add(object);
        }
        object3 = installerConfig.getLaunchers();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (LauncherConfig)object2.next();
            LauncherSetupImpl launcherSetupImpl = new LauncherSetupImpl((LauncherConfig)object);
            this.launcherSetups.add(launcherSetupImpl);
        }
        ContextImpl.setSingleContextImpl(this);
        this.addInstallerEventListener(Logger.getInstance());
    }

    public abstract void applyToScreen(Screen var1);

    public abstract List getScreenConfigs();

    protected abstract boolean performActionInt(Action var1) throws UserCanceledException;

    protected abstract void rollbackActionInt(Action var1);

    public Object runScript(ScriptProperty scriptProperty, Bean bean, Object[] objectArray) throws Exception {
        if (scriptProperty != null && !scriptProperty.getValue().equals("")) {
            return ((Script)Class.forName(scriptProperty.getValue()).newInstance()).evaluate(this, bean, objectArray);
        }
        return null;
    }

    public boolean runBooleanScript(String string, Bean bean) {
        return this.runBooleanScript(string, bean, null);
    }

    public boolean runBooleanScript(String string, Bean bean, Object[] objectArray) {
        try {
            Boolean bl = (Boolean)this.runScript(new ScriptProperty(string), bean, objectArray);
            if (bl == null) {
                return true;
            }
            return bl;
        }
        catch (Exception exception) {
            InstallerUtil.reportException(exception);
            return false;
        }
    }

    public File getDestinationFile(File file) {
        if (file == null) {
            return null;
        }
        return this.getDestinationFile(file.getPath());
    }

    public File getDestinationFile(String string) {
        if (string == null) {
            return null;
        }
        return this.getDestinationFileInfo(string).getDestinationFile();
    }

    public FileInfo getDestinationFileInfo(String string) {
        String string2;
        FileInfoImpl fileInfoImpl = new FileInfoImpl();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (new File(string).isAbsolute()) {
            fileInfoImpl.relativeFilePath = string;
            fileInfoImpl.rootUnresolved = "";
            return fileInfoImpl;
        }
        if (Util.isMacosInstaller() && string.startsWith(".install4j")) {
            fileInfoImpl.relativeFilePath = installerConfig.getMacSpecificConfig().getRuntimeDirParent() + string;
            return fileInfoImpl;
        }
        String string3 = string;
        if (installerConfig.getType().equals("macos") && installerConfig.getMacSpecificConfig().isSingleBundle() && string.startsWith(string2 = installerConfig.getMacSpecificConfig().getRuntimeDirParent())) {
            string3 = string.substring(string2.length());
        }
        if (string3.startsWith(".i4j_external_")) {
            int n = string3.indexOf(47);
            if (n == -1) {
                n = string3.indexOf(92);
            }
            if (n != -1) {
                String string4 = string3.substring(".i4j_external_".length(), n);
                fileInfoImpl.relativeFilePath = string3.substring(n + 1);
                fileInfoImpl.rootUnresolved = installerConfig.getRootById(string4);
                return fileInfoImpl;
            }
        }
        fileInfoImpl.relativeFilePath = string;
        return fileInfoImpl;
    }

    public String getLanguageId() {
        if (!this.languageInitialized) {
            Object object;
            this.languageInitialized = true;
            String string = System.getProperty("install4j.language");
            if (string != null) {
                this.setLanguageId(string);
            }
            if ((object = this.getVariable("sys.languageId")) != null && object instanceof String) {
                this.setLanguageId((String)object);
            }
            InstallerVariables.registerVariableProvider("sys.languageId", new InstallerVariables.VariableProvider(){

                public Object getVariable() {
                    return ContextImpl.this.getLanguageId();
                }

                public void setVariable(Object object) {
                }
            });
            this.registerResponseFileVariable("sys.languageId");
        }
        return this.languageId;
    }

    public String getMessage(String string) throws MissingResourceException {
        return Messages.getMessages().getString(string);
    }

    public void setLanguageId(String string) {
        if (InstallerConfig.getCurrentInstance().getLanguageById(string) == null) {
            throw new RuntimeException("The language \"" + string + "\" is not available.");
        }
        this.languageId = string;
    }

    public File getInstallationDirectory() {
        return InstallerConfig.getCurrentInstance().getInstallationDirectory();
    }

    public Collection getLaunchers() {
        return this.launcherSetups;
    }

    public LauncherSetup getLauncherById(String string) {
        Iterator iterator = this.launcherSetups.iterator();
        while (iterator.hasNext()) {
            LauncherSetup launcherSetup = (LauncherSetup)iterator.next();
            if (!launcherSetup.getId().equals(string)) continue;
            return launcherSetup;
        }
        return null;
    }

    public Collection getInstallationComponents() {
        return this.installationComponentSetups;
    }

    public InstallationComponentSetup getInstallationComponentById(String string) {
        Iterator iterator = this.installationComponentSetups.iterator();
        while (iterator.hasNext()) {
            InstallationComponentSetup installationComponentSetup = (InstallationComponentSetup)iterator.next();
            if (!installationComponentSetup.getId().equals(string)) continue;
            return installationComponentSetup;
        }
        return null;
    }

    public String getCompilerVariable(String string) {
        return (String)InstallerConfig.getCurrentInstance().getCompilerVariables().get(string);
    }

    public boolean isUnattended() {
        return this.screenExecutor.isUnattended();
    }

    public boolean isConsole() {
        return this.screenExecutor.isConsole();
    }

    public String getApplicationId() {
        return InstallerConfig.getCurrentInstance().getApplicationId();
    }

    public String getAddOnApplicationId() {
        return InstallerConfig.getCurrentInstance().getAddonAppId();
    }

    public void goForward(int n, boolean bl, boolean bl2) {
        this.screenExecutor.getCommandSink().returnToController(new GoForwardCommand(n, bl, bl2));
    }

    public void goBackInHistory(int n) {
        this.screenExecutor.getCommandSink().returnToController(new GoBackCommand(n, true));
    }

    public void goBack(int n) {
        this.screenExecutor.getCommandSink().returnToController(new GoBackCommand(n, false));
    }

    public void gotoScreen(Screen screen) {
        this.screenExecutor.getCommandSink().returnToController(new GotoScreenCommand(screen));
    }

    public WizardContext getWizardContext() {
        return this.screenExecutor.getWizardContext();
    }

    public Screen[] getScreens() {
        return this.getScreens(null);
    }

    public Screen getFirstScreen(Class clazz) {
        Screen[] screenArray = this.getScreens(clazz);
        if (screenArray.length > 0) {
            return screenArray[0];
        }
        return null;
    }

    public Screen[] getScreens(Class clazz) {
        ArrayList<Screen> arrayList = new ArrayList<Screen>();
        Iterator iterator = this.getScreenConfigs().iterator();
        while (iterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)iterator.next();
            if (!screenBeanConfig.isInstantiated() || clazz != null && screenBeanConfig.getOrInstantiateScreen(false).getClass() != clazz) continue;
            arrayList.add(screenBeanConfig.getOrInstantiateScreen(false));
        }
        return arrayList.toArray(new Screen[arrayList.size()]);
    }

    public Action[] getActions(Screen screen) {
        return this.getActions(null, screen);
    }

    public Action getFirstAction(Class clazz, Screen screen) {
        Action[] actionArray = this.getActions(clazz, screen);
        if (actionArray.length > 0) {
            return actionArray[0];
        }
        return null;
    }

    public Action[] getActions(Class clazz, Screen screen) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getScreenConfigs().iterator();
        while (iterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)iterator.next();
            if (screen != null && (!screenBeanConfig.isInstantiated() || screenBeanConfig.getOrInstantiateScreen(false) != screen)) continue;
            this.addActions(arrayList, screenBeanConfig, clazz, false);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public List getExecutableActionsStartingFrom(Class clazz, Screen screen) {
        boolean bl = screen == null;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getScreenConfigs().iterator();
        while (iterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)iterator.next();
            if (!bl && screenBeanConfig.isInstantiated() && screenBeanConfig.getOrInstantiateScreen(false) == screen) {
                bl = true;
            }
            if (!bl || screenBeanConfig.isInstantiated() && !this.runBooleanScript(screenBeanConfig.getConditionClassName(), screenBeanConfig.getOrInstantiateScreen(false))) continue;
            this.addActions(arrayList, screenBeanConfig, clazz, true);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScreens(boolean bl) {
        InstallerVariables.setReplaceInstallerVariables(false);
        try {
            ScreenBeanConfig screenBeanConfig;
            boolean bl2 = false;
            ScreenBeanConfig screenBeanConfig2 = null;
            Iterator iterator = this.getScreenConfigs().iterator();
            while (iterator.hasNext()) {
                screenBeanConfig = (ScreenBeanConfig)iterator.next();
                boolean bl3 = this.registerActions(screenBeanConfig, bl2, bl);
                if (bl3 && !bl2) {
                    screenBeanConfig2 = screenBeanConfig;
                }
                bl2 = bl3;
            }
            iterator = this.getScreenConfigs().iterator();
            while (iterator.hasNext()) {
                screenBeanConfig = (ScreenBeanConfig)iterator.next();
                this.initActions(screenBeanConfig);
            }
            boolean bl4 = false;
            iterator = this.getScreenConfigs().iterator();
            while (iterator.hasNext()) {
                Screen screen;
                ScreenBeanConfig screenBeanConfig3 = (ScreenBeanConfig)iterator.next();
                if (screenBeanConfig3 == screenBeanConfig2) {
                    bl4 = true;
                }
                if (screenBeanConfig3.isInstantiated() || (screen = screenBeanConfig3.getOrInstantiateScreen(bl2 && bl4)) == null) continue;
                this.screenExecutor.register(screen, screenBeanConfig3);
            }
        }
        finally {
            InstallerVariables.setReplaceInstallerVariables(true);
        }
    }

    private void initActions(ScreenBeanConfig screenBeanConfig) {
        Iterator iterator = screenBeanConfig.getActionConfigs().iterator();
        while (iterator.hasNext()) {
            Action action;
            ActionBeanConfig actionBeanConfig = (ActionBeanConfig)iterator.next();
            if (actionBeanConfig.isInitialized() || (action = actionBeanConfig.getOrInstantiateAction(true)) == null) continue;
            action.init(this);
            actionBeanConfig.setInitialized(true);
        }
    }

    private boolean registerActions(ScreenBeanConfig screenBeanConfig, boolean bl, boolean bl2) {
        Iterator iterator = screenBeanConfig.getActionConfigs().iterator();
        while (iterator.hasNext()) {
            ActionBeanConfig actionBeanConfig = (ActionBeanConfig)iterator.next();
            if (actionBeanConfig.isInstantiated()) continue;
            Action action = actionBeanConfig.getOrInstantiateAction(bl);
            if (!bl2 || !(action instanceof InstallFilesAction)) continue;
            bl = true;
        }
        return bl;
    }

    private void addActions(ArrayList arrayList, ScreenBeanConfig screenBeanConfig, Class clazz, boolean bl) {
        Iterator iterator = screenBeanConfig.getActionConfigs().iterator();
        while (iterator.hasNext()) {
            ActionBeanConfig actionBeanConfig = (ActionBeanConfig)iterator.next();
            if (!actionBeanConfig.isInstantiated() || clazz != null && actionBeanConfig.getOrInstantiateAction(false).getClass() != clazz) continue;
            Action action = actionBeanConfig.getOrInstantiateAction(false);
            if (bl && !this.runBooleanScript(actionBeanConfig.getConditionClassName(), action)) continue;
            arrayList.add(action);
        }
    }

    public ProgressInterface getProgressInterface() {
        return this.screenExecutor.getProgressInterface();
    }

    public void setCancelling() {
        this.cancelling = true;
        this.setAskingForCancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelling() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object object = this.cancelWaiter;
            synchronized (object) {
                if (this.askingForCancel) {
                    try {
                        this.cancelWaiter.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
        return this.cancelling;
    }

    protected void cleanup() {
        Logger.getInstance().info(null, "cleaning up");
        ProgressInterface progressInterface = this.getProgressInterface();
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusRunProgram"));
        progressInterface.setPercentCompleted(0);
        progressInterface.setDetailMessage(" ");
        FileInstaller.getInstance().cleanup(progressInterface);
        if (InstallerUtil.isWindows()) {
            ShellLink.uninitialize();
        }
    }

    public void handleCriticalException(Throwable throwable) {
        InstallerUtil.reportException(throwable);
        this.cleanup();
        ContextImpl.immediateExit(1);
    }

    public InstallationProperties getInstallationProperties() {
        if (this.installationProperties == null) {
            this.installationProperties = new InstallationProperties(this.getRuntimeDirectory());
        }
        return this.installationProperties;
    }

    public void setRollback() {
        this.screenExecutor.setRollback();
    }

    public void finish(int n) {
        this.cleanup();
        this.fireInstallerEvent(new InstallerEvent(this, this, EventType.FINISHED, true));
        this.exit(n);
    }

    public boolean checkStart() {
        Iterator iterator = this.installationComponentSetups.iterator();
        while (iterator.hasNext()) {
            InstallationComponentSetupImpl installationComponentSetupImpl = (InstallationComponentSetupImpl)iterator.next();
            installationComponentSetupImpl.initVariable();
        }
        return InstallerUtil.checkJavaVersion();
    }

    public Object getVariable(String string) {
        return InstallerVariables.getVariable(string);
    }

    public boolean getBooleanVariable(String string) {
        return Boolean.TRUE.equals(this.getVariable(string));
    }

    public void setVariable(String string, Object object) {
        if (InstallerUtil.DEBUG && !this.hiddenVariables.contains(string)) {
            System.out.println("set " + InstallerUtil.getVerboseVariableDefinition(string, object));
        }
        InstallerVariables.setVariable(string, object);
        this.variableChanged(string);
    }

    protected void variableChanged(String string) {
        this.fireInstallerEvent(new InstallerVariableEvent(this, this, string));
    }

    public Set getVariableNames() {
        return InstallerVariables.getVariableNames();
    }

    public void registerResponseFileVariable(String string) {
        InstallerVariables.registerResponseFileVariable(string);
    }

    public void registerHiddenVariable(String string) {
        this.hiddenVariables.add(string);
    }

    public Set getHiddenVariables() {
        return this.hiddenVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAskingForCancel(boolean bl) {
        Object object = this.cancelWaiter;
        synchronized (object) {
            this.askingForCancel = bl;
            if (!bl) {
                this.cancelWaiter.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAction(Action action) throws UserCanceledException {
        boolean bl = false;
        try {
            this.currentAction = action;
            this.fireInstallerEvent(new InstallerEvent(action, this, EventType.BEFORE_EXECUTE_ACTION, true));
            boolean bl2 = bl = this.performActionInt(action);
            return bl2;
        }
        catch (UserCanceledException userCanceledException) {
            throw userCanceledException;
        }
        catch (Exception exception) {
            InstallerUtil.reportException(exception);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.fireInstallerEvent(new InstallerEvent(action, this, EventType.AFTER_EXECUTE_ACTION, bl));
            this.currentAction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackAction(Action action) {
        try {
            this.fireInstallerEvent(new InstallerEvent(action, this, EventType.BEFORE_ROLLBACK_ACTION, true));
            this.currentAction = action;
            this.rollbackActionInt(action);
        }
        finally {
            this.fireInstallerEvent(new InstallerEvent(action, this, EventType.AFTER_ROLLBACK_ACTION, true));
            this.currentAction = null;
        }
    }

    public void fireInstallerEvent(InstallerEvent installerEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            InstallerEventListener installerEventListener = (InstallerEventListener)iterator.next();
            installerEventListener.installerEvent(installerEvent);
        }
    }

    public void addInstallerEventListener(InstallerEventListener installerEventListener) {
        this.listeners.add(installerEventListener);
    }

    public void removeInstallerEventListener(InstallerEventListener installerEventListener) {
        this.listeners.remove(installerEventListener);
    }

    public Object getEventSource() {
        if (this.currentAction != null) {
            return this.currentAction;
        }
        return this;
    }

    public File getExternalFile(ExternalFile externalFile, boolean bl) {
        if (externalFile == null || externalFile.getPath().trim().length() == 0) {
            return null;
        }
        return new File(this.getRuntimeDirectory(), externalFile.getPath());
    }

    protected final File getRuntimeDirectory() {
        return this.getDestinationFile(".install4j");
    }

    public void setErrorOccured(boolean bl) {
        this.errorOccured = bl;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void exit(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                ContextImpl.this.screenExecutor.closeWindows();
                System.exit(n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class FileInfoImpl
    implements FileInfo {
        private String rootUnresolved;
        private String relativeFilePath;

        public File getDestinationFile() {
            String string = this.getRootResolvedString();
            if (string == null) {
                return null;
            }
            if (string.equals("")) {
                return new File(this.relativeFilePath);
            }
            return new File(string, this.relativeFilePath);
        }

        public String getRootUnresolved() {
            return this.rootUnresolved;
        }

        public File getRootResolved() {
            String string = this.getRootResolvedString();
            if (string == null) {
                return null;
            }
            return new File(string);
        }

        private String getRootResolvedString() {
            if (this.rootUnresolved == null) {
                return ContextImpl.this.getInstallationDirectory().getAbsolutePath();
            }
            try {
                return InstallerVariables.replaceVariables(this.rootUnresolved).replace('/', File.separatorChar).replace('\\', File.separatorChar);
            }
            catch (InstallerVariables.UndefinedVariableException undefinedVariableException) {
                return null;
            }
        }

        public String getRelativeFilePath() {
            return this.relativeFilePath;
        }
    }

    public static class InstallationComponentSetupImpl
    implements InstallationComponentSetup {
        public static final String VARIABLE_PREFIX = "sys.component.";
        private ComponentConfig componentConfig;

        public InstallationComponentSetupImpl(ComponentConfig componentConfig) {
            this.componentConfig = componentConfig;
        }

        public boolean isSelected() {
            return this.componentConfig.isSelected();
        }

        public void setSelected(boolean bl) {
            this.componentConfig.setSelected(bl);
        }

        public String getName() {
            return this.componentConfig.getName();
        }

        public String getId() {
            return this.componentConfig.getId();
        }

        public void initVariable() {
            String string = VARIABLE_PREFIX + this.getId();
            Object object = InstallerVariables.getVariable(string);
            if (object != null && object instanceof Boolean) {
                this.setSelected((Boolean)object);
            }
            InstallerVariables.registerVariableProvider(string, new InstallerVariables.VariableProvider(){

                public Object getVariable() {
                    return InstallationComponentSetupImpl.this.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                }

                public void setVariable(Object object) {
                    if (object != null && object instanceof Boolean) {
                        InstallationComponentSetupImpl.this.setSelected((Boolean)object);
                    }
                }
            });
            InstallerVariables.registerResponseFileVariable(string);
        }
    }

    public static class LauncherSetupImpl
    implements LauncherSetup {
        private LauncherConfig launcherConfig;

        public LauncherSetupImpl(LauncherConfig launcherConfig) {
            this.launcherConfig = launcherConfig;
        }

        public String getRelativeFileName() {
            if (InstallerUtil.isWindows()) {
                return this.launcherConfig.getFile().replace('/', '\\');
            }
            return this.launcherConfig.getFile().replace('\\', '/');
        }

        public String getId() {
            return this.launcherConfig.getId();
        }

        public LauncherType getType() {
            return this.launcherConfig.getType();
        }

        public String getName() {
            return this.launcherConfig.getName();
        }

        public boolean isExcludeFromMenu() {
            return this.launcherConfig.isExcludeFromMenu();
        }

        public boolean isUninstaller() {
            return this.launcherConfig.isUninstaller();
        }

        public LauncherConfig getLauncherConfig() {
            return this.launcherConfig;
        }
    }
}

