### R code from vignette source 'DSS.Rnw'

###################################################
### code chunk number 1: DSS.Rnw:111-120
###################################################
library(DSS)
counts1=matrix(rnbinom(300, mu=10, size=10), ncol=3)
counts2=matrix(rnbinom(300, mu=50, size=10), ncol=3)
X1=cbind(counts1, counts2) ## these are 100 DE genes
X2=matrix(rnbinom(11400, mu=10, size=10), ncol=6)
X=rbind(X1,X2)
designs=c(0,0,0,1,1,1)
seqData=newSeqCountSet(X, designs)
seqData


###################################################
### code chunk number 2: DSS.Rnw:123-124
###################################################
seqData=estNormFactors(seqData)


###################################################
### code chunk number 3: DSS.Rnw:127-128
###################################################
seqData=estDispersion(seqData)


###################################################
### code chunk number 4: DSS.Rnw:132-134
###################################################
result=waldTest(seqData, 0, 1)
head(result,5)


###################################################
### code chunk number 5: DSS.Rnw:139-140
###################################################
sessionInfo()


