### R code from vignette source 'FindChimeras.Rnw'

###################################################
### code chunk number 1: startup
###################################################
library(DECIPHER)


###################################################
### code chunk number 2: expr1 (eval = FALSE)
###################################################
## output.file <- tempfile()
## command <- paste("java -Xmx1g -jar '",
## "<<path to multiclassifier.jar>>",
## "' --hier_outfile=/dev/null --conf=0 --assign_outfile='",
## output.file,
## "' '",
## "<<path to FASTA file>>",
## "'",
## sep="")
## cat("\n\n", command, "\n\n", sep="")


###################################################
### code chunk number 3: expr2 (eval = FALSE)
###################################################
## system(command)


###################################################
### code chunk number 4: expr3 (eval = FALSE)
###################################################
## dbRef <- dbConnect(SQLite(), '<<path to reference database>>')
## t <- dbGetQuery(dbRef, "select distinct rank, id from DNA group by rank")
## y <- dbGetQuery(dbRef, paste("select distinct id,
## 	count(*) as count from DNA", "where chimera is null group by id"))
## 
## t$count <- 0
## for (i in 1:dim(t)[1])
## t$count[i] <- y$count[which(y$id==t$id[i])]


###################################################
### code chunk number 5: expr4 (eval = FALSE)
###################################################
## r <- readLines(output.file)
## 
## z <- data.frame(id=I(character(length(r))),
## 	row.names=1:length(r))
## confidence <- .51
## for (i in 1:length(r)) {
## 	u <- unlist(strsplit(r[i], "\t"))
## 	
## 	confidenceLevel <- 0
## 	for (k in seq(5, length(u), 3)) {
## 		if (as.numeric(u[k]) < confidence) {
## 			confidenceLevel <- k
## 			break
## 		}
## 	}
## 	
## 	if (confidenceLevel == 0) { # full confidence
## 		r[i] <- paste(u[seq(3, length(u), 3)],
## 			collapse="; ")
## 	} else { # unclassified at some level
## 		r[i] <- paste(u[seq(3, (confidenceLevel - 3), 3)],
## 			collapse="; ")
## 		r[i] <- paste(r[i],
## 			"unclassified",
## 			sep="; ")
## 	}
## 	
## 	index <- grep(r[i],
## 		t$rank,
## 		fixed=TRUE)
## 	
## 	if (length(index) == 0)
## 		z$id[i] <- "unknown_lineage"
## 	else
## 		z$id[i] <- as.character(t$id[index[1]])
## }


###################################################
### code chunk number 6: expr5 (eval = FALSE)
###################################################
## # specify a path for where to write the sequence database
## dbConn <- "<<path to write sequence database>>"
## # OR create the sequence database in memory
## dbConn <- dbConnect(SQLite(), ":memory:")
## Seqs2DB("<<path to FASTA file>>", "FASTA", dbConn, "unknown")


###################################################
### code chunk number 7: expr6 (eval = FALSE)
###################################################
## Add2DB(z, dbConn)


###################################################
### code chunk number 8: expr7 (eval = FALSE)
###################################################
## # full-length sequences
## chimeras <- FindChimeras(dbConn, dbFileReference=dbRef, add2tbl=TRUE,
## 	maxGroupSize=1e4)
## # OR for short-length sequences
## chimeras <- FindChimeras(dbConn, dbFileReference=dbRef, minLength=40,
## 	minSuspectFragments=2, add2tbl=TRUE, maxGroupSize=1e4)


###################################################
### code chunk number 9: sessinfo
###################################################
toLatex(sessionInfo(), locale=FALSE)


