/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import weka.core.Instances;

public class ParentSet
implements Serializable {
    private int[] m_nParents;
    private int m_nNrOfParents = 0;
    private int m_nCardinalityOfParents = 1;

    public int getParent(int n) {
        return this.m_nParents[n];
    }

    public void SetParent(int n, int n2) {
        this.m_nParents[n] = n2;
    }

    public int getNrOfParents() {
        return this.m_nNrOfParents;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.m_nNrOfParents; ++i) {
            if (this.m_nParents[i] != n) continue;
            return true;
        }
        return false;
    }

    public int getCardinalityOfParents() {
        return this.m_nCardinalityOfParents;
    }

    public ParentSet() {
        this.m_nParents = new int[10];
        this.m_nNrOfParents = 0;
        this.m_nCardinalityOfParents = 1;
    }

    public ParentSet(int n) {
        this.m_nParents = new int[n];
        this.m_nNrOfParents = 0;
        this.m_nCardinalityOfParents = 1;
    }

    public ParentSet(ParentSet parentSet) {
        this.m_nNrOfParents = parentSet.m_nNrOfParents;
        this.m_nCardinalityOfParents = parentSet.m_nCardinalityOfParents;
        this.m_nParents = new int[this.m_nNrOfParents];
        for (int i = 0; i < this.m_nNrOfParents; ++i) {
            this.m_nParents[i] = parentSet.m_nParents[i];
        }
    }

    public void maxParentSetSize(int n) {
        this.m_nParents = new int[n];
    }

    public void addParent(int n, Instances instances) {
        if (this.m_nNrOfParents == 10) {
            int[] nArray = new int[50];
            for (int i = 0; i < this.m_nNrOfParents; ++i) {
                nArray[i] = this.m_nParents[i];
            }
            this.m_nParents = nArray;
        }
        this.m_nParents[this.m_nNrOfParents] = n;
        ++this.m_nNrOfParents;
        this.m_nCardinalityOfParents *= instances.attribute(n).numValues();
    }

    public void addParent(int n, int n2, Instances instances) {
        if (this.m_nNrOfParents == 10) {
            int[] nArray = new int[50];
            for (int i = 0; i < this.m_nNrOfParents; ++i) {
                nArray[i] = this.m_nParents[i];
            }
            this.m_nParents = nArray;
        }
        for (int i = this.m_nNrOfParents; i > n2; --i) {
            this.m_nParents[i] = this.m_nParents[i - 1];
        }
        this.m_nParents[n2] = n;
        ++this.m_nNrOfParents;
        this.m_nCardinalityOfParents *= instances.attribute(n).numValues();
    }

    public int deleteParent(int n, Instances instances) {
        int n2;
        for (n2 = 0; this.m_nParents[n2] != n && n2 < this.m_nNrOfParents; ++n2) {
        }
        int n3 = -1;
        if (n2 < this.m_nNrOfParents) {
            n3 = n2;
        }
        if (n2 < this.m_nNrOfParents) {
            while (n2 < this.m_nNrOfParents - 1) {
                this.m_nParents[n2] = this.m_nParents[n2 + 1];
                ++n2;
            }
            --this.m_nNrOfParents;
            this.m_nCardinalityOfParents /= instances.attribute(n).numValues();
        }
        return n3;
    }

    public void deleteLastParent(Instances instances) {
        --this.m_nNrOfParents;
        this.m_nCardinalityOfParents /= instances.attribute(this.m_nParents[this.m_nNrOfParents]).numValues();
    }

    public void copy(ParentSet parentSet) {
        this.m_nCardinalityOfParents = parentSet.m_nCardinalityOfParents;
        this.m_nNrOfParents = parentSet.m_nNrOfParents;
        for (int i = 0; i < this.m_nNrOfParents; ++i) {
            this.m_nParents[i] = parentSet.m_nParents[i];
        }
    }
}

