### R code from vignette source 'ADaCGH2.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: ADaCGH2.Rnw:74-75
###################################################
library(ADaCGH2)


###################################################
### code chunk number 2: ADaCGH2.Rnw:80-81
###################################################
options(width = 70)


###################################################
### code chunk number 3: ADaCGH2.Rnw:96-100
###################################################
if(!file.exists("ADaCGH2_vignette_tmp_dir"))
  dir.create("ADaCGH2_vignette_tmp_dir")
originalDir <- getwd()
setwd("ADaCGH2_vignette_tmp_dir")


###################################################
### code chunk number 4: ADaCGH2.Rnw:117-121
###################################################
fname <- list.files(path = system.file("data", package = "ADaCGH2"),
                     full.names = TRUE, pattern = "inputEx1")
tableChromArray <- inputDataToADaCGHData(filename = fname)
tableChromArray


###################################################
### code chunk number 5: ADaCGH2.Rnw:139-147 (eval = FALSE)
###################################################
## 
## require(multicore)
## parallel(inputDataToADaCGHData(filename = fname), silent = FALSE)
## tableChromArray <- collect()[[1]]
## if(inherits(tableChromArray, "try-error")) {
##   stop("ERROR in input data conversion")
## }
## 


###################################################
### code chunk number 6: ADaCGH2.Rnw:164-165
###################################################
snowfallInit(universeSize = 2, typecluster = "SOCK")


###################################################
### code chunk number 7: ADaCGH2.Rnw:174-175 (eval = FALSE)
###################################################
## help(pSegment)


###################################################
### code chunk number 8: ADaCGH2.Rnw:179-181
###################################################
hs_mad.out <- pSegmentHaarSeg("cghData.RData",
                           "chromData.RData", merging = "MAD")


###################################################
### code chunk number 9: ADaCGH2.Rnw:188-190
###################################################
lapply(hs_mad.out, open)
summary(hs_mad.out[[1]][,])


###################################################
### code chunk number 10: ADaCGH2.Rnw:202-210
###################################################
save(hs_mad.out, file = "hs_mad.out.RData", compress = FALSE)

pChromPlot(outRDataName = "hs_mad.out.RData",
                            cghRDataName = "cghData.RData",
                            chromRDataName = "chromData.RData",
                            posRDataName = "posData.RData",
                            probenamesRDataName = "probeNames.RData",
                            imgheight = 350)


###################################################
### code chunk number 11: ADaCGH2.Rnw:226-232
###################################################
forcghr <- outputToCGHregions(hs_mad.out)
if(require(CGHregions)) {
  regions1 <- CGHregions(forcghr)
  regions1
}



###################################################
### code chunk number 12: ADaCGH2.Rnw:262-283
###################################################
datadir <- system.file("testdata", package = "snapCGH")
targets <- readTargets("targets.txt", path = datadir)
RG1 <- read.maimages(targets$FileName, path = datadir, source = "genepix")



RG1 <- read.clonesinfo("cloneinfo.txt", RG1, path = datadir) ## snapCGH-specific
RG1$printer <- getLayout(RG1$genes)
types <- readSpotTypes("SpotTypes.txt", path = datadir)
RG1$genes$Status <- controlStatus(types, RG1)

RG1$design <- c(-1, -1)


RG2 <- backgroundCorrect(RG1, method = "minimum") ## class RGList
MA <- normalizeWithinArrays(RG2, method = "median") ## class MAList
class(MA)
MA2 <- processCGH(MA, method.of.averaging = mean, ID = "ID") ## class SegList
class(MA2)




###################################################
### code chunk number 13: ADaCGH2.Rnw:295-301
###################################################
tmp <- inputDataToADaCGHData(MAList = MA, na.omit = TRUE)

tmp <- inputDataToADaCGHData(MAList = MA2, na.omit = TRUE, 
                             minNumPerChrom = 4)
                             
                             


###################################################
### code chunk number 14: ADaCGH2.Rnw:324-329
###################################################
targets.limma <- readTargets("targets.txt", path = datadir)
RG.limma <- read.maimages(targets.limma, path = datadir, source="genepix")
RG.limma <- backgroundCorrect(RG.limma, method="normexp", offset=50)
MA.limma <- normalizeWithinArrays(RG.limma)



###################################################
### code chunk number 15: ADaCGH2.Rnw:340-347
###################################################
fclone <- list.files(path = system.file("testdata", package = "snapCGH"),
                     full.names = TRUE, pattern = "cloneinfo.txt")
fclone
tmp <- inputDataToADaCGHData(MAList = MA.limma, 
                             cloneinfo = fclone,
                             na.omit = TRUE)



###################################################
### code chunk number 16: ADaCGH2.Rnw:356-362
###################################################
acloneinfo <- MA$genes
tmp <- inputDataToADaCGHData(MAList = MA.limma, 
                             cloneinfo = acloneinfo,
                             na.omit = TRUE)




###################################################
### code chunk number 17: ADaCGH2.Rnw:374-389
###################################################
sfStop()
load("chromData.RData")
load("posData.RData")
load("cghData.RData")

delete(cghData); rm(cghData)
delete(posData); rm(posData)
delete(chromData); rm(chromData)

lapply(hs_mad.out, delete)
rm(hs_mad.out)

setwd(originalDir)
print(getwd())
Sys.sleep(3)


###################################################
### code chunk number 18: ADaCGH2.Rnw:393-396
###################################################
unlink("ADaCGH2_vignette_tmp_dir", recursive = TRUE)
print(dir())
Sys.sleep(3)


