###############################################################################
## organisms to start with:
## arabidopsis
## celegans
## drosophila
## human
## mouse
## rat
## yeast


###############################################################################
## To generate a fresh DB simply:
## 1) Remove the old DB (rm seqnames.sqlite) AND
## 2) Source this file from extData dir (where we want the DB to appear)
##
##    source("script/makeChrDb.R")
##



###############################################################################
## function to help create and populate a seqnames DB from csv files.
require(RSQLite)

writeTable <- function(specString="Homo_sapiens"){
  con <- dbConnect("SQLite", dbname="seqnames.sqlite")
  tables <- dbListTables(con)
  if(any(specString %in% tables)){
    stop(paste("there is already a",specString,"table"))
  }

  data <- read.csv(paste("dataFiles/",specString,".csv",sep=""))
  message("Creating table: ",specString)
  sqliteWriteTable(con, specString, value = data, row.names = FALSE)
}


###############################################################################
## regenDB() is for 1) creating the tables, 2) reading in the appropriate
## files, and populating the DB.

regenDb <- function(){
  ## list files in the extData/tabfiles dir
  files <- gsub(".csv","",dir("dataFiles/"))
  ## Then for each file, call makeTable
  lapply(files, writeTable) 
}


regenDb()



