#!/bin/sh
#
# To run this script in "batch" mode:
#   ./make_rdas.sh >make_rdas.log 2>&1 &
#

set -e  # Exit immediately if a simple command exits with a non-zero status

## Settings for the rhinos:
PKGNAME="SNPlocs.Hsapiens.dbSNP.20111119"
SNPLOCSFORGE_DIR="/home/hpages/SNPlocsForge"
TOOLS_DIR="$SNPLOCSFORGE_DIR/forged/$PKGNAME/inst/tools"
DOWNLOAD_DIR="$SNPLOCSFORGE_DIR/srcdata/$PKGNAME/downloads"
TMP_DIR="$SNPLOCSFORGE_DIR/srcdata/$PKGNAME/tmp_files"

#SHORTSEQNAMES="1"
SHORTSEQNAMES="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y MT"

R="$HOME/bin/R-2.14"
R_SCRIPT0="source('$TOOLS_DIR/utils.R')"

for chr in $SHORTSEQNAMES; do
    src_file="$DOWNLOAD_DIR/ds_flat_ch${chr}.flat"
    rawsnps_file="$TMP_DIR/ch${chr}_rawsnps.txt"
    echo -n "Extracting raw SNPs from $src_file ... "
    $TOOLS_DIR/filter1_ds_flat.sh <$src_file | \
      $TOOLS_DIR/filter2_ds_flat | \
      $TOOLS_DIR/filter3_ds_flat.sh $chr >$rawsnps_file
    echo "OK"
done

R_SCRIPT="$R_SCRIPT0; loadAndserializeSNPs('$TMP_DIR', '$SHORTSEQNAMES')"
echo "$R_SCRIPT" | $R --vanilla

