### R code from vignette source 'SPADE.Rnw'

###################################################
### code chunk number 1: SPADE.Rnw:17-20
###################################################
sanitize <- function(str) {
  gsub('\\','/',str,fixed=TRUE)
}


###################################################
### code chunk number 2: loadSPADE
###################################################
library(spade)


###################################################
### code chunk number 3: sampleData
###################################################
data_file_path = system.file(file.path("extdata","SimulatedRawData.fcs"), package = "spade")


###################################################
### code chunk number 4: plotSampleData
###################################################
library(flowViz)
fcs <- read.FCS(data_file_path)
plot(transform("marker1"=asinh, "marker2"=asinh) %on% fcs)


###################################################
### code chunk number 5: runSPADE
###################################################
output_dir <- tempdir()
SPADE.driver(data_file_path, out_dir=output_dir, cluster_cols=c("marker1","marker2"))


###################################################
### code chunk number 6: SPADE.Rnw:120-121
###################################################
grep("^libloc",dir(output_dir),invert=TRUE,value=TRUE)


###################################################
### code chunk number 7: plotTrees
###################################################
mst_graph <- igraph:::read.graph(paste(output_dir,"mst.gml",sep=.Platform$file.sep),format="gml")
layout    <- read.table(paste(output_dir,"layout.table",sep=.Platform$file.sep))
SPADE.plot.trees(mst_graph, output_dir, out_dir=paste(output_dir,"pdf",sep=.Platform$file.sep), layout=as.matrix(layout))


###################################################
### code chunk number 8: renameFiles
###################################################
file.rename(file.path(output_dir,"pdf","SimulatedRawData.fcs.density.fcs.cluster.fcs.anno.Rsave.mediansmarker1_clust.pdf"),file.path(output_dir,"pdf","marker1.pdf"));
file.rename(file.path(output_dir,"pdf","SimulatedRawData.fcs.density.fcs.cluster.fcs.anno.Rsave.mediansmarker2_clust.pdf"),file.path(output_dir,"pdf","marker2.pdf"));


