/*
 * Decompiled with CFR 0.152.
 */
package facs.scale;

import facs.scale.Scale;
import facs.scale.ScaleArgument;

public final class LnScale
implements Scale {
    LnScale() {
    }

    public double getValue(double x) {
        return Math.log(x);
    }

    public double getValue(double x, ScaleArgument arg) {
        return this.getValue(x);
    }

    public double unbin(int binIndex, int numBins, double scaleMin, double scaleMax, ScaleArgument arg) {
        double unbinnedValue = 0.0;
        double fractionOfScale = (double)binIndex / (double)numBins;
        double scaleRange = Math.log(scaleMax) - Math.log(scaleMin);
        double valueExponent = Math.log(scaleMin) + fractionOfScale * scaleRange;
        unbinnedValue = Math.exp(valueExponent);
        return unbinnedValue;
    }

    public String cacheKey() {
        return "LnScale";
    }
}

