/*
 * Decompiled with CFR 0.152.
 */
package facs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Properties;

public final class fcsFile {
    private static final String ENCODING = "ISO-8859-1";
    private static final Charset charset = Charset.forName("ISO-8859-1");
    private static final int VERSION_SIZE = 6;
    private static final String FCS_PREFIX = "FCS";
    private static final boolean EXTRACTP = false;
    private CharsetDecoder decoder;
    private File file;
    private boolean isFCSP;
    public String version = null;
    public int textStart = 0;
    public int textEnd = 0;
    public int dataStart = 0;
    public int dataEnd = 0;
    public int analysisStart = 0;
    public int analysisEnd = 0;
    public int supplementalStart = 0;
    public int supplementalEnd = 0;
    public char delimiter = (char)92;
    public String text = null;
    private Properties settings = null;
    public boolean littleEndianP;
    public int parameters = 0;
    public String sampleName = null;
    public String dataType = null;
    public String cytometer = null;
    public String mode = null;
    public String instrument = null;
    public String expTime = null;
    public String expFile = null;
    public String operatorName = null;
    public String operatingSystem = null;
    public String creatorSoftware = null;
    public String cytometerNumber = null;
    public String experimentDate = null;
    public String experimentName = null;
    public String exportTime = null;
    public String exportUser = null;
    public String GUID = null;
    public String windowExtension = null;
    public String threshold = null;
    public String tubeName = null;
    public String spillString = null;
    public boolean applyCompensation = false;
    public String source = null;
    public String nextData = null;
    public String endsText = null;
    public String bTime = null;
    public double timeStep = 0.0;
    public boolean[] isLog = null;
    public int lasers = 0;
    public String[] laserASF = null;
    public String[] laserName = null;
    public String[] laserDelay = null;
    public String[] channelName = null;
    public String[] channelShortname = null;
    public String[] channelGain = null;
    public int[] channelBits = null;
    public String[] channelAmp = null;
    public double[] channelRange = null;
    public String[] channelVoltage = null;
    public boolean[] displayLog = null;
    public double[] ampValue = null;
    public int totalEvents = 0;
    public int[][] eventList = null;

    public fcsFile(String path) throws FileNotFoundException, IOException {
        this(path, false);
    }

    public fcsFile(String path, boolean extractEventsP) throws FileNotFoundException, IOException {
        this(new File(path), extractEventsP);
    }

    public fcsFile(File file) throws FileNotFoundException, IOException {
        this(file, false);
    }

    public fcsFile(File file, boolean extractEventsP) throws FileNotFoundException, IOException {
        this.file = file;
        this.isFCSP = false;
        this.readFile(extractEventsP);
    }

    private void readFile(boolean extractEventsP) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(this.file);
        byte[] versionArray = new byte[6];
        int numRead = fis.read(versionArray);
        if (numRead < 6) {
            this.isFCSP = false;
            fis.close();
            return;
        }
        this.version = new String(versionArray);
        this.isFCSP = this.version.startsWith(FCS_PREFIX);
        if (!this.isFCSP) {
            fis.close();
            return;
        }
        fis.skip(4L);
        byte[] headerArray = new byte[48];
        numRead = fis.read(headerArray);
        if (numRead < 48) {
            this.isFCSP = false;
            fis.close();
            return;
        }
        try {
            this.textStart = Integer.parseInt(new String(headerArray, 0, 8).trim());
            this.textEnd = Integer.parseInt(new String(headerArray, 8, 8).trim());
            this.dataStart = Integer.parseInt(new String(headerArray, 16, 8).trim());
            this.dataEnd = Integer.parseInt(new String(headerArray, 24, 8).trim());
        }
        catch (NumberFormatException nfe) {
            fis.close();
            return;
        }
        try {
            this.analysisStart = Integer.parseInt(new String(headerArray, 32, 8).trim());
            this.analysisEnd = Integer.parseInt(new String(headerArray, 40, 8).trim());
        }
        catch (NumberFormatException nfe) {
            this.analysisStart = 0;
            this.analysisEnd = 0;
        }
        FileChannel fc = fis.getChannel();
        fc.position(0L);
        MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.textEnd + 1);
        this.decoder = charset.newDecoder();
        mbb.limit(this.textStart);
        mbb.position(58);
        CharBuffer other = this.decoder.decode(mbb.slice());
        mbb.limit(this.textEnd + 1);
        mbb.position(this.textStart);
        this.text = this.decoder.decode(mbb.slice()).toString();
        fc.close();
        fis.close();
        this.delimiter = this.text.charAt(0);
        String[] pairs = this.delimiter == '\\' ? this.text.split("[\\\\]") : this.text.split("[" + Character.toString(this.delimiter) + "]");
        int numPairs = (pairs.length - 1) / 2;
        this.settings = new Properties();
        for (int i = 0; i < numPairs; ++i) {
            this.settings.setProperty(pairs[i * 2 + 1].trim(), pairs[i * 2 + 2].trim());
        }
        this.parseSettings();
        if (extractEventsP) {
            this.extractEvents();
        }
    }

    private void parseSettings() {
        int calculatedNumEvents;
        int i;
        if (this.settings == null) {
            return;
        }
        if (this.settings.isEmpty()) {
            return;
        }
        if (this.settings.getProperty("$BEGINSTEXT") != null && this.settings.getProperty("$ENDSTEXT") != null) {
            try {
                this.supplementalStart = Integer.parseInt(this.settings.getProperty("$BEGINSTEXT"));
            }
            catch (NumberFormatException nfe) {
                this.supplementalStart = 0;
            }
            try {
                this.supplementalEnd = Integer.parseInt(this.settings.getProperty("$ENDSTEXT"));
            }
            catch (NumberFormatException nfe) {
                this.supplementalEnd = 0;
            }
        }
        if (this.dataStart == 0 && this.dataEnd == 0) {
            try {
                this.dataStart = Integer.parseInt(this.settings.getProperty("$BEGINDATA"));
            }
            catch (NumberFormatException nfe) {
                this.dataStart = 0;
            }
            try {
                this.dataEnd = Integer.parseInt(this.settings.getProperty("$ENDDATA"));
            }
            catch (NumberFormatException nfe) {
                this.dataEnd = 0;
            }
        }
        if (this.analysisStart == 0 && this.analysisEnd == 0) {
            try {
                this.analysisStart = Integer.parseInt(this.settings.getProperty("$BEGINANALYSIS"));
            }
            catch (NumberFormatException nfe) {
                this.analysisStart = 0;
            }
            try {
                this.analysisEnd = Integer.parseInt(this.settings.getProperty("$ENDANALYSIS"));
            }
            catch (NumberFormatException nfe) {
                this.analysisEnd = 0;
            }
        }
        if (this.settings.getProperty("$PAR") != null) {
            try {
                this.parameters = Integer.parseInt(this.settings.getProperty("$PAR"));
            }
            catch (NumberFormatException nfe) {
                this.parameters = 0;
            }
        }
        if (this.settings.getProperty("$TOT") != null) {
            try {
                this.totalEvents = Integer.parseInt(this.settings.getProperty("$TOT"));
            }
            catch (NumberFormatException nfe2) {
                this.totalEvents = 0;
            }
        }
        this.dataType = this.settings.getProperty("$DATATYPE");
        this.sampleName = this.settings.getProperty("SAMPLE ID");
        if (this.sampleName == null) {
            this.sampleName = this.file.getName();
        }
        this.littleEndianP = false;
        String byteOrder = this.settings.getProperty("$BYTEORD");
        if (byteOrder != null && byteOrder.length() > 0) {
            this.littleEndianP = byteOrder.equals("1,2,3,4");
        }
        this.channelName = new String[this.parameters];
        this.channelShortname = new String[this.parameters];
        this.channelGain = new String[this.parameters];
        this.channelBits = new int[this.parameters];
        this.channelAmp = new String[this.parameters];
        this.channelRange = new double[this.parameters];
        this.channelVoltage = new String[this.parameters];
        this.isLog = new boolean[this.parameters];
        this.ampValue = new double[this.parameters];
        this.displayLog = new boolean[this.parameters];
        this.cytometer = this.settings.getProperty("$CYT");
        this.mode = this.settings.getProperty("$MODE");
        this.instrument = this.settings.getProperty("$INST");
        this.expTime = this.settings.getProperty("$ETIM");
        this.expFile = this.settings.getProperty("$FIL");
        this.operatorName = this.settings.getProperty("$OP");
        this.operatingSystem = this.settings.getProperty("$SYS");
        this.experimentDate = this.settings.getProperty("$DATE");
        this.creatorSoftware = this.settings.getProperty("CREATOR");
        this.cytometerNumber = this.settings.getProperty("CYTNUM");
        this.experimentName = this.settings.getProperty("EXPERIMENT NAME");
        this.exportTime = this.settings.getProperty("EXPORT TIME");
        this.exportUser = this.settings.getProperty("EXPORT USER NAME");
        this.GUID = this.settings.getProperty("GUID");
        this.windowExtension = this.settings.getProperty("WINDOW EXTENSION");
        this.threshold = this.settings.getProperty("THRESHOLD");
        this.spillString = this.settings.getProperty("SPILL");
        this.tubeName = this.settings.getProperty("TUBE NAME");
        this.timeStep = 0.0;
        if (this.settings.getProperty("$TIMESTEP") != null) {
            try {
                this.timeStep = Double.parseDouble(this.settings.getProperty("$TIMESTEP"));
            }
            catch (NumberFormatException nfe3) {
                this.timeStep = 0.0;
            }
        }
        this.source = this.settings.getProperty("$SRC");
        this.endsText = this.settings.getProperty("$ENDSTEXT");
        this.nextData = this.settings.getProperty("$NEXTDATA");
        this.bTime = this.settings.getProperty("$BTIM");
        this.applyCompensation = false;
        String applyString = this.settings.getProperty("APPLY COMPENSATION");
        if (applyString != null && applyString.equalsIgnoreCase("true")) {
            this.applyCompensation = true;
        }
        this.lasers = 0;
        for (i = 1; i <= this.settings.size(); ++i) {
            if (this.settings.getProperty("LASER" + i + "NAME") == null) continue;
            ++this.lasers;
        }
        this.laserASF = new String[this.lasers];
        this.laserDelay = new String[this.lasers];
        this.laserName = new String[this.lasers];
        for (i = 1; i <= this.lasers; ++i) {
            this.laserASF[i - 1] = this.settings.getProperty("LASER" + i + "ASF");
            this.laserDelay[i - 1] = this.settings.getProperty("LASER" + i + "DELAY");
            this.laserName[i - 1] = this.settings.getProperty("LASER" + i + "NAME");
        }
        block35: for (i = 1; i <= this.parameters; ++i) {
            this.channelShortname[i - 1] = this.settings.getProperty("$P" + i + "N");
            this.channelName[i - 1] = this.settings.getProperty("$P" + i + "S");
            if (this.channelName[i - 1] == null) {
                this.channelName[i - 1] = this.channelShortname[i - 1];
            }
            this.channelGain[i - 1] = this.settings.getProperty("$P" + i + "G");
            try {
                this.channelBits[i - 1] = Integer.parseInt(this.settings.getProperty("$P" + i + "B"));
            }
            catch (NumberFormatException nfe) {
                if (this.dataType != null) {
                    if (this.dataType.equalsIgnoreCase("I")) {
                        this.channelBits[i - 1] = 16;
                    } else if (this.dataType.equalsIgnoreCase("F")) {
                        this.channelBits[i - 1] = 32;
                    } else if (this.dataType.equalsIgnoreCase("D")) {
                        this.channelBits[i - 1] = 64;
                    } else if (this.dataType.equalsIgnoreCase("A")) {
                        this.channelBits[i - 1] = 8;
                    }
                }
                this.channelBits[i - 1] = 0;
            }
            this.channelAmp[i - 1] = this.settings.getProperty("$P" + i + "E");
            this.displayLog[i - 1] = false;
            String displayString = this.settings.getProperty("P" + i + "DISPLAY");
            if (displayString != null && displayString.equalsIgnoreCase("log")) {
                this.displayLog[i - 1] = true;
            }
            if (this.channelAmp[i - 1] != null) {
                String[] ampArray = this.channelAmp[i - 1].split(",");
                try {
                    this.ampValue[i - 1] = Double.parseDouble(ampArray[0]);
                }
                catch (NumberFormatException nfe4) {
                    this.ampValue[i - 1] = 0.0;
                }
            } else {
                this.ampValue[i - 1] = 0.0;
            }
            this.isLog[i - 1] = this.ampValue[i - 1] > 0.0;
            try {
                this.channelRange[i - 1] = Double.parseDouble(this.settings.getProperty("$P" + i + "R"));
            }
            catch (NumberFormatException nfe5) {
                this.channelRange[i - 1] = 0.0;
            }
            this.channelVoltage[i - 1] = this.settings.getProperty("$P" + i + "V");
            if (this.channelVoltage[i - 1] != null || this.cytometer == null || !this.cytometer.equals("FACSCalibur")) continue;
            switch (i - 1) {
                case 2: {
                    this.channelVoltage[i - 1] = this.settings.getProperty("BD$WORD3");
                    continue block35;
                }
                case 3: {
                    this.channelVoltage[i - 1] = this.settings.getProperty("BD$WORD5");
                    continue block35;
                }
                case 4: {
                    this.channelVoltage[i - 1] = this.settings.getProperty("BD$WORD7");
                    continue block35;
                }
                case 5: {
                    this.channelVoltage[i - 1] = this.settings.getProperty("BD$WORD9");
                    continue block35;
                }
                case 6: {
                    this.channelVoltage[i - 1] = this.settings.getProperty("BD$WORD11");
                    continue block35;
                }
                case 7: {
                    this.channelVoltage[i - 1] = this.settings.getProperty("BD$WORD55");
                    continue block35;
                }
                case 8: {
                    this.channelVoltage[i - 1] = this.settings.getProperty("BD$WORD24");
                    continue block35;
                }
                default: {
                    this.channelVoltage[i - 1] = "";
                }
            }
        }
        int numBitsPerEvent = 0;
        for (int i2 = 0; i2 < this.parameters; ++i2) {
            numBitsPerEvent += this.channelBits[i2];
        }
        if (numBitsPerEvent > 0 && this.totalEvents > (calculatedNumEvents = (this.dataEnd - this.dataStart + 1) * 8 / numBitsPerEvent)) {
            this.totalEvents = calculatedNumEvents;
        }
    }

    private void extractEvents() throws FileNotFoundException, IOException {
        if (this.dataStart >= this.dataEnd || this.totalEvents <= 0) {
            this.eventList = new int[0][this.parameters];
            return;
        }
        FileInputStream fis = new FileInputStream(this.file);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer data = fc.map(FileChannel.MapMode.READ_ONLY, this.dataStart, this.dataEnd - this.dataStart + 1);
        if (this.dataType != null) {
            if (this.dataType.equalsIgnoreCase("I")) {
                this.readBinIntData(data);
            } else if (this.dataType.equalsIgnoreCase("F")) {
                this.readFloatData(data);
            } else if (this.dataType.equalsIgnoreCase("D")) {
                this.readDoubleData(data);
            } else if (this.dataType.equalsIgnoreCase("A")) {
                this.readASCIIData(data);
            }
        }
        fc.close();
        fis.close();
    }

    private void readBinIntData(ByteBuffer data) {
        this.eventList = new int[this.totalEvents][this.parameters];
        for (int i = 0; i < this.totalEvents; ++i) {
            for (int j = 0; j < this.parameters; ++j) {
                int k;
                int numBytes = this.channelBits[j] / 8;
                int range = (int)this.channelRange[j];
                int value = 0;
                if (this.littleEndianP) {
                    for (k = 0; k < numBytes; ++k) {
                        int currByte = data.get() & 0xFF;
                        value |= (currByte <<= 8 * k);
                    }
                } else {
                    for (k = 0; k < numBytes; ++k) {
                        value <<= 8;
                        value |= data.get() & 0xFF;
                    }
                }
                this.eventList[i][j] = value &= range - 1;
            }
        }
    }

    private void readFloatData(ByteBuffer data) {
        this.eventList = new int[this.totalEvents][this.parameters];
        if (this.littleEndianP) {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        FloatBuffer fb = data.asFloatBuffer();
        for (int i = 0; i < this.totalEvents; ++i) {
            for (int j = 0; j < this.parameters; ++j) {
                this.eventList[i][j] = (int)fb.get();
            }
        }
    }

    private void readDoubleData(ByteBuffer data) {
        this.eventList = new int[this.totalEvents][this.parameters];
        if (this.littleEndianP) {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        DoubleBuffer db = data.asDoubleBuffer();
        for (int i = 0; i < this.totalEvents; ++i) {
            for (int j = 0; j < this.parameters; ++j) {
                this.eventList[i][j] = (int)db.get();
            }
        }
    }

    private void readASCIIData(ByteBuffer data) {
        int numCharsPerEvent = 0;
        for (int i = 0; i < this.parameters; ++i) {
            numCharsPerEvent += this.channelBits[i];
        }
        this.eventList = new int[this.totalEvents][this.parameters];
        CharBuffer cb = data.asCharBuffer();
        int currChar = 0;
        for (int i = 0; i < this.totalEvents; ++i) {
            for (int j = 0; j < this.parameters; ++j) {
                try {
                    this.eventList[i][j] = Integer.parseInt(((Object)cb.subSequence(currChar, currChar + this.channelBits[i])).toString());
                }
                catch (NumberFormatException nfe) {
                    this.eventList[i][j] = 0;
                }
                currChar += this.channelBits[i];
            }
        }
    }

    public int[][] getEventList() {
        if (this.eventList == null) {
            try {
                this.extractEvents();
            }
            catch (FileNotFoundException fnfe) {
                return new int[0][0];
            }
            catch (IOException ioe) {
                return new int[0][0];
            }
        }
        return this.eventList;
    }

    public boolean isFCS() {
        return this.isFCSP;
    }

    public String getVersion() {
        return this.version;
    }

    public int getTextStart() {
        return this.textStart;
    }

    public int getTextEnd() {
        return this.textEnd;
    }

    public int getDataStart() {
        return this.dataStart;
    }

    public int getDataEnd() {
        return this.dataEnd;
    }

    public int getAnalysisStart() {
        return this.analysisStart;
    }

    public int getAnalysisEnd() {
        return this.analysisEnd;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getText() {
        return this.text;
    }

    public String getCytometer() {
        return this.cytometer;
    }

    private int getChannelHelper(boolean sideScatterP) {
        if (this.channelName == null || this.channelShortname == null) {
            return -1;
        }
        for (int i = 0; i < this.parameters; ++i) {
            if (this.channelName[i] == null) continue;
            if (sideScatterP) {
                if (this.channelName[i].indexOf("Side Scatter") >= 0) {
                    return i;
                }
                if (!this.channelName[i].startsWith("SS") && (this.channelShortname[i] == null || !this.channelName[i].startsWith("SS"))) continue;
                return i;
            }
            if (this.channelName[i].indexOf("Forward Scatter") >= 0) {
                return i;
            }
            if (!this.channelName[i].startsWith("FS") && (this.channelShortname[i] == null || !this.channelName[i].startsWith("FS"))) continue;
            return i;
        }
        return -1;
    }

    public int getForwardScatterChannel() {
        return this.getChannelHelper(false);
    }

    public int getSideScatterChannel() {
        return this.getChannelHelper(true);
    }

    public String getChannelName(int channelNumber) {
        if (this.channelName == null || this.channelShortname == null || channelNumber < 0 || channelNumber >= this.getNumChannels()) {
            return "Error reading this channel!";
        }
        if (this.channelName[channelNumber] == null) {
            if (this.channelShortname[channelNumber] == null) {
                return "Channel " + channelNumber;
            }
            return this.channelShortname[channelNumber];
        }
        return this.channelName[channelNumber];
    }

    public int getChannelCount() {
        return this.parameters;
    }

    public int getNumChannels() {
        return this.getChannelCount();
    }

    public boolean isLog(int channelNumber) {
        if (this.isLog != null && channelNumber >= 0 && channelNumber < this.isLog.length) {
            return this.isLog[channelNumber];
        }
        return false;
    }

    public boolean getIsLog(int channelNumber) {
        return this.isLog(channelNumber);
    }

    public boolean isDisplayLog(int channelNumber) {
        if (this.displayLog != null && channelNumber >= 0 && channelNumber < this.displayLog.length) {
            return this.displayLog[channelNumber];
        }
        return false;
    }

    public boolean getDisplayLog(int channelNumber) {
        return this.isDisplayLog(channelNumber);
    }

    public double getAmpValue(int channelNumber) {
        if (this.ampValue != null && channelNumber >= 0 && channelNumber < this.ampValue.length) {
            return this.ampValue[channelNumber];
        }
        return 0.0;
    }

    public double getChannelRange(int channelNumber) {
        if (this.channelRange != null && channelNumber >= 0 && channelNumber < this.channelRange.length) {
            return this.channelRange[channelNumber];
        }
        return 0.0;
    }

    public double getScaleRange(int channelNumber) {
        if (this.getIsLog(channelNumber)) {
            return Math.pow(10.0, this.getAmpValue(channelNumber));
        }
        return this.getChannelRange(channelNumber);
    }

    public boolean getAmpDisplay(int channelNumber) {
        return !this.getIsLog(channelNumber) && this.getDisplayLog(channelNumber);
    }

    public Properties getSettings() {
        return this.settings;
    }

    public int getEventCount() {
        return this.totalEvents;
    }

    public double[][] getCompensation() {
        if (this.settings == null || this.parameters <= 0) {
            return new double[0][0];
        }
        String compString = this.settings.getProperty("$COMP");
        if (compString == null) {
            return new double[0][0];
        }
        int numParameters = this.parameters;
        String[] compValues = compString.split(",");
        int n = 0;
        try {
            n = Integer.parseInt(compValues[0]);
        }
        catch (NumberFormatException nfe) {
            return new double[0][0];
        }
        if (n <= 0 || compValues.length < n * n + 1) {
            return new double[0][0];
        }
        double[][] matrix = new double[n][n];
        for (int i = 1; i < compValues.length; ++i) {
            int row = (i - 1) / numParameters;
            int column = (i - 1) % numParameters;
            if (row >= n || column >= n) continue;
            try {
                matrix[row][column] = Double.parseDouble(compValues[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                matrix[row][column] = 0.0;
            }
        }
        return matrix;
    }

    public String getSpillString() {
        return this.spillString;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public long length() {
        return this.file.length();
    }

    public static boolean isFCSFile(File file) throws FileNotFoundException, IOException {
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] versionArray = new byte[6];
        int numRead = fis.read(versionArray);
        fis.close();
        if (numRead < 6) {
            return false;
        }
        String version = new String(versionArray);
        return version.startsWith(FCS_PREFIX);
    }

    public static void printFCSFile(fcsFile f) {
        System.out.println("Version ID -=" + f.version + "=-");
        System.out.println("Text starts at -=" + f.textStart + "=-");
        System.out.println("Text ends at -=" + f.textEnd + "=-");
        System.out.println("Data starts at -=" + f.dataStart + "=-");
        System.out.println("Data ends at -=" + f.dataEnd + "=-");
        System.out.println("Analysis starts at -=" + f.analysisStart + "=-");
        System.out.println("Analysis ends at -=" + f.analysisEnd + "=-");
        System.out.println("Text delimiter -=" + Character.toString(f.delimiter) + "=-");
        System.out.println("Data type -=" + f.dataType + "=-");
        System.out.println("Cytometer -=" + f.cytometer + "=-");
        System.out.println("Lasers -=" + f.lasers + "=-");
        f.printEvents(50);
    }

    private void printEvents(int numEvents) {
        int i;
        if (this.eventList == null) {
            return;
        }
        System.out.println("The events (Count: " + numEvents + "):");
        for (i = 0; i < this.parameters; ++i) {
            System.out.print("\t" + this.channelShortname[i]);
        }
        System.out.println();
        for (i = 0; i < numEvents; ++i) {
            System.out.print("Event " + (i + 1) + ":");
            for (int j = 0; j < this.parameters; ++j) {
                System.out.print("\t" + this.eventList[i][j]);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.out.println("Usage:");
            System.out.println("---");
            System.out.println(">java fcsFile <path to FCS file>");
            System.exit(0);
        }
        try {
            System.out.println("Checking \"" + args[0] + "\" ...");
            fcsFile f = args.length > 1 ? new fcsFile(args[0], true) : new fcsFile(args[0], false);
            if (f.isFCS()) {
                System.out.println("\"" + args[0] + "\" is an FCS file.");
                fcsFile.printFCSFile(f);
            } else {
                System.out.println("\"" + args[0] + "\" is not an FCS file.");
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }
}

